/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ElimStorePlain;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class DualJunctionSaa
extends DualJunctionQuantifierElimination {
    private static final boolean PRENEX_NORMAL_FORM_FOR_INNERQUANTIFIERS = true;
    private final boolean mExpensiveEliminations;

    public DualJunctionSaa(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, boolean bl) {
        super(managedScript, iUltimateServiceProvider);
        this.mExpensiveEliminations = bl;
    }

    @Override
    public String getName() {
        return "smart array ackermanization";
    }

    @Override
    public String getAcronym() {
        return "saa";
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask eliminationTask) {
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = this.tryExhaustivelyToEliminate(eliminationTask);
        return eliminationResult;
    }

    public DualJunctionQuantifierElimination.EliminationResult tryExhaustivelyToEliminate(EliminationTask eliminationTask) {
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = this.tryToEliminateOne(eliminationTask);
        if (eliminationResult == null) {
            return null;
        }
        return eliminationResult;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(EliminationTask eliminationTask) {
        for (TermVariable termVariable : eliminationTask.getEliminatees()) {
            EliminationTask eliminationTask2;
            DualJunctionQuantifierElimination.EliminationResult eliminationResult;
            if (!SmtSortUtils.isArraySort(termVariable.getSort()) || (eliminationResult = this.tryToEliminateOne0(eliminationTask2 = new EliminationTask(eliminationTask.getQuantifier(), Collections.singleton(termVariable), eliminationTask.getTerm(), eliminationTask.getContext()))) == null) continue;
            assert (eliminationTask.getContext() == eliminationResult.getEliminationTask().getContext()) : "illegal change of context";
            return new DualJunctionQuantifierElimination.EliminationResult(eliminationResult.getEliminationTask().update(eliminationTask.getEliminatees(), eliminationResult.getEliminationTask().getTerm()), eliminationResult.getNewEliminatees());
        }
        return null;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne0(EliminationTask eliminationTask) {
        Pair<Term, EliminationTask> pair = eliminationTask.makeTight(this.mServices, this.mMgdScript);
        if (pair == null) {
            return this.tryToEliminateOne1(eliminationTask);
        }
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = this.tryToEliminateOne1((EliminationTask)pair.getSecond());
        if (eliminationResult == null) {
            return null;
        }
        Term term = QuantifierUtils.applyDualFiniteConnective(this.mScript, eliminationTask.getQuantifier(), (Term)pair.getFirst(), eliminationResult.getEliminationTask().getTerm());
        EliminationTask eliminationTask2 = new EliminationTask(eliminationTask.getQuantifier(), eliminationTask.getEliminatees(), term, eliminationTask.getContext());
        return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask2, eliminationResult.getNewEliminatees());
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne1(EliminationTask eliminationTask) {
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = this.tryToEliminateOne2(eliminationTask);
        return eliminationResult;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne2(EliminationTask eliminationTask) {
        Term term = new PrenexNormalForm(this.mMgdScript).transform(eliminationTask.getTerm());
        QuantifierSequence quantifierSequence = new QuantifierSequence(this.mMgdScript, term);
        EliminationTask eliminationTask2 = eliminationTask.update(quantifierSequence.getInnerTerm());
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = this.tryToEliminateOne3(eliminationTask2);
        if (eliminationResult == null) {
            return null;
        }
        if (quantifierSequence.getQuantifierBlocks().isEmpty()) {
            return eliminationResult;
        }
        EliminationTask eliminationTask3 = eliminationResult.integrateNewEliminatees();
        QuantifierSequence quantifierSequence2 = new QuantifierSequence(this.mMgdScript, eliminationTask3.toTerm(this.mMgdScript.getScript()), quantifierSequence.getQuantifierBlocks());
        Term term2 = quantifierSequence2.toTerm();
        return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask3.update(term2), Collections.emptySet());
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne3(EliminationTask eliminationTask) {
        EliminationTask eliminationTask2 = this.tryToEliminate(eliminationTask.getQuantifier(), eliminationTask.getTerm(), eliminationTask.getContext(), eliminationTask.getEliminatees().iterator().next());
        if (eliminationTask2 == null) {
            return null;
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(eliminationTask2.getEliminatees());
        hashSet.removeAll(eliminationTask.getEliminatees());
        return new DualJunctionQuantifierElimination.EliminationResult(new EliminationTask(eliminationTask2.getQuantifier(), eliminationTask.getEliminatees(), eliminationTask2.getTerm(), eliminationTask.getContext()), hashSet);
    }

    private EliminationTask tryToEliminate(int n, Term term, Context context, TermVariable termVariable) {
        EliminationTask eliminationTask;
        EliminationTask eliminationTask2 = new EliminationTask(n, Collections.singleton(termVariable), term, context);
        try {
            eliminationTask = ElimStorePlain.applyComplexEliminationRules(this.mServices, this.mLogger, this.mMgdScript, eliminationTask2);
        }
        catch (SMTLIBException sMTLIBException) {
            throw new AssertionError((Object)sMTLIBException);
        }
        catch (ElimStorePlain.ElimStorePlainException elimStorePlainException) {
            if (elimStorePlainException.getMessage().equals("DER that is not on top-level")) {
                eliminationTask = null;
            }
            if (elimStorePlainException.getMessage().equals("Subterm of an index is captued by an inner quantifier")) {
                throw new AssertionError((Object)"Captured index although handling of inner quantfiers is set");
            }
            throw new AssertionError((Object)elimStorePlainException);
        }
        if (eliminationTask != null && Arrays.asList(eliminationTask.getTerm().getFreeVars()).contains(termVariable)) {
            throw new AssertionError((Object)("Var not eliminated: " + String.valueOf(termVariable) + " " + String.valueOf(eliminationTask2.toTerm(this.mScript))));
        }
        return eliminationTask;
    }
}

