/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisDepthCodeGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionAvt;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionDml;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQeAdapter2014;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionSaa;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionTir;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushUtilsForSubsetPush;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfIrd;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfPlr;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfScout;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfTir;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfUpd;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QuantifierPusher
extends TermTransformer {
    private static final boolean DEBUG_CHECK_RESULT = false;
    private final Script mScript;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final PqeTechniques mPqeTechniques;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final Set<TermVariable> mBannedForDivCapture;
    private final boolean mApplyDistributivity;

    private QuantifierPusher(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, boolean bl, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Set<TermVariable> set) {
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
        this.mScript = managedScript.getScript();
        this.mApplyDistributivity = bl;
        this.mPqeTechniques = pqeTechniques;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mBannedForDivCapture = set;
    }

    @Deprecated
    public static Term eliminate(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Set<TermVariable> set, Term term) {
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(QuantifierPusher.class);
        SmtUtils.ExtendedSimplificationResult extendedSimplificationResult = SmtUtils.simplifyWithStatistics(managedScript, term, iUltimateServiceProvider, SmtUtils.SimplificationTechnique.POLY_PAC);
        iLogger.info((Object)extendedSimplificationResult.buildSizeReductionMessage());
        Term term2 = new QuantifierPusher(managedScript, iUltimateServiceProvider, bl, pqeTechniques, simplificationTechnique, set).transform(extendedSimplificationResult.getSimplifiedTerm());
        SmtUtils.ExtendedSimplificationResult extendedSimplificationResult2 = SmtUtils.simplifyWithStatistics(managedScript, term2, iUltimateServiceProvider, SmtUtils.SimplificationTechnique.POLY_PAC);
        iLogger.info((Object)(extendedSimplificationResult2.buildSizeReductionMessage() + " " + new DAGSize().treesize(extendedSimplificationResult2.getSimplifiedTerm())));
        return term2;
    }

    public static Term eliminate(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Context context, Term term) {
        iUltimateServiceProvider.getLoggingService().getLogger(QuantifierPusher.class).warn((Object)"Ignoring assumption.");
        return QuantifierPusher.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, term);
    }

    public static Term eliminate(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Term term) {
        return QuantifierPusher.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, Collections.emptySet(), term);
    }

    protected void convert(Term term) {
        FormulaClassification formulaClassification = null;
        Object object = term;
        block8: while (true) {
            formulaClassification = QuantifierPusher.classify(object);
            switch (formulaClassification) {
                case NOT_QUANTIFIED: {
                    super.convert(object);
                    return;
                }
                case SAME_QUANTIFIER: {
                    object = QuantifierUtils.flattenQuantifiers(this.mScript, (QuantifiedFormula)object);
                    continue block8;
                }
                case DUAL_QUANTIFIER: {
                    EliminationTask eliminationTask = new EliminationTask((QuantifiedFormula)object, new Context(this.mMgdScript.term(null, "true", new Term[0]), this.mBannedForDivCapture));
                    Term term2 = QuantifierPusher.processDualQuantifier(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, eliminationTask, QuantifierPusher::eliminate);
                    FormulaClassification formulaClassification2 = QuantifierPusher.classify(term2);
                    if (formulaClassification2 == FormulaClassification.DUAL_QUANTIFIER) {
                        this.setResult(term2);
                        return;
                    }
                    object = term2;
                    continue block8;
                }
                case CORRESPONDING_FINITE_CONNECTIVE: {
                    object = QuantifierPusher.pushOverCorrespondingFiniteConnective(this.mScript, (QuantifiedFormula)object);
                    assert (object != null) : "corresponding connective case must never fail";
                    continue block8;
                }
                case ATOM: {
                    Term term2;
                    EliminationTask eliminationTask = QuantifierPusher.applyEliminationToAtom(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, new Context(this.mMgdScript.term(null, "true", new Term[0]), this.mBannedForDivCapture), (QuantifiedFormula)object);
                    if (eliminationTask == null) {
                        term2 = QuantifierPusher.pushInner(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, this.mBannedForDivCapture, (QuantifiedFormula)object, this.mMgdScript.term(null, "true", new Term[0]), QuantifierPusher::eliminate);
                        this.setResult(term2);
                        return;
                    }
                    object = eliminationTask;
                    continue block8;
                }
                case DUAL_FINITE_CONNECTIVE: {
                    FormulaClassification formulaClassification2;
                    EliminationTask eliminationTask = new EliminationTask((QuantifiedFormula)object, new Context(this.mMgdScript.term(null, "true", new Term[0]), this.mBannedForDivCapture));
                    Term term2 = QuantifierPusher.tryToPushOverDualFiniteConnective(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, eliminationTask, QuantifierPusher::eliminate);
                    if (term2 == null) {
                        formulaClassification2 = QuantifierPusher.pushInner(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, this.mBannedForDivCapture, (QuantifiedFormula)object, this.mMgdScript.term(null, "true", new Term[0]), QuantifierPusher::eliminate);
                        this.setResult((Term)formulaClassification2);
                        return;
                    }
                    object = term2;
                    continue block8;
                }
            }
            break;
        }
        throw new AssertionError((Object)("unknown value " + String.valueOf((Object)formulaClassification)));
    }

    public static Term pushInner(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Set<TermVariable> set, QuantifiedFormula quantifiedFormula, Term term, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator) {
        Context context = new Context(term, set);
        Context context2 = context.constructChildContextForQuantifiedFormula(managedScript.getScript(), Arrays.asList(quantifiedFormula.getVariables()));
        Term term2 = iQuantifierEliminator.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, context2, quantifiedFormula.getSubformula());
        Term term3 = SmtUtils.quantifier(managedScript.getScript(), quantifiedFormula.getQuantifier(), new HashSet<TermVariable>(Arrays.asList(quantifiedFormula.getVariables())), term2);
        return term3;
    }

    public static Term applyEliminationToAtom(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, PqeTechniques pqeTechniques, Context context, QuantifiedFormula quantifiedFormula) {
        EliminationTask eliminationTask = new EliminationTask(quantifiedFormula, context);
        Term term = eliminationTask.getEliminatees().size() < quantifiedFormula.getVariables().length ? eliminationTask.toTerm(managedScript.getScript()) : QuantifierPusher.applyDualJunctionEliminationTechniques(eliminationTask, managedScript, iUltimateServiceProvider, pqeTechniques);
        return term;
    }

    public static Term pushOverCorrespondingFiniteConnective(Script script, QuantifiedFormula quantifiedFormula) {
        assert (quantifiedFormula.getSubformula() instanceof ApplicationTerm);
        ApplicationTerm applicationTerm = (ApplicationTerm)quantifiedFormula.getSubformula();
        assert (applicationTerm.getFunction().getApplicationString().equals(SmtUtils.getCorrespondingFiniteConnective(quantifiedFormula.getQuantifier())));
        Term[] termArray = applicationTerm.getParameters();
        Term[] termArray2 = new Term[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            termArray2[n] = SmtUtils.quantifier(script, quantifiedFormula.getQuantifier(), new HashSet<TermVariable>(Arrays.asList(quantifiedFormula.getVariables())), termArray[n]);
            ++n;
        }
        return script.term(applicationTerm.getFunction().getName(), termArray2);
    }

    public static Term tryToPushOverDualFiniteConnective(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask eliminationTask, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator) {
        Pair<Boolean, Term> pair = QuantifierPushUtils.preprocessDualFiniteJunction(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, eliminationTask, iQuantifierEliminator, false, true);
        if (!((Boolean)pair.getFirst()).booleanValue()) {
            return (Term)pair.getSecond();
        }
        EliminationTask eliminationTask2 = new EliminationTask((QuantifiedFormula)pair.getSecond(), eliminationTask.getContext());
        Term term = QuantifierPusher.applyDualJunctionEliminationTechniques(eliminationTask2, managedScript, iUltimateServiceProvider, pqeTechniques);
        if (term != null) {
            return term;
        }
        if (!bl) {
            return null;
        }
        Term term2 = QuantifierPushUtilsForSubsetPush.sequentialSubsetPush(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, eliminationTask2, iQuantifierEliminator);
        if (term2 != null) {
            return term2;
        }
        return QuantifierPusher.applyDistributivityAndPush(iUltimateServiceProvider, managedScript, pqeTechniques, simplificationTechnique, eliminationTask2, iQuantifierEliminator, true, false);
    }

    private static boolean isDualFiniteConnective(EliminationTask eliminationTask) {
        if (eliminationTask.getTerm() instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)eliminationTask.getTerm();
            return applicationTerm.getFunction().getApplicationString().equals(SmtUtils.getCorrespondingFiniteConnective(SmtUtils.getOtherQuantifier(eliminationTask.getQuantifier())));
        }
        return false;
    }

    public static Term applyDistributivityAndPush(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask eliminationTask, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator, boolean bl, boolean bl2) {
        int n;
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        if (termArray.length == 1) {
            throw new AssertionError((Object)"No dual finite junction");
        }
        if (bl && (n = XnfScout.computeRecommendation(managedScript.getScript(), eliminationTask.getEliminatees(), termArray, eliminationTask.getQuantifier())) != -1) {
            Term term = QuantifierPusher.applyDistributivityAndPushOneStep(iUltimateServiceProvider, managedScript, eliminationTask.getQuantifier(), eliminationTask.getEliminatees(), eliminationTask.getContext(), termArray, n);
            return term;
        }
        n = 0;
        while (n < termArray.length) {
            if (QuantifierPusher.isCorrespondingFinite(termArray[n], eliminationTask.getQuantifier())) {
                List<TermVariable> list = Arrays.asList(termArray[n].getFreeVars());
                if (DataStructureUtils.intersection(new HashSet<TermVariable>(list), eliminationTask.getEliminatees()).isEmpty()) {
                    throw new AssertionError((Object)"Useless application of distibutivity, no eliminatee involved.");
                }
                Term term = QuantifierPusher.applyDistributivityAndPushOneStep(iUltimateServiceProvider, managedScript, eliminationTask.getQuantifier(), eliminationTask.getEliminatees(), eliminationTask.getContext(), termArray, n);
                if (!bl2) {
                    return term;
                }
                Term term2 = iQuantifierEliminator.eliminate(iUltimateServiceProvider, managedScript, true, pqeTechniques, simplificationTechnique, eliminationTask.getContext(), term);
                if (QuantifierPusher.allStillQuantified(eliminationTask.getEliminatees(), term2)) {
                    return null;
                }
                return term2;
            }
            ++n;
        }
        return null;
    }

    private Map<TermVariable, Long> computeTreesizeOfInhabitedParams(List<TermVariable> list, List<Term> list2) {
        List list3 = list2.stream().map(term -> new DAGSize().treesize(term)).collect(Collectors.toList());
        HashMap<TermVariable, Long> hashMap = new HashMap<TermVariable, Long>();
        for (TermVariable termVariable : list) {
            long l = 0L;
            int n = 0;
            while (n < list2.size()) {
                if (Arrays.asList(list2.get(n).getFreeVars()).contains(termVariable)) {
                    l += ((Long)list3.get(n)).longValue();
                }
                ++n;
            }
            hashMap.put(termVariable, l);
        }
        return hashMap;
    }

    private static List<TermVariable> remaningEliminateeThatDoNotOccurInAllParams(List<TermVariable> list, List<Term> list2) {
        return list.stream().filter(termVariable -> list2.stream().anyMatch(term -> !Arrays.asList(term.getFreeVars()).contains(termVariable))).collect(Collectors.toList());
    }

    public static List<TermVariable> determineMinionEliminatees(Collection<TermVariable> collection, List<Term> list) {
        return collection.stream().filter(termVariable -> list.stream().allMatch(term -> !Arrays.asList(term.getFreeVars()).contains(termVariable))).collect(Collectors.toList());
    }

    private static boolean allStillQuantified(Set<TermVariable> set, Term term2) {
        Set<Term> set2 = SubTermFinder.find(term2, term -> term instanceof QuantifiedFormula, false);
        Set set3 = set2.stream().map(term -> ((QuantifiedFormula)term).getVariables()).flatMap(termVariableArray -> Stream.of(termVariableArray)).collect(Collectors.toSet());
        return set3.containsAll(set);
    }

    private static Term applyDistributivityAndPushOneStep(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, int n, Set<TermVariable> set, Context context, Term[] termArray, int n2) {
        Term term;
        Term[] termArray2 = QuantifierUtils.getCorrespondingFiniteJuncts(n, termArray[n2]);
        ArrayList<Term> arrayList = new ArrayList<Term>(termArray.length - 1);
        int n3 = 0;
        while (n3 < termArray.length) {
            if (n3 != n2) {
                arrayList.add(termArray[n3]);
            }
            ++n3;
        }
        Term[] termArray3 = new Term[termArray2.length];
        int n4 = 0;
        Term[] termArray4 = termArray2;
        int n5 = termArray2.length;
        int n6 = 0;
        while (n6 < n5) {
            term = termArray4[n6];
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            arrayList2.add(term);
            arrayList2.addAll(arrayList);
            termArray3[n4] = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), n, arrayList2);
            termArray3[n4] = SmtUtils.quantifier(managedScript.getScript(), n, set, termArray3[n4]);
            ++n4;
            ++n6;
        }
        term = iUltimateServiceProvider.getLoggingService().getLogger(QuantifierPusher.class);
        if (term.isDebugEnabled()) {
            CondisDepthCodeGenerator.CondisDepthCode condisDepthCode = CondisDepthCodeGenerator.CondisDepthCode.of(QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), n, termArray));
            String string = "Distributing " + termArray3.length + " " + QuantifierUtils.getNameOfCorrespondingJuncts(n) + " over " + termArray.length + " " + QuantifierUtils.getNameOfDualJuncts(n) + ". Applying distributivity to a " + String.valueOf(condisDepthCode) + " term";
            term.info((Object)string);
        }
        Term term2 = QuantifierUtils.applyCorrespondingFiniteConnective(managedScript.getScript(), n, termArray3);
        Term term3 = QuantifierPusher.simplify(iUltimateServiceProvider, managedScript, SimplificationOccasion.AFTER_DISTRIBTIVITY, SmtUtils.SimplificationTechnique.POLY_PAC, context, term2);
        return term3;
    }

    private static boolean isCorrespondingFinite(Term term, int n) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getApplicationString().equals(SmtUtils.getCorrespondingFiniteConnective(n));
        }
        return false;
    }

    private static Term applyDualJunctionEliminationTechniques(EliminationTask eliminationTask, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, PqeTechniques pqeTechniques) {
        return QuantifierPusher.applyNewEliminationTechniquesExhaustively(iUltimateServiceProvider, managedScript, pqeTechniques, eliminationTask);
    }

    private static Term applyNewEliminationTechniquesExhaustively(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, PqeTechniques pqeTechniques, EliminationTask eliminationTask) {
        List<DualJunctionQuantifierElimination> list = QuantifierPusher.generateNewEliminationTechniques(pqeTechniques, managedScript, iUltimateServiceProvider);
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = QuantifierPusher.tryToEliminateOne(iUltimateServiceProvider, eliminationTask, list);
        if (eliminationResult == null) {
            return null;
        }
        EliminationTask eliminationTask2 = eliminationResult.integrateNewEliminatees();
        assert (eliminationTask2.getContext() == eliminationTask.getContext()) : "Illegal modification of context";
        Term term = QuantifierPusher.simplify(iUltimateServiceProvider, managedScript, SimplificationOccasion.AFTER_ELIMINATION_TECHNIQUES, SmtUtils.SimplificationTechnique.POLY_PAC, eliminationTask2.getContext(), eliminationTask2.getTerm());
        eliminationTask2 = eliminationTask2.update(term);
        return eliminationTask2.toTerm(managedScript.getScript());
    }

    private static DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(IUltimateServiceProvider iUltimateServiceProvider, EliminationTask eliminationTask, List<DualJunctionQuantifierElimination> list) {
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(QuantifierPusher.class);
        for (DualJunctionQuantifierElimination dualJunctionQuantifierElimination : list) {
            DualJunctionQuantifierElimination.EliminationResult eliminationResult = dualJunctionQuantifierElimination.tryToEliminate(eliminationTask);
            if (iLogger.isDebugEnabled()) {
                CondisDepthCodeGenerator.CondisDepthCode condisDepthCode = CondisDepthCodeGenerator.CondisDepthCode.of(eliminationTask.getTerm());
                CondisDepthCodeGenerator.CondisDepthCode condisDepthCode2 = CondisDepthCodeGenerator.CondisDepthCode.of(eliminationTask.getContext().getCriticalConstraint());
                if (eliminationResult != null) {
                    HashSet<TermVariable> hashSet = new HashSet<TermVariable>(eliminationTask.getEliminatees());
                    hashSet.removeAll(eliminationResult.getEliminationTask().getEliminatees());
                    iLogger.debug((Object)String.format("Applying %s to %s term with %s context. Eliminated %s Introduced %s", dualJunctionQuantifierElimination.getAcronym(), condisDepthCode, condisDepthCode2, hashSet, eliminationResult.getNewEliminatees()));
                } else {
                    iLogger.debug((Object)String.format("Applying %s to %s term with %s context. Could not eliminate any variable %s", dualJunctionQuantifierElimination.getAcronym(), condisDepthCode, condisDepthCode2, eliminationTask.getEliminatees()));
                }
            }
            if (eliminationResult == null) continue;
            if (eliminationResult.getEliminationTask().getEliminatees().equals(eliminationTask.getEliminatees())) {
                iLogger.warn((Object)"no eliminatee completely removed, nonetheless the elimination was considered successful");
            }
            return eliminationResult;
        }
        return null;
    }

    @Deprecated
    private List<DualJunctionQuantifierElimination> generateOldEliminationTechniquesWithAdapter(PqeTechniques pqeTechniques, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        ArrayList<DualJunctionQuantifierElimination> arrayList = new ArrayList<DualJunctionQuantifierElimination>();
        switch (pqeTechniques) {
            case ALL_LOCAL: {
                new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, null);
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfPlr(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfDer(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfIrd(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfTir(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfUpd(managedScript, iUltimateServiceProvider)));
                break;
            }
            case NO_UPD: {
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfPlr(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfDer(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfIrd(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfTir(managedScript, iUltimateServiceProvider)));
                break;
            }
            case ONLY_DER: {
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfDer(managedScript, iUltimateServiceProvider)));
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + String.valueOf((Object)pqeTechniques)));
            }
        }
        return arrayList;
    }

    private static List<DualJunctionQuantifierElimination> generateNewEliminationTechniques(PqeTechniques pqeTechniques, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        ArrayList<DualJunctionQuantifierElimination> arrayList = new ArrayList<DualJunctionQuantifierElimination>();
        switch (pqeTechniques) {
            case ALL: {
                arrayList.add(new DualJunctionDer(managedScript, iUltimateServiceProvider, false));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfIrd(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionTir(managedScript, iUltimateServiceProvider, true));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfUpd(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionDml(managedScript, iUltimateServiceProvider));
                arrayList.add(new DualJunctionAvt(managedScript, iUltimateServiceProvider, true));
                arrayList.add(new DualJunctionSaa(managedScript, iUltimateServiceProvider, true));
                break;
            }
            case ALL_LOCAL: {
                arrayList.add(new DualJunctionDer(managedScript, iUltimateServiceProvider, false));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfIrd(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionTir(managedScript, iUltimateServiceProvider, false));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfUpd(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionDer(managedScript, iUltimateServiceProvider, true));
                break;
            }
            case NO_UPD: {
                arrayList.add(new DualJunctionDer(managedScript, iUltimateServiceProvider, false));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfIrd(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionTir(managedScript, iUltimateServiceProvider, false));
                arrayList.add(new DualJunctionDer(managedScript, iUltimateServiceProvider, true));
                break;
            }
            case ONLY_DER: {
                arrayList.add(new DualJunctionDer(managedScript, iUltimateServiceProvider, false));
                arrayList.add(new DualJunctionDer(managedScript, iUltimateServiceProvider, true));
                break;
            }
            case LIGHT: {
                arrayList.add(new DualJunctionDer(managedScript, iUltimateServiceProvider, false));
                arrayList.add(new DualJunctionQeAdapter2014(managedScript, iUltimateServiceProvider, new XnfIrd(managedScript, iUltimateServiceProvider)));
                arrayList.add(new DualJunctionTir(managedScript, iUltimateServiceProvider, false));
                arrayList.add(new DualJunctionAvt(managedScript, iUltimateServiceProvider, false));
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + String.valueOf((Object)pqeTechniques)));
            }
        }
        return arrayList;
    }

    @Deprecated
    private static List<XjunctPartialQuantifierElimination> generateOldEliminationTechniques(PqeTechniques pqeTechniques, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        ArrayList<XjunctPartialQuantifierElimination> arrayList = new ArrayList<XjunctPartialQuantifierElimination>();
        switch (pqeTechniques) {
            case ALL_LOCAL: {
                arrayList.add(new XnfPlr(managedScript, iUltimateServiceProvider));
                arrayList.add(new XnfDer(managedScript, iUltimateServiceProvider));
                arrayList.add(new XnfIrd(managedScript, iUltimateServiceProvider));
                arrayList.add(new XnfTir(managedScript, iUltimateServiceProvider));
                arrayList.add(new XnfUpd(managedScript, iUltimateServiceProvider));
                break;
            }
            case NO_UPD: {
                arrayList.add(new XnfPlr(managedScript, iUltimateServiceProvider));
                arrayList.add(new XnfDer(managedScript, iUltimateServiceProvider));
                arrayList.add(new XnfIrd(managedScript, iUltimateServiceProvider));
                arrayList.add(new XnfTir(managedScript, iUltimateServiceProvider));
                break;
            }
            case ONLY_DER: {
                arrayList.add(new XnfDer(managedScript, iUltimateServiceProvider));
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + String.valueOf((Object)pqeTechniques)));
            }
        }
        return arrayList;
    }

    public static FormulaClassification classify(Term term) {
        if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
            return QuantifierPusher.classify(quantifiedFormula.getQuantifier(), quantifiedFormula.getSubformula());
        }
        return FormulaClassification.NOT_QUANTIFIED;
    }

    public static FormulaClassification classify(int n, Term term) {
        ApplicationTerm applicationTerm;
        QuantifiedFormula quantifiedFormula;
        FormulaClassification formulaClassification = term instanceof QuantifiedFormula ? ((quantifiedFormula = (QuantifiedFormula)term).getQuantifier() == n ? FormulaClassification.SAME_QUANTIFIER : FormulaClassification.DUAL_QUANTIFIER) : (term instanceof ApplicationTerm ? (QuantifierUtils.isDualFiniteJunction(n, (Term)(applicationTerm = (ApplicationTerm)term)) ? FormulaClassification.DUAL_FINITE_CONNECTIVE : (QuantifierUtils.isCorrespondingFiniteJunction(n, (Term)applicationTerm) ? FormulaClassification.CORRESPONDING_FINITE_CONNECTIVE : FormulaClassification.ATOM)) : FormulaClassification.ATOM);
        return formulaClassification;
    }

    public static Term processDualQuantifier(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask eliminationTask, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator) {
        assert (eliminationTask.getTerm() instanceof QuantifiedFormula);
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)eliminationTask.getTerm();
        assert (quantifiedFormula.getQuantifier() == SmtUtils.getOtherQuantifier(eliminationTask.getQuantifier()));
        Context context = eliminationTask.getContext().constructChildContextForQuantifiedFormula(managedScript.getScript(), Arrays.asList(quantifiedFormula.getVariables()));
        Term term = iQuantifierEliminator.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, context, eliminationTask.getTerm());
        Term term2 = SmtUtils.quantifier(managedScript.getScript(), eliminationTask.getQuantifier(), new HashSet<TermVariable>(eliminationTask.getEliminatees()), term);
        return term2;
    }

    public static Term simplify(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, SimplificationOccasion simplificationOccasion, SmtUtils.SimplificationTechnique simplificationTechnique, Context context, Term term) {
        SmtUtils.ExtendedSimplificationResult extendedSimplificationResult = SmtUtils.simplifyWithStatistics(managedScript, term, context.getCriticalConstraint(), iUltimateServiceProvider, simplificationTechnique);
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(QuantifierPusher.class);
        if (iLogger.isDebugEnabled()) {
            CondisDepthCodeGenerator.CondisDepthCode condisDepthCode = CondisDepthCodeGenerator.CondisDepthCode.of(term);
            iLogger.info((Object)("Simplification " + simplificationOccasion.getLogString() + " via " + String.valueOf((Object)simplificationTechnique) + ": " + extendedSimplificationResult.buildSizeReductionMessage() + " CDC code " + String.valueOf(condisDepthCode)));
        }
        return extendedSimplificationResult.getSimplifiedTerm();
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        if (applicationTerm.getFunction().getApplicationString().equals("and")) {
            this.setResult(SmtUtils.and(this.mScript, termArray));
        } else if (applicationTerm.getFunction().getApplicationString().equals("or")) {
            this.setResult(SmtUtils.or(this.mScript, termArray));
        } else {
            super.convertApplicationTerm(applicationTerm, termArray);
        }
    }

    public static enum FormulaClassification {
        NOT_QUANTIFIED,
        CORRESPONDING_FINITE_CONNECTIVE,
        DUAL_FINITE_CONNECTIVE,
        SAME_QUANTIFIER,
        DUAL_QUANTIFIER,
        ATOM;

    }

    public static enum PqeTechniques {
        ONLY_DER,
        ALL_LOCAL,
        NO_UPD,
        ALL,
        LIGHT;

    }

    public static enum SimplificationOccasion {
        ATOM,
        AFTER_ELIMINATION_TECHNIQUES,
        AFTER_DISTRIBTIVITY;


        public String getLogString() {
            return switch (this) {
                case AFTER_ELIMINATION_TECHNIQUES -> "after elimination techniques";
                case AFTER_DISTRIBTIVITY -> "after distributivity";
                case ATOM -> "of atom";
                default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)this)));
            };
        }
    }
}

