/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayIndexReplacementConstructor {
    private final TermVariable mForbiddenTv;
    private final ConstructionCache<Term, Term> mEntryConstrCache;
    private final ConstructionCache<ArrayIndex, ArrayIndex> mIndexConstrCache;
    private final Map<TermVariable, Term> mAuxVar2Definition = new LinkedHashMap<TermVariable, Term>();
    private boolean mConstructionDone;

    public ArrayIndexReplacementConstructor(ManagedScript managedScript, String string, TermVariable termVariable) {
        this.mForbiddenTv = termVariable;
        ConstructionCache.IValueConstruction iValueConstruction = term -> {
            TermVariable termVariable = managedScript.constructFreshTermVariable(string, term.getSort());
            this.mAuxVar2Definition.put(termVariable, (Term)term);
            return termVariable;
        };
        this.mEntryConstrCache = new ConstructionCache(iValueConstruction);
        ConstructionCache.IValueConstruction iValueConstruction2 = arrayIndex -> {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (Term term : arrayIndex) {
                Term term2 = this.entryContainsForbiddenTv(term) ? (Term)this.mEntryConstrCache.getOrConstruct((Object)term) : term;
                arrayList.add(term2);
            }
            return new ArrayIndex(arrayList);
        };
        this.mIndexConstrCache = new ConstructionCache(iValueConstruction2);
    }

    private boolean entryContainsForbiddenTv(Term term) {
        return Arrays.asList(term.getFreeVars()).contains(this.mForbiddenTv);
    }

    private boolean indexContainsForbiddenTv(ArrayIndex arrayIndex) {
        return arrayIndex.stream().anyMatch(term -> this.entryContainsForbiddenTv((Term)term));
    }

    public ArrayIndex constructIndexReplacementIfNeeded(ArrayIndex arrayIndex) {
        if (this.mConstructionDone) {
            throw new IllegalStateException("Definitions already constructed or auxVars already returned");
        }
        ArrayIndex arrayIndex2 = this.indexContainsForbiddenTv(arrayIndex) ? (ArrayIndex)this.mIndexConstrCache.getOrConstruct((Object)arrayIndex) : arrayIndex;
        return arrayIndex2;
    }

    public Term constructTermReplacementIfNeeded(Term term) {
        if (this.mConstructionDone) {
            throw new IllegalStateException("Definitions already constructed or auxVars already returned");
        }
        Term term2 = this.entryContainsForbiddenTv(term) ? (Term)this.mEntryConstrCache.getOrConstruct((Object)term) : term;
        return term2;
    }

    public Set<TermVariable> getConstructedAuxVars() {
        this.mConstructionDone = true;
        return this.mAuxVar2Definition.keySet();
    }

    public Term constructDefinitions(Script script, int n) {
        this.mConstructionDone = true;
        List<Term> list = this.mAuxVar2Definition.entrySet().stream().map(entry -> QuantifierUtils.applyDerOperator(script, n, (Term)entry.getKey(), (Term)entry.getValue())).collect(Collectors.toList());
        Term term = QuantifierUtils.applyDualFiniteConnective(script, n, list);
        return term;
    }
}

