/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.BoogieBooleanExpressionDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.CounterTrace;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.InitialTransition;
import de.uni_freiburg.informatik.ultimate.lib.pea.PEATestAutomaton;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseBits;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Trace2PeaCompilerStateless {
    private static final String FINAL = "FINAL";
    private static final String START = "START";
    private final ILogger mLogger;
    private final String mName;
    private final CounterTrace mCountertrace;
    private String[] mClock;
    private int mCanPossiblySeep;
    private CDD[] mKeep;
    private CDD[] mEnter;
    private CDD[] mCless;
    private CDD[] mClessEq;
    private CDD[] mCKeep;
    private CDD[] mCEnter;
    private int mLastphase;
    private final Map<PhaseBits, Phase> mAllPhases;
    private Phase[] mInit;
    private final List<PhaseBits> mTodo;
    private CDD mNoSyncEvent;
    private final CDD mEntrySync;
    private final CDD mExitSync;
    private final CDD mMissingEvents;
    private final boolean mSpec;
    private final Set<String> mConstantIds;
    private final PhaseEventAutomata mResult;

    public Trace2PeaCompilerStateless(ILogger iLogger, String string, CounterTrace counterTrace, Set<String> set) {
        this.mLogger = iLogger;
        this.mAllPhases = new TreeMap<PhaseBits, Phase>();
        this.mTodo = new LinkedList<PhaseBits>();
        this.mConstantIds = set;
        this.mName = string;
        this.mCountertrace = counterTrace;
        this.mCanPossiblySeep = 0;
        this.mCEnter = null;
        this.mCKeep = null;
        this.mCless = null;
        this.mClessEq = null;
        this.mClock = null;
        this.mEnter = null;
        this.mEntrySync = null;
        this.mExitSync = null;
        this.mInit = null;
        this.mKeep = null;
        this.mLastphase = 0;
        this.mMissingEvents = null;
        this.mSpec = false;
        this.mResult = this.buildAut();
    }

    public PhaseEventAutomata getResult() {
        return this.mResult;
    }

    private CDD complete(PhaseBits phaseBits, int n) {
        CDD cDD = n > 0 && this.mCountertrace.getPhases()[n].isAllowEmpty() ? this.complete(phaseBits, n - 1).and(this.mCountertrace.getPhases()[n].getEntryEvents()) : CDD.FALSE;
        int n2 = 1 << n;
        if ((phaseBits.active & n2) != 0) {
            if ((phaseBits.waiting & n2) != 0) {
                if ((phaseBits.exactbound & n2) != 0) {
                    return cDD.or(this.mCless[n].negate());
                }
                return cDD;
            }
            if (this.mCountertrace.getPhases()[n].getBoundType() < 0 && (this.canSeep(phaseBits) & n2) == 0 && (phaseBits.exactbound & n2) == 0) {
                return cDD.or(this.mCless[n]);
            }
            return CDD.TRUE;
        }
        return cDD;
    }

    private void precomputeCDDs() {
        this.mClock = new String[this.mCountertrace.getPhases().length];
        this.mKeep = new CDD[this.mCountertrace.getPhases().length];
        this.mEnter = new CDD[this.mCountertrace.getPhases().length];
        this.mCless = new CDD[this.mCountertrace.getPhases().length];
        this.mClessEq = new CDD[this.mCountertrace.getPhases().length];
        this.mCKeep = new CDD[this.mCountertrace.getPhases().length];
        this.mCEnter = new CDD[this.mCountertrace.getPhases().length];
        this.mCanPossiblySeep = 0;
        int n = 0;
        while (n < this.mCountertrace.getPhases().length) {
            Object object;
            this.mCless[n] = null;
            this.mClessEq[n] = CDD.TRUE;
            if (this.mCountertrace.getPhases()[n].getBoundType() != 0) {
                this.mClock[n] = this.mName + "_X" + n;
                this.mCless[n] = RangeDecision.create(this.mClock[n], -2, this.mCountertrace.getPhases()[n].getBound());
                this.mClessEq[n] = RangeDecision.create(this.mClock[n], -1, this.mCountertrace.getPhases()[n].getBound());
            }
            this.mKeep[n] = CDD.TRUE;
            if (!this.mCountertrace.getPhases()[n].getForbid().isEmpty()) {
                object = Collections.emptySet();
                Set<String> set = this.mCountertrace.getPhases()[n].getForbid();
                CDD cDD = EventDecision.create(object, set);
                this.mKeep[n] = this.mKeep[n].and(cDD);
            }
            this.mEnter[n] = this.mCountertrace.getPhases()[n].getEntryEvents();
            object = this.mCountertrace.getPhases()[n].getEntryEvents();
            while (((CDD)object).getDecision() instanceof EventDecision) {
                object = ((CDD)object).getChilds()[1];
            }
            if (object == CDD.TRUE) {
                this.mCanPossiblySeep |= 1 << n;
            }
            ++n;
        }
        this.mLastphase = this.mCountertrace.getPhases().length - 1;
        while (this.mLastphase > 0 && this.mCountertrace.getPhases()[this.mLastphase].isAllowEmpty() && (this.mCanPossiblySeep & 1 << this.mLastphase) != 0) {
            --this.mLastphase;
        }
        this.mLogger.debug((Object)("Lastphase = " + this.mLastphase));
    }

    private final int canSeep(PhaseBits phaseBits) {
        return (phaseBits.active & ~phaseBits.waiting) << 1 & this.mCanPossiblySeep;
    }

    private void initTrans(PhaseBits phaseBits) {
        int n = 0;
        int n2 = 1;
        while (n < this.mCountertrace.getPhases().length) {
            if ((phaseBits.active & n2) != 0) {
                this.mCKeep[n] = this.mKeep[n];
                if (this.mCountertrace.getPhases()[n].getBoundType() < 0 && (this.canSeep(phaseBits) & n2) == 0) {
                    this.mCKeep[n] = this.mCKeep[n].and(this.mCless[n]);
                }
            } else {
                this.mCKeep[n] = CDD.FALSE;
            }
            this.mCEnter[n] = n > 0 ? this.complete(phaseBits, n - 1).and(this.mEnter[n]) : CDD.FALSE;
            this.mLogger.debug((Object)("initTrans for " + String.valueOf(phaseBits) + "," + n + ": complete: " + String.valueOf(this.complete(phaseBits, n)) + " enter: " + String.valueOf(this.mCEnter[n]) + "  keep: " + String.valueOf(this.mCKeep[n])));
            ++n;
            n2 += n2;
        }
    }

    private void buildNewTrans(Phase phase, CDD cDD, CDD cDD2, String[] stringArray, PhaseBits phaseBits) {
        Phase phase2;
        if (this.mAllPhases.containsKey(phaseBits)) {
            this.mLogger.debug((Object)"Destination phase already exists");
            phase2 = this.mAllPhases.get(phaseBits);
        } else {
            CDD cDD3 = CDD.TRUE;
            int n = 0;
            int n2 = 1;
            while (n2 <= phaseBits.active) {
                if ((phaseBits.waiting & n2) != 0 || this.mCountertrace.getPhases()[n].getBoundType() < 0 && (this.canSeep(phaseBits) & n2) == 0) {
                    cDD3 = n == this.mLastphase && this.mCountertrace.getPhases()[n].getBoundType() > 0 && (phaseBits.exactbound & n2) != 0 ? cDD3.and(this.mCless[n]) : cDD3.and(this.mClessEq[n]);
                }
                ++n;
                n2 += n2;
            }
            this.mLogger.debug((Object)"Creating destination phase");
            phase2 = new Phase(this.phaseName(phaseBits.toString()), cDD2, cDD3);
            phase2.phaseBits = phaseBits;
            this.mAllPhases.put(phaseBits, phase2);
            this.mTodo.add(phaseBits);
        }
        cDD = cDD.assume(phase2.getStateInvariant().prime(this.mConstantIds));
        cDD = cDD.assume(phase.getClockInvariant());
        this.mLogger.debug((Object)"Creating transition to destination phase");
        phase.addTransition(phase2, cDD, stringArray);
    }

    private void recursiveBuildTrans(PhaseBits phaseBits, Phase phase, CDD cDD, CDD cDD2, String[] stringArray, int n, int n2, int n3, int n4) {
        String[] stringArray2;
        boolean bl;
        if (cDD.and(cDD2.prime(this.mConstantIds)) == CDD.FALSE) {
            return;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("recursiveBuildTrans: " + String.valueOf(phaseBits) + "->" + String.valueOf(new PhaseBits(n, n3, n2)) + " (" + n4 + ") partial guards: " + String.valueOf(cDD) + " inv: " + String.valueOf(cDD2)));
        }
        if (n4 == this.mCountertrace.getPhases().length) {
            if ((n & 1 << n4 - 1) == 0) {
                this.mLogger.debug((Object)"Adding new transition");
                this.buildNewTrans(phase, cDD, cDD2, stringArray, new PhaseBits(n, n3, n2));
            }
            return;
        }
        int n5 = 1 << n4;
        boolean bl2 = bl = ((n & ~n2) << 1 & this.mCanPossiblySeep & n5) != 0;
        if (bl) {
            this.recursiveBuildTrans(phaseBits, phase, cDD, cDD2.and(this.mCountertrace.getPhases()[n4].getInvariant().negate()), stringArray, n, n2, n3, n4 + 1);
        } else {
            stringArray2 = cDD.and(this.mCEnter[n4].or(this.mCKeep[n4]).and(this.mCountertrace.getPhases()[n4].getInvariant().prime(this.mConstantIds)).negate());
            if (stringArray2 != CDD.FALSE) {
                this.recursiveBuildTrans(phaseBits, phase, (CDD)stringArray2, cDD2, stringArray, n, n2, n3, n4 + 1);
            }
        }
        cDD2 = cDD2.and(this.mCountertrace.getPhases()[n4].getInvariant());
        stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = this.mClock[n4];
        if (this.mCountertrace.getPhases()[n4].getBoundType() > 0) {
            CDD cDD3;
            CDD cDD4 = cDD.and(this.mCKeep[n4]);
            if (cDD4 != CDD.FALSE) {
                if ((phaseBits.waiting & n5) != 0) {
                    this.recursiveBuildTrans(phaseBits, phase, cDD4.and(this.mCless[n4]), cDD2, stringArray, n | n5, n2 | n5, n3 | phaseBits.exactbound & n5, n4 + 1);
                    this.recursiveBuildTrans(phaseBits, phase, cDD4.and(this.mCless[n4].negate()), cDD2, stringArray, n | n5, n2, n3, n4 + 1);
                } else {
                    this.recursiveBuildTrans(phaseBits, phase, cDD4, cDD2, stringArray, n | n5, n2, n3, n4 + 1);
                }
            }
            CDD cDD5 = cDD.and(cDD4.negate());
            if (this.mCountertrace.getPhases()[n4].getBoundType() == 1) {
                CDD cDD6 = cDD5.and(this.mCEnter[n4]);
                if (cDD6 != CDD.FALSE) {
                    this.mLogger.debug((Object)("Phase " + n4 + " can be entered exact"));
                    this.recursiveBuildTrans(phaseBits, phase, cDD6, cDD2, stringArray2, n | n5, n2 | n5, n3 | n5, n4 + 1);
                }
                cDD3 = bl ? cDD5.and(this.mCEnter[n4].negate()) : CDD.FALSE;
            } else {
                CDD cDD7 = cDD3 = bl ? cDD5 : cDD5.and(this.mCEnter[n4]);
            }
            if (cDD3 != CDD.FALSE) {
                this.recursiveBuildTrans(phaseBits, phase, cDD3, cDD2, stringArray2, n | n5, n2 | n5, n3, n4 + 1);
            }
        } else if (this.mCountertrace.getPhases()[n4].getBoundType() < 0) {
            if (bl) {
                this.recursiveBuildTrans(phaseBits, phase, cDD, cDD2, stringArray, n | n5, n2, n3, n4 + 1);
            } else {
                CDD cDD8;
                CDD cDD9;
                CDD cDD10;
                if ((this.canSeep(phaseBits) & n5) != 0) {
                    if (this.mCountertrace.getPhases()[n4].getBoundType() == -2) {
                        cDD10 = cDD;
                        cDD9 = CDD.FALSE;
                    } else {
                        cDD10 = cDD.and(this.mCEnter[n4].negate());
                        cDD9 = cDD.and(this.mCEnter[n4]);
                    }
                    cDD8 = CDD.FALSE;
                } else {
                    if (this.mCountertrace.getPhases()[n4].getBoundType() == -2) {
                        cDD10 = cDD.and(this.mCEnter[n4]);
                        cDD9 = CDD.FALSE;
                    } else {
                        cDD10 = CDD.FALSE;
                        cDD9 = cDD.and(this.mCEnter[n4]);
                    }
                    cDD8 = cDD.and(this.mCKeep[n4].and(this.mCEnter[n4].negate()));
                }
                if (cDD10 != CDD.FALSE) {
                    this.recursiveBuildTrans(phaseBits, phase, cDD10, cDD2, stringArray2, n | n5, n2, n3, n4 + 1);
                }
                if (cDD9 != CDD.FALSE) {
                    this.recursiveBuildTrans(phaseBits, phase, cDD9, cDD2, stringArray2, n | n5, n2, n3 | n5, n4 + 1);
                }
                if (cDD8 != CDD.FALSE) {
                    this.recursiveBuildTrans(phaseBits, phase, cDD8, cDD2, stringArray, n | n5, n2, n3 | phaseBits.exactbound & n5, n4 + 1);
                }
            }
        } else {
            CDD cDD11 = cDD;
            if (!bl) {
                cDD11 = cDD.and(this.mCKeep[n4].or(this.mCEnter[n4]));
            }
            if (cDD11 != CDD.FALSE) {
                this.recursiveBuildTrans(phaseBits, phase, cDD11, cDD2, stringArray, n | n5, n2, n3, n4 + 1);
            }
        }
    }

    private void findTrans(PhaseBits phaseBits, Phase phase) {
        this.initTrans(phaseBits);
        this.recursiveBuildTrans(phaseBits, phase, this.mNoSyncEvent, CDD.TRUE, new String[0], 0, 0, 0, 0);
    }

    private PhaseEventAutomata buildAut() {
        Object object;
        Object object2;
        int n;
        Phase[] phaseArray;
        PhaseBits phaseBits = new PhaseBits(0, 0, 0);
        Phase phase2 = null;
        this.mNoSyncEvent = CDD.TRUE;
        if (this.mEntrySync != null) {
            this.mNoSyncEvent = this.mNoSyncEvent.and(this.mEntrySync.negate());
        }
        if (this.mExitSync != null) {
            this.mNoSyncEvent = this.mNoSyncEvent.and(this.mExitSync.negate());
        }
        this.precomputeCDDs();
        int n2 = 0;
        while (n2 < this.mCountertrace.getPhases().length) {
            this.mCEnter[n2] = this.mCKeep[n2] = CDD.FALSE;
            ++n2;
        }
        if (this.mEntrySync != null) {
            this.mLogger.debug((Object)"Trying to add transitions from start state");
            phase2 = new Phase(this.phaseName(START), CDD.TRUE, CDD.TRUE);
            phase2.addTransition(phase2, this.mNoSyncEvent.prime(this.mConstantIds), new String[0]);
            n2 = 0;
            while (n2 < this.mCountertrace.getPhases().length) {
                if ((this.mCanPossiblySeep & 1 << n2) == 0) break;
                this.mCEnter[n2] = this.mEnter[n2];
                if (!this.mCountertrace.getPhases()[n2].isAllowEmpty()) break;
                ++n2;
            }
            this.recursiveBuildTrans(phaseBits, phase2, this.mEntrySync.and(this.mExitSync.negate()), CDD.TRUE, new String[0], 0, 0, 0, 0);
            this.mInit = new Phase[]{phase2};
            this.mLogger.debug((Object)"Adding transitions from start state successful");
        } else {
            this.mLogger.debug((Object)"Bulding initial transitions");
            Phase phase3 = new Phase(this.phaseName("dummyinit"), CDD.TRUE, CDD.TRUE);
            int n3 = 0;
            while (n3 < this.mCountertrace.getPhases().length) {
                if ((this.mCanPossiblySeep & 1 << n3) == 0) break;
                this.mCEnter[n3] = CDD.TRUE;
                if (!this.mCountertrace.getPhases()[n3].isAllowEmpty()) break;
                ++n3;
            }
            this.recursiveBuildTrans(phaseBits, phase3, this.mNoSyncEvent, CDD.TRUE, new String[0], 0, 0, 0, 0);
            phaseArray = phase3.getTransitions();
            n = phaseArray.size();
            this.mInit = new Phase[n];
            int n4 = 0;
            while (n4 < n) {
                object2 = phaseArray.get(n4);
                if (((Transition)object2).getDest().getName().endsWith("st")) {
                    phase2 = new Phase(this.phaseName("stinit"), this.mCountertrace.getPhases()[0].getInvariant().negate(), CDD.TRUE);
                    phase2.addTransition(((Transition)object2).getDest(), this.mNoSyncEvent.prime(this.mConstantIds), new String[0]);
                    phase2.addTransition(phase2, this.mNoSyncEvent.prime(this.mConstantIds), new String[0]);
                    this.mInit[n4] = phase2;
                } else {
                    this.mInit[n4] = ((Transition)object2).getDest();
                }
                ++n4;
            }
        }
        this.mLogger.debug((Object)"Building automaton");
        while (!this.mTodo.isEmpty()) {
            PhaseBits phaseBits2 = this.mTodo.remove(0);
            phaseArray = this.mAllPhases.get(phaseBits2);
            this.findTrans(phaseBits2, (Phase)phaseArray);
        }
        this.mLogger.debug((Object)"Automaton complete");
        Phase[] phaseArray2 = new Phase[(phase2 != null ? 1 : 0) + this.mAllPhases.size() + (this.mExitSync != null ? 1 : 0)];
        phaseArray = this.mExitSync != null ? new Phase[1] : null;
        n = 0;
        if (phase2 != null) {
            phaseArray2[n] = phase2;
            ++n;
        }
        Iterator<Map.Entry<PhaseBits, Phase>> iterator = this.mAllPhases.entrySet().iterator();
        while (iterator.hasNext()) {
            phaseArray2[n] = iterator.next().getValue();
            ++n;
        }
        if (this.mExitSync != null) {
            this.mLogger.debug((Object)"Trying to add transitions to final state");
            phaseArray2[n] = this.buildExitSyncTransitions();
            phaseArray[0] = phaseArray2[++n - 1];
        }
        object2 = new ArrayList();
        String[] stringArray = this.mClock;
        int n5 = this.mClock.length;
        int n6 = 0;
        while (n6 < n5) {
            object = stringArray[n6];
            if (object != null && !"".equals(object)) {
                object2.add(object);
            }
            ++n6;
        }
        object = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        n5 = 0;
        while (n5 < this.mCountertrace.getPhases().length) {
            this.addVariables(this.mCountertrace.getPhases()[n5].getEntryEvents(), (Map<String, String>)object, hashSet);
            this.addVariables(this.mCountertrace.getPhases()[n5].getInvariant(), (Map<String, String>)object, hashSet);
            hashSet.addAll(this.mCountertrace.getPhases()[n5].getForbid());
            ++n5;
        }
        PhaseEventAutomata phaseEventAutomata = this.mExitSync != null ? new PEATestAutomaton(this.mName, Arrays.asList(phaseArray2), Arrays.asList(this.mInit), (List<String>)object2, phaseArray).removeUnreachableLocations() : new PhaseEventAutomata(this.mName, Arrays.asList(phaseArray2), Arrays.asList(this.mInit).stream().map(phase -> new InitialTransition(CDD.TRUE, (Phase)phase)).collect(Collectors.toList()), (List<String>)object2, (Map<String, String>)object, hashSet, null);
        return phaseEventAutomata;
    }

    private void addVariables(CDD cDD, Map<String, String> map, Set<String> set) {
        Object object;
        Object object2;
        Decision<?> decision = cDD.getDecision();
        if (decision != null) {
            if (decision instanceof EventDecision) {
                set.add(((EventDecision)decision).getEvent());
            } else if (decision instanceof BooleanDecision) {
                map.put(((BooleanDecision)decision).getVar(), "bool");
            } else if (decision instanceof BoogieBooleanExpressionDecision) {
                object2 = (BoogieBooleanExpressionDecision)decision;
                for (Map.Entry<String, String> entry : ((BoogieBooleanExpressionDecision)object2).getVars().entrySet()) {
                    object = map.get(entry.getKey());
                    String string = entry.getValue();
                    if (object != null && string != null && !((String)object).equals(entry.getValue())) {
                        throw new IllegalArgumentException(this.mName + " Variable with conflicting type declared: " + entry.getKey() + " : " + (String)object + " vs. " + entry.getValue());
                    }
                    if (object != null && string == null) continue;
                    map.put(entry.getKey(), string);
                }
            } else {
                throw new UnsupportedOperationException("Unknown decision type: " + String.valueOf(decision.getClass()));
            }
        }
        if (cDD.getChilds() != null) {
            object = cDD.getChilds();
            int n = ((CDD[])object).length;
            int n2 = 0;
            while (n2 < n) {
                object2 = object[n2];
                this.addVariables((CDD)object2, map, set);
                ++n2;
            }
        }
    }

    private Phase buildExitSyncTransitions() {
        Phase phase = new Phase(this.phaseName(FINAL), CDD.TRUE, CDD.TRUE);
        String[] stringArray = new String[]{};
        phase.addTransition(phase, this.mNoSyncEvent.prime(this.mConstantIds), stringArray);
        CDD cDD = this.mExitSync;
        if (this.mEntrySync != null) {
            cDD = cDD.and(this.mEntrySync.negate());
        }
        for (PhaseBits phaseBits : this.mAllPhases.keySet()) {
            Phase phase2 = this.mAllPhases.get(phaseBits);
            CDD cDD2 = this.complete(phaseBits, this.mCountertrace.getPhases().length - 1).and(this.mMissingEvents);
            if (!this.mSpec) {
                cDD2 = cDD2.negate();
            }
            if (cDD2 == CDD.FALSE) continue;
            phase2.addTransition(phase, cDD2.and(cDD).prime(this.mConstantIds), stringArray);
        }
        return phase;
    }

    private String phaseName(String string) {
        return String.format("%s_%s", this.mName, string);
    }
}

