/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PersistenceAwareModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginConnector;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.ToolchainWalker;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.StoreObjectException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.preferences.CorePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.GenericServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AssertionsEnabledResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.PluginType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.SubchainType;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainPlugin;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.util.VMUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ToolchainManager {
    private final ILogger mLogger;
    private final PluginFactory mPluginFactory;
    private final IController<RunDefinition> mCurrentController;
    private final AtomicLong mCurrentId;
    private final ConcurrentHashMap<Long, Toolchain> mActiveToolchains;
    private final ILoggingService mLoggingService;

    public ToolchainManager(ILoggingService iLoggingService, PluginFactory pluginFactory, IController<RunDefinition> iController) {
        this.mLoggingService = iLoggingService;
        this.mLogger = this.mLoggingService.getLogger("de.uni_freiburg.informatik.ultimate.core");
        this.mPluginFactory = pluginFactory;
        this.mCurrentController = iController;
        this.mCurrentId = new AtomicLong();
        this.mActiveToolchains = new ConcurrentHashMap();
    }

    public void releaseToolchain(IToolchain<RunDefinition> iToolchain) {
        if (iToolchain == null) {
            throw new IllegalArgumentException("toolchain");
        }
        Toolchain toolchain = this.mActiveToolchains.remove(iToolchain.getId());
        if (toolchain != null && toolchain.getId() != iToolchain.getId()) {
            this.mLogger.warn((Object)"An concurrency error occured: Toolchain ID has changed during livecycle");
        }
        if (iToolchain.getCurrentToolchainData() != null && iToolchain.getCurrentToolchainData().getStorage() != null) {
            iToolchain.getCurrentToolchainData().getStorage().clear();
            this.mLogger.debug((Object)("Toolchain " + iToolchain.getId() + " released"));
        }
    }

    public IToolchain<RunDefinition> requestToolchain(File[] fileArray) {
        Toolchain toolchain = new Toolchain(this.mCurrentId.incrementAndGet(), fileArray, this.createModelManager());
        this.mActiveToolchains.put(toolchain.getId(), toolchain);
        return toolchain;
    }

    public void close() {
        if (this.mActiveToolchains.size() > 0) {
            this.mLogger.info((Object)("There are still " + this.mActiveToolchains.size() + " active toolchains alive"));
            ArrayList<Toolchain> arrayList = new ArrayList<Toolchain>(this.mActiveToolchains.values());
            for (Toolchain toolchain : arrayList) {
                if (toolchain == null || toolchain.getCurrentToolchainData() == null || toolchain.getCurrentToolchainData().getStorage() == null) continue;
                toolchain.getCurrentToolchainData().getStorage().clear();
            }
            this.mActiveToolchains.clear();
        }
    }

    private IModelManager createModelManager() {
        return new PersistenceAwareModelManager(new RcpPreferenceProvider("de.uni_freiburg.informatik.ultimate.core").getString("Repository directory"), this.mLogger);
    }

    private final class Toolchain
    implements IToolchain<RunDefinition> {
        private final long mId;
        private final IModelManager mModelManager;
        private final Benchmark mBenchmark;
        private IToolchainData<RunDefinition> mToolchainData;
        private final Map<File[], ISource> mFiles2Parser;
        private final File[] mInputFiles;
        private ToolchainWalker mToolchainWalker;

        Toolchain(long l, File[] fileArray, IModelManager iModelManager) {
            this.mId = l;
            this.mModelManager = iModelManager;
            this.mBenchmark = new Benchmark();
            this.mFiles2Parser = new LinkedHashMap<File[], ISource>();
            this.mInputFiles = Objects.requireNonNull(fileArray);
        }

        public void init(IToolchainProgressMonitor iToolchainProgressMonitor) {
            if (this.mToolchainData == null) {
                return;
            }
            this.mToolchainWalker = new ToolchainWalker(this.mBenchmark, this.mModelManager, ToolchainManager.this.mPluginFactory, ToolchainManager.this.mLogger);
            this.mToolchainData.getStorage().clear();
            ToolchainManager.this.mLoggingService.setCurrentControllerID(ToolchainManager.this.mCurrentController.getPluginID());
            ToolchainManager.this.mLoggingService.store(this.mToolchainData.getStorage());
            this.mToolchainData.getStorage().putStorable(GenericServiceProvider.getServiceKey(), (IStorable)new GenericServiceProvider(ToolchainManager.this.mPluginFactory));
            ProgressMonitorService progressMonitorService = new ProgressMonitorService(iToolchainProgressMonitor, ToolchainManager.this.mLogger, this.mToolchainWalker);
            this.mToolchainData.getStorage().putStorable(ProgressMonitorService.getServiceKey(), (IStorable)progressMonitorService);
            this.mToolchainData = ToolchainManager.this.mCurrentController.prerun((IToolchain)this);
        }

        public IToolchainData<RunDefinition> makeToolSelection(IToolchainProgressMonitor iToolchainProgressMonitor) {
            List<ITool> list = ToolchainManager.this.mPluginFactory.getAllAvailableTools();
            if (list.isEmpty()) {
                ToolchainManager.this.mLogger.warn((Object)(this.getLogPrefix() + ": There are no plugins present, returning null tools."));
                return null;
            }
            IToolchainData iToolchainData = ToolchainManager.this.mCurrentController.selectTools((IToolchain)this, list);
            return this.setToolSelection(iToolchainProgressMonitor, (IToolchainData<RunDefinition>)iToolchainData);
        }

        public IToolchainData<RunDefinition> setToolSelection(IToolchainProgressMonitor iToolchainProgressMonitor, IToolchainData<RunDefinition> iToolchainData) {
            if (iToolchainData == null) {
                ToolchainManager.this.mLogger.warn((Object)(this.getLogPrefix() + ": No toolchain found."));
                return null;
            }
            if (!this.checkToolchain(((RunDefinition)iToolchainData.getRootElement()).getToolchain().getPluginOrSubchain())) {
                ToolchainManager.this.mLogger.warn((Object)(this.getLogPrefix() + ": Invalid toolchain found."));
                return null;
            }
            this.mToolchainData = iToolchainData;
            this.init(iToolchainProgressMonitor);
            ToolchainManager.this.mLogger.info((Object)(this.getLogPrefix() + ": Toolchain selected."));
            return iToolchainData;
        }

        public boolean initializeParsers() {
            Object object;
            Object object22;
            if (this.mInputFiles == null || this.mInputFiles.length == 0) {
                ToolchainManager.this.mLogger.fatal((Object)(this.getLogPrefix() + ": No input files specified"));
                return false;
            }
            Set<ISource> set = this.loadParsers();
            HashSet<File> hashSet = new HashSet<File>();
            for (Object object22 : set) {
                object = object22.parseable(this.mInputFiles);
                assert (object != null);
                if (((File[])object).length <= 0) continue;
                this.mFiles2Parser.put((File[])object, (ISource)object22);
                File[] fileArray = object;
                int n = ((File[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!hashSet.add(file)) {
                        ToolchainManager.this.mLogger.warn((Object)("Multiple parsers will parse " + file.getAbsolutePath()));
                    }
                    ++n2;
                }
            }
            if (this.mFiles2Parser.isEmpty()) {
                ToolchainManager.this.mLogger.warn((Object)(this.getLogPrefix() + ": No parsers available for " + this.getStringFromFiles(this.mInputFiles)));
                return false;
            }
            object22 = Arrays.stream(this.mInputFiles).collect(Collectors.toSet());
            Set set2 = this.mFiles2Parser.entrySet().stream().flatMap(entry -> Arrays.stream((File[])entry.getKey())).collect(Collectors.toSet());
            if (!set2.containsAll((Collection<?>)object22)) {
                object = new HashSet(object22);
                object.removeAll(set2);
                ToolchainManager.this.mLogger.error((Object)(this.getLogPrefix() + ": No parsers available for " + this.getStringFromFiles((Collection<File>)object)));
                return false;
            }
            ToolchainManager.this.mLogger.info((Object)(this.getLogPrefix() + ": Applicable parser(s) successfully (re)initialized"));
            return true;
        }

        private String getStringFromFiles(File[] fileArray) {
            return this.getStringFromFiles(Arrays.stream(fileArray));
        }

        private String getStringFromFiles(Collection<File> collection) {
            return this.getStringFromFiles(collection.stream());
        }

        private String getStringFromFiles(Stream<File> stream) {
            return stream.map(File::getAbsolutePath).collect(Collectors.joining(","));
        }

        public void runParsers() throws Exception {
            for (Map.Entry<File[], ISource> entry : this.mFiles2Parser.entrySet()) {
                ISource iSource = entry.getValue();
                File[] fileArray = entry.getKey();
                IElement iElement = this.runParser(fileArray, iSource);
                ModelType modelType = iSource.getOutputDefinition();
                if (modelType == null) {
                    String string = iSource.getPluginName() + " returned invalid output definition for file(s) " + this.getStringFromFiles(fileArray);
                    ToolchainManager.this.mLogger.fatal((Object)(this.getLogPrefix() + ": " + string + ", aborting..."));
                    throw new IllegalArgumentException(string);
                }
                this.addAST(iElement, modelType);
            }
        }

        public IToolchain.ReturnCode processToolchain(IToolchainProgressMonitor iToolchainProgressMonitor) throws Throwable {
            IToolchain.ReturnCode returnCode;
            ToolchainManager.this.mLogger.info((Object)("####################### " + this.getLogPrefix() + " #######################"));
            RcpPreferenceProvider rcpPreferenceProvider = new RcpPreferenceProvider("de.uni_freiburg.informatik.ultimate.core");
            boolean bl = rcpPreferenceProvider.getBoolean("Generate benchmark results");
            IUltimateServiceProvider iUltimateServiceProvider = this.mToolchainData.getServices();
            Benchmark benchmark = null;
            if (bl) {
                benchmark = new Benchmark();
                benchmark.start("Toolchain (without parser)");
            }
            try {
                if (this.mModelManager.size() < 1) {
                    ToolchainManager.this.mLogger.error((Object)(this.getLogPrefix() + ": There is no model present. Did you run a ISource or IGenerator plugin in your toolchain?"));
                    throw new IllegalStateException("There is no model present.");
                }
                Collection<ISource> collection = this.mFiles2Parser.values();
                ToolchainWalker.CompleteToolchainData completeToolchainData = new ToolchainWalker.CompleteToolchainData(this, collection.toArray(new ISource[collection.size()]), ToolchainManager.this.mCurrentController);
                iUltimateServiceProvider = completeToolchainData.getServices();
                returnCode = this.mToolchainWalker.walk(this, completeToolchainData, iUltimateServiceProvider.getProgressMonitorService(), iToolchainProgressMonitor);
            }
            catch (Throwable throwable) {
                IResultService iResultService = iUltimateServiceProvider.getResultService();
                if (VMUtils.areAssertionsEnabled()) {
                    iResultService.reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new AssertionsEnabledResult("de.uni_freiburg.informatik.ultimate.core"));
                }
                if (bl) {
                    benchmark.stopAll();
                    benchmark.printResult(ToolchainManager.this.mLogger);
                    this.mBenchmark.printResult(ToolchainManager.this.mLogger);
                    iResultService.reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new StatisticsResult("de.uni_freiburg.informatik.ultimate.core", "Toolchain Benchmarks", (ICsvProviderProvider)this.mBenchmark));
                }
                ToolchainManager.this.mLogger.info((Object)("#######################  End " + this.getLogPrefix() + " #######################"));
                ILogger iLogger = iUltimateServiceProvider.getLoggingService().getControllerLogger();
                boolean bl2 = CorePreferenceInitializer.getPreferenceProvider(iUltimateServiceProvider).getBoolean("Show long description of results");
                boolean bl3 = CorePreferenceInitializer.getPreferenceProvider(iUltimateServiceProvider).getBoolean("Print statistic results");
                Map map = bl3 ? iResultService.getResults() : ResultUtil.filterResultMap((Map)iResultService.getResults(), iResult -> !(iResult instanceof StatisticsResult));
                ResultUtil.logResults((ILogger)iLogger, (Map)map, (boolean)bl2);
                ToolchainManager.this.mCurrentController.displayToolchainResults((IToolchain)this, iResultService.getResults());
                this.mModelManager.removeAll();
                this.mToolchainWalker.endToolchain();
                throw throwable;
            }
            IResultService iResultService = iUltimateServiceProvider.getResultService();
            if (VMUtils.areAssertionsEnabled()) {
                iResultService.reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new AssertionsEnabledResult("de.uni_freiburg.informatik.ultimate.core"));
            }
            if (bl) {
                benchmark.stopAll();
                benchmark.printResult(ToolchainManager.this.mLogger);
                this.mBenchmark.printResult(ToolchainManager.this.mLogger);
                iResultService.reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new StatisticsResult("de.uni_freiburg.informatik.ultimate.core", "Toolchain Benchmarks", (ICsvProviderProvider)this.mBenchmark));
            }
            ToolchainManager.this.mLogger.info((Object)("#######################  End " + this.getLogPrefix() + " #######################"));
            ILogger iLogger = iUltimateServiceProvider.getLoggingService().getControllerLogger();
            boolean bl4 = CorePreferenceInitializer.getPreferenceProvider(iUltimateServiceProvider).getBoolean("Show long description of results");
            boolean bl5 = CorePreferenceInitializer.getPreferenceProvider(iUltimateServiceProvider).getBoolean("Print statistic results");
            Map map = bl5 ? iResultService.getResults() : ResultUtil.filterResultMap((Map)iResultService.getResults(), iResult -> !(iResult instanceof StatisticsResult));
            ResultUtil.logResults((ILogger)iLogger, (Map)map, (boolean)bl4);
            ToolchainManager.this.mCurrentController.displayToolchainResults((IToolchain)this, iResultService.getResults());
            this.mModelManager.removeAll();
            this.mToolchainWalker.endToolchain();
            return returnCode;
        }

        public void addAST(IElement iElement, ModelType modelType) {
            if (this.mModelManager.addItem(iElement, modelType)) {
                ToolchainManager.this.mLogger.debug((Object)(this.getLogPrefix() + ": Successfully added AST to model manager"));
            } else {
                ToolchainManager.this.mLogger.error((Object)(this.getLogPrefix() + ": Could not add AST to model manager!"));
            }
        }

        public long getId() {
            return this.mId;
        }

        private boolean checkToolchain(List<Object> list) {
            return list.stream().allMatch(this::checkToolchainElement);
        }

        private boolean checkToolchainElement(Object object) {
            if (object instanceof PluginType) {
                PluginType pluginType = (PluginType)object;
                if (ToolchainManager.this.mPluginFactory.isPluginAvailable(pluginType.getId())) {
                    return true;
                }
                ToolchainManager.this.mLogger.error((Object)(this.getLogPrefix() + ": Did not find plugin with id \"" + pluginType.getId() + "\". The following plugins are currently available:"));
                this.printAvailableTools();
                return false;
            }
            if (object instanceof SubchainType) {
                return this.checkToolchain(((SubchainType)object).getPluginOrSubchain());
            }
            throw new IllegalArgumentException("Found unknown type in toolchain: " + String.valueOf(object.getClass()));
        }

        private void printAvailableTools() {
            if (!ToolchainManager.this.mLogger.isInfoEnabled()) {
                return;
            }
            for (ITool iTool : ToolchainManager.this.mPluginFactory.getAllAvailableTools()) {
                ToolchainManager.this.mLogger.info((Object)(this.getLogPrefix() + ": " + iTool.getPluginID()));
            }
        }

        private IElement runParser(File[] fileArray, ISource iSource) throws Exception {
            boolean bl = new RcpPreferenceProvider("de.uni_freiburg.informatik.ultimate.core").getBoolean("Generate benchmark results");
            IElement iElement = null;
            PluginConnector.initializePlugin(ToolchainManager.this.mLogger, (IToolchainPlugin)iSource, this.mToolchainData.getServices(), this.mToolchainData.getStorage());
            try {
                try {
                    if (bl) {
                        this.mBenchmark.start(iSource.getPluginName());
                    }
                    if (fileArray.length == 1) {
                        ToolchainManager.this.mLogger.info((Object)(this.getLogPrefix() + ": Parsing single file: " + fileArray[0].getAbsolutePath()));
                    } else {
                        ToolchainManager.this.mLogger.info((Object)(this.getLogPrefix() + ": Parsing files: " + this.getStringFromFiles(fileArray)));
                    }
                    if (bl) {
                        this.mBenchmark.stop(iSource.getPluginName());
                    }
                    iElement = iSource.parseAST(fileArray);
                }
                catch (Exception exception) {
                    ToolchainManager.this.mLogger.fatal((Object)(this.getLogPrefix() + ": Exception during parsing: "), (Throwable)exception);
                    this.resetModelManager();
                    throw exception;
                }
            }
            finally {
                iSource.finish();
            }
            return iElement;
        }

        private void resetModelManager() {
            if (!this.mModelManager.isEmpty()) {
                ToolchainManager.this.mLogger.info((Object)(this.getLogPrefix() + ": Clearing model..."));
                try {
                    this.mModelManager.persistAll(false);
                }
                catch (StoreObjectException storeObjectException) {
                    Throwable throwable = storeObjectException.getCause();
                    ToolchainManager.this.mLogger.error((Object)(this.getLogPrefix() + ": Failed to persist models: " + (throwable == null ? storeObjectException.getMessage() : throwable.getMessage())));
                }
            }
        }

        private Set<ISource> loadParsers() {
            List<String> list = ToolchainManager.this.mPluginFactory.getPluginClassNames(ISource.class);
            if (ToolchainManager.this.mLogger.isDebugEnabled()) {
                ToolchainManager.this.mLogger.debug((Object)(this.getLogPrefix() + ": We have " + list.size() + " parsers present."));
            }
            HashSet<ISource> hashSet = new HashSet<ISource>();
            for (String string : list) {
                ISource iSource = (ISource)ToolchainManager.this.mPluginFactory.createTool(string);
                if (iSource == null) {
                    ToolchainManager.this.mLogger.warn((Object)(this.getLogPrefix() + ": Parser with ID " + string + " could not be created"));
                    continue;
                }
                hashSet.add(iSource);
            }
            return hashSet;
        }

        public IToolchainData<RunDefinition> getCurrentToolchainData() {
            return this.mToolchainData;
        }

        private String getLogPrefix() {
            return "[Toolchain " + this.mId + "]";
        }

        public File[] getInputFiles() {
            return this.mInputFiles;
        }
    }
}

