/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Evaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends IAbstractState<STATE>> {
    private final int mMaxRecursionDepth;
    private final VALUE mTopValue;
    private final List<Evaluator<VALUE, STATE>> mSubEvaluators;
    private int mCurrentEvaluationRecursion;
    private int mCurrentInverseEvaluationRecursion;
    private final EvaluatorLogger mLogger;

    public Evaluator(int n, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory, EvaluatorLogger evaluatorLogger) {
        this.mLogger = evaluatorLogger;
        this.mMaxRecursionDepth = n;
        this.mCurrentEvaluationRecursion = -1;
        this.mCurrentInverseEvaluationRecursion = -1;
        this.mTopValue = iNonrelationalValueFactory.createTopValue();
        this.mSubEvaluators = new ArrayList<Evaluator<VALUE, STATE>>();
    }

    public final Collection<IEvaluationResult<VALUE>> evaluate(STATE STATE, int n) {
        if (this.mMaxRecursionDepth >= 0 && n > this.mMaxRecursionDepth) {
            return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(this.mTopValue, BooleanValue.TOP));
        }
        if (this.mCurrentEvaluationRecursion < n) {
            this.mCurrentEvaluationRecursion = n;
        }
        return this.evaluate(STATE);
    }

    protected abstract Collection<IEvaluationResult<VALUE>> evaluate(STATE var1);

    public final Collection<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult, STATE STATE, int n) {
        if (this.mMaxRecursionDepth >= 0 && n > this.mMaxRecursionDepth) {
            return Collections.singletonList(STATE);
        }
        if (this.mCurrentInverseEvaluationRecursion < n) {
            this.mCurrentInverseEvaluationRecursion = n;
        }
        return this.inverseEvaluate(iEvaluationResult, STATE);
    }

    protected abstract Collection<STATE> inverseEvaluate(IEvaluationResult<VALUE> var1, STATE var2);

    public final void addSubEvaluator(Evaluator<VALUE, STATE> evaluator) {
        assert (evaluator != null);
        if (!this.hasFreeOperands()) {
            throw new UnsupportedOperationException("There are no free sub evaluators left to be assigned to.");
        }
        this.mSubEvaluators.add(evaluator);
    }

    public abstract boolean hasFreeOperands();

    public abstract boolean containsBool();

    public abstract EvaluatorUtils.EvaluatorType getType();

    protected final int getCurrentEvaluationRecursion() {
        return this.mCurrentEvaluationRecursion;
    }

    protected final int getCurrentInverseEvaluationRecursion() {
        return this.mCurrentInverseEvaluationRecursion;
    }

    protected final Evaluator<VALUE, STATE> getSubEvaluator(int n) {
        if (n < 0 || n >= this.mSubEvaluators.size()) {
            throw new UnsupportedOperationException("No evaluator with index " + n + " present.");
        }
        return this.mSubEvaluators.get(n);
    }

    protected final int getNumberOfSubEvaluators() {
        return this.mSubEvaluators.size();
    }

    public final int getEvaluationRecursionDepth() {
        return Math.max(this.mCurrentEvaluationRecursion, this.mSubEvaluators.stream().mapToInt(Evaluator::getEvaluationRecursionDepth).max().orElse(0));
    }

    public final int getInverseEvaluationRecursionDepth() {
        return Math.max(this.mCurrentInverseEvaluationRecursion, this.mSubEvaluators.stream().mapToInt(Evaluator::getInverseEvaluationRecursionDepth).max().orElse(0));
    }
}

