/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.ITermProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.AffineExpression;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.BoolValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctInterval;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntervalProjection {
    private final IBoogieSymbolTableVariableProvider mBpl2smtSymbolTable;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$relational$octagon$BoolValue;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$nonrelational$BooleanValue;

    public IntervalProjection(IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider) {
        this.mBpl2smtSymbolTable = iBoogieSymbolTableVariableProvider;
    }

    public List<OctDomainState> assignNumericVarWithoutIfs(IProgramVarOrConst iProgramVarOrConst, Expression expression, List<OctDomainState> list) {
        list = OctPostOperator.removeBottomStates(list);
        for (OctDomainState octDomainState : list) {
            IntervalDomainValue intervalDomainValue = this.projectNumericExprWithoutIfs(expression, octDomainState);
            octDomainState.assignNumericVarInterval(iProgramVarOrConst, new OctInterval(intervalDomainValue));
        }
        return list;
    }

    public List<OctDomainState> assignNumericVarAffine(IProgramVarOrConst iProgramVarOrConst, AffineExpression affineExpression, List<OctDomainState> list) {
        list = OctPostOperator.removeBottomStates(list);
        for (OctDomainState octDomainState : list) {
            IntervalDomainValue intervalDomainValue = this.projectAffineExpr(affineExpression, octDomainState);
            octDomainState.assignNumericVarInterval(iProgramVarOrConst, new OctInterval(intervalDomainValue));
        }
        return list;
    }

    public IntervalDomainValue projectNumericExprWithoutIfs(Expression expression, OctDomainState octDomainState) {
        if (expression instanceof IntegerLiteral) {
            IntervalValue intervalValue = new IntervalValue(((IntegerLiteral)expression).getValue());
            return new IntervalDomainValue(intervalValue, intervalValue);
        }
        if (expression instanceof RealLiteral) {
            IntervalValue intervalValue = new IntervalValue(((RealLiteral)expression).getValue());
            return new IntervalDomainValue(intervalValue, intervalValue);
        }
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            IProgramVar iProgramVar = this.mBpl2smtSymbolTable.getBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), false);
            assert (iProgramVar != null);
            OctInterval octInterval = octDomainState.projectToInterval((IProgramVarOrConst)iProgramVar);
            return octInterval.toIvlInterval();
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            switch (unaryExpression.getOperator()) {
                case ARITHNEGATIVE: {
                    return this.projectNumericExprWithoutIfs(unaryExpression.getExpr(), octDomainState).negate();
                }
            }
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            IntervalDomainValue intervalDomainValue = this.projectNumericExprWithoutIfs(binaryExpression.getLeft(), octDomainState);
            IntervalDomainValue intervalDomainValue2 = this.projectNumericExprWithoutIfs(binaryExpression.getRight(), octDomainState);
            switch (binaryExpression.getOperator()) {
                case ARITHPLUS: {
                    return intervalDomainValue.add(intervalDomainValue2);
                }
                case ARITHMINUS: {
                    return intervalDomainValue.subtract(intervalDomainValue2);
                }
                case ARITHMUL: {
                    return intervalDomainValue.multiply(intervalDomainValue2);
                }
                case ARITHDIV: {
                    if (TypeUtils.isNumericInt(binaryExpression.getType())) {
                        return intervalDomainValue.divideInteger(intervalDomainValue2);
                    }
                    return intervalDomainValue.divideReal(intervalDomainValue2);
                }
                case ARITHMOD: {
                    assert (TypeUtils.isNumericInt(binaryExpression.getType()));
                    return intervalDomainValue.modulo(intervalDomainValue2);
                }
            }
        }
        return new IntervalDomainValue();
    }

    public IntervalDomainValue projectAffineExpr(AffineExpression affineExpression, OctDomainState octDomainState) {
        IntervalDomainValue intervalDomainValue = new IntervalDomainValue(0, 0);
        for (Map.Entry<IProgramVarOrConst, BigDecimal> object2 : affineExpression.getCoefficients().entrySet()) {
            IntervalDomainValue intervalDomainValue2 = octDomainState.projectToInterval(object2.getKey()).toIvlInterval();
            IntervalValue intervalValue = new IntervalValue(object2.getValue());
            intervalDomainValue = intervalDomainValue.add(intervalDomainValue2.multiply(new IntervalDomainValue(intervalValue, intervalValue)));
        }
        IntervalValue intervalValue = new IntervalValue(affineExpression.getConstant());
        intervalDomainValue = intervalDomainValue.add(new IntervalDomainValue(intervalValue, intervalValue));
        return intervalDomainValue;
    }

    protected static IntervalDomainState projectOctagonStateToIntervalDomainState(ILogger iLogger, OctDomainState octDomainState) {
        ImmutableSet<IProgramVarOrConst> immutableSet = octDomainState.getVariables();
        HashMap<IProgramVarOrConst, IntervalDomainValue> hashMap = new HashMap<IProgramVarOrConst, IntervalDomainValue>();
        HashMap<IProgramVarOrConst, BooleanValue> hashMap2 = new HashMap<IProgramVarOrConst, BooleanValue>();
        for (IProgramVarOrConst iProgramVarOrConst : immutableSet) {
            Object object;
            Sort sort = iProgramVarOrConst.getSort().getRealSort();
            if (SmtSortUtils.isNumericSort((Sort)sort)) {
                object = octDomainState.projectToInterval(iProgramVarOrConst).toIvlInterval();
                hashMap.put(iProgramVarOrConst, (IntervalDomainValue)object);
                continue;
            }
            if (SmtSortUtils.isBoolSort((Sort)sort)) {
                object = octDomainState.getBoolValue(iProgramVarOrConst);
                hashMap2.put(iProgramVarOrConst, switch (IntervalProjection.$SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$relational$octagon$BoolValue()[((Enum)object).ordinal()]) {
                    case 1 -> BooleanValue.BOTTOM;
                    case 2 -> BooleanValue.FALSE;
                    case 4 -> BooleanValue.TOP;
                    case 3 -> BooleanValue.TRUE;
                    default -> throw new UnsupportedOperationException("Unsupported boolean value: " + String.valueOf(object));
                });
                continue;
            }
            if (SmtSortUtils.isArraySort((Sort)sort)) {
                hashMap.put(iProgramVarOrConst, new IntervalDomainValue());
                continue;
            }
            throw new UnsupportedOperationException("Unsupported sort: " + String.valueOf(iProgramVarOrConst.getSort()));
        }
        return new IntervalDomainState(iLogger, (Set<IProgramVarOrConst>)immutableSet, (Map<IProgramVarOrConst, IntervalDomainValue>)hashMap, (Map<IProgramVarOrConst, BooleanValue>)hashMap2, octDomainState.isBottom());
    }

    protected static OctDomainState projectIntervalStateToOctagon(ILogger iLogger, IntervalDomainState intervalDomainState, OctDomainState octDomainState, Set<IProgramVarOrConst> set) {
        if (intervalDomainState.isBottom()) {
            return octDomainState.createFreshBottomState();
        }
        ImmutableSet<IProgramVarOrConst> immutableSet = intervalDomainState.getVariables();
        OctDomainState octDomainState2 = octDomainState.deepCopy();
        for (IProgramVarOrConst iProgramVarOrConst : immutableSet) {
            ITermProvider iTermProvider;
            if (set != null && !set.contains(iProgramVarOrConst)) continue;
            Sort sort = iProgramVarOrConst.getSort().getRealSort();
            if (SmtSortUtils.isNumericSort((Sort)sort)) {
                iTermProvider = (IntervalDomainValue)intervalDomainState.getValue(iProgramVarOrConst);
                octDomainState2.assignNumericVarInterval(iProgramVarOrConst, new OctInterval((IntervalDomainValue)iTermProvider));
                continue;
            }
            if (SmtSortUtils.isBoolSort((Sort)sort)) {
                iTermProvider = intervalDomainState.getBooleanValue(iProgramVarOrConst);
                octDomainState2.assignBooleanVar(iProgramVarOrConst, switch (IntervalProjection.$SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$nonrelational$BooleanValue()[((Enum)((Object)iTermProvider)).ordinal()]) {
                    case 4 -> BoolValue.BOT;
                    case 2 -> BoolValue.FALSE;
                    case 3 -> BoolValue.TOP;
                    case 1 -> BoolValue.TRUE;
                    default -> throw new UnsupportedOperationException("Unsupported bool value: " + String.valueOf(iTermProvider));
                });
                continue;
            }
            if (SmtSortUtils.isArraySort((Sort)sort)) continue;
            throw new UnsupportedOperationException("Unsupported sort: " + String.valueOf(sort));
        }
        return octDomainState2;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$relational$octagon$BoolValue() {
        if ($SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$relational$octagon$BoolValue != null) {
            return $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$relational$octagon$BoolValue;
        }
        int[] nArray = new int[BoolValue.values().length];
        try {
            nArray[BoolValue.BOT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BoolValue.FALSE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BoolValue.TOP.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BoolValue.TRUE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$relational$octagon$BoolValue = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$nonrelational$BooleanValue() {
        if ($SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$nonrelational$BooleanValue != null) {
            return $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$nonrelational$BooleanValue;
        }
        int[] nArray = new int[BooleanValue.values().length];
        try {
            nArray[BooleanValue.BOTTOM.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BooleanValue.FALSE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BooleanValue.INVALID.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BooleanValue.TOP.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BooleanValue.TRUE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$analysis$abstractinterpretationv2$domain$nonrelational$BooleanValue = nArray;
        return nArray;
    }
}

