/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.WitnessInvariant;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.WitnessProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.lib.results.InvariantResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ProcedureContractResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.proofs.ISpecification;
import de.uni_freiburg.informatik.ultimate.lib.proofs.PrePostConditionSpecification;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FloydHoareUtils {
    private FloydHoareUtils() {
    }

    public static <LOC extends IcfgLocation> void writeHoareAnnotationToLogger(IIcfg<LOC> iIcfg, IFloydHoareAnnotation<LOC> iFloydHoareAnnotation, ILogger iLogger, boolean bl) {
        for (Map.Entry entry : iIcfg.getProgramPoints().entrySet()) {
            for (IcfgLocation icfgLocation : ((Map)entry.getValue()).values()) {
                IPredicate iPredicate = iFloydHoareAnnotation.getAnnotation(icfgLocation);
                if (iPredicate == null) {
                    iLogger.info("For program point %s no Hoare annotation was computed.", new Object[]{FloydHoareUtils.prettyPrintProgramPoint(icfgLocation)});
                    continue;
                }
                if (!bl && SmtUtils.isTrueLiteral((Term)iPredicate.getFormula())) continue;
                iLogger.info("At program point %s the Hoare annotation is: %s", new Object[]{FloydHoareUtils.prettyPrintProgramPoint(icfgLocation), iPredicate.getFormula()});
            }
        }
    }

    private static String prettyPrintProgramPoint(IcfgLocation icfgLocation) {
        ILocation iLocation = ILocation.getAnnotation((IElement)icfgLocation);
        if (iLocation == null) {
            return "";
        }
        int n = iLocation.getStartLine();
        int n2 = iLocation.getEndLine();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(icfgLocation);
        if (n == n2) {
            stringBuilder.append("(line ");
            stringBuilder.append(n);
        } else {
            stringBuilder.append("(lines ");
            stringBuilder.append(n);
            stringBuilder.append(" ");
            stringBuilder.append(n2);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static void createInvariantResults(String string, IIcfg<IcfgLocation> iIcfg, IFloydHoareAnnotation<IcfgLocation> iFloydHoareAnnotation, IBacktranslationService iBacktranslationService, Consumer<InvariantResult<IIcfgElement, ?>> consumer) {
        Set<Check> set = FloydHoareUtils.getCheckedSpecifications(iIcfg, iFloydHoareAnnotation);
        HashSet hashSet = new HashSet(iIcfg.getLoopLocations());
        hashSet.addAll(iIcfg.getLocationsOfInterest());
        for (IcfgLocation icfgLocation : hashSet) {
            String string2;
            ILocation iLocation;
            IPredicate iPredicate = iFloydHoareAnnotation.getAnnotation(icfgLocation);
            if (iPredicate == null) continue;
            Term term = iPredicate.getFormula();
            Object object = iBacktranslationService.translateExpressionWithContext((Object)term, (Object)(iLocation = ILocation.getAnnotation((IElement)icfgLocation)), Term.class);
            String string3 = string2 = object == null ? null : iBacktranslationService.targetExpressionToString(object);
            if (object == null || string2.equals("1") || string2.equals("true")) continue;
            InvariantResult invariantResult = new InvariantResult(string, (IElement)icfgLocation, object, string2, set);
            consumer.accept(invariantResult);
            new WitnessInvariant(invariantResult.getInvariant()).annotate((IElement)icfgLocation);
        }
    }

    public static void createProcedureContractResults(IUltimateServiceProvider iUltimateServiceProvider, String string, IIcfg<IcfgLocation> iIcfg, IFloydHoareAnnotation<IcfgLocation> iFloydHoareAnnotation, IBacktranslationService iBacktranslationService, Consumer<ProcedureContractResult<IIcfgElement, ?>> consumer) {
        Set<Check> set = FloydHoareUtils.getCheckedSpecifications(iIcfg, iFloydHoareAnnotation);
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(FloydHoareUtils.class);
        Map map = iIcfg.getProcedureExitNodes();
        Map map2 = iIcfg.getProcedureEntryNodes();
        for (Map.Entry entry : map2.entrySet()) {
            Term term;
            String string2 = (String)entry.getKey();
            if (FloydHoareUtils.isAuxiliaryProcedure(string2)) continue;
            IcfgLocation icfgLocation = (IcfgLocation)entry.getValue();
            IPredicate iPredicate = iFloydHoareAnnotation.getAnnotation(icfgLocation);
            Term term2 = term = iPredicate == null ? null : PredicateUtils.eliminateOldVars((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)cfgSmtToolkit.getManagedScript(), (IPredicate)iPredicate);
            if (iPredicate != null && FloydHoareUtils.containsOldVar(iPredicate)) {
                iLogger.warn("Requires clause for %s contained old-variable. Original clause: %s  Eliminated clause: %s", new Object[]{string2, iPredicate.getFormula(), term});
            }
            FloydHoareUtils.checkPermissibleVariables(term, FloydHoareUtils.permissibleForRequires(string2, cfgSmtToolkit), "requires for " + string2);
            IcfgLocation icfgLocation2 = (IcfgLocation)map.get(string2);
            assert (icfgLocation2 != null) : "Icfg must contain exit node for every procedure";
            IPredicate iPredicate2 = iFloydHoareAnnotation.getAnnotation(icfgLocation2);
            Term term3 = iPredicate2 == null ? null : PredicateUtils.eliminateLocalVars((IPredicate)iPredicate2, (IUltimateServiceProvider)iUltimateServiceProvider, (CfgSmtToolkit)cfgSmtToolkit);
            FloydHoareUtils.checkPermissibleVariables(term3, FloydHoareUtils.permissibleForEnsures(string2, cfgSmtToolkit), "ensures for " + string2);
            Set set2 = cfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(string2).stream().map(IProgramVar::getTermVariable).collect(Collectors.toSet());
            ProcedureContract procedureContract = new ProcedureContract(string2, (Object)(term == null || SmtUtils.isTrueLiteral((Term)term) ? null : term), (Object)(term3 == null || SmtUtils.isTrueLiteral((Term)term3) ? null : term3), set2);
            ILocation iLocation = ILocation.getAnnotation((IElement)icfgLocation2);
            ProcedureContract procedureContract2 = iBacktranslationService.translateProcedureContract(procedureContract, (Object)iLocation, Term.class);
            if (procedureContract2 == null || procedureContract2.hasOnlyTrivialClauses()) continue;
            ProcedureContractResult procedureContractResult = new ProcedureContractResult(string, (IElement)icfgLocation2, string2, procedureContract2, iBacktranslationService.targetProcedureContractToString(procedureContract2), set);
            consumer.accept(procedureContractResult);
            new WitnessProcedureContract(procedureContract2).annotate((IElement)icfgLocation2);
        }
    }

    private static boolean containsOldVar(IPredicate iPredicate) {
        return iPredicate.getVars().stream().anyMatch(IProgramOldVar.class::isInstance);
    }

    private static void checkPermissibleVariables(Term term, Set<TermVariable> set, String string) {
        if (term == null) {
            return;
        }
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            if (!set.contains(termVariable)) {
                throw new IllegalStateException("Variable " + String.valueOf(termVariable) + " not permitted in " + string + ": " + String.valueOf(term));
            }
            ++n2;
        }
    }

    private static Set<TermVariable> permissibleForRequires(String string, CfgSmtToolkit cfgSmtToolkit) {
        Stream stream = cfgSmtToolkit.getSymbolTable().getGlobals().stream();
        Stream stream2 = ((List)cfgSmtToolkit.getInParams().get(string)).stream();
        return Stream.concat(stream, stream2).map(IProgramVar::getTermVariable).collect(Collectors.toSet());
    }

    private static Set<TermVariable> permissibleForEnsures(String string, CfgSmtToolkit cfgSmtToolkit) {
        Set set = cfgSmtToolkit.getSymbolTable().getGlobals();
        Stream<IProgramOldVar> stream = set.stream().map(IProgramNonOldVar::getOldVar);
        Stream stream2 = ((List)cfgSmtToolkit.getInParams().get(string)).stream();
        Stream stream3 = ((List)cfgSmtToolkit.getOutParams().get(string)).stream();
        return Stream.concat(Stream.concat(set.stream(), stream), Stream.concat(stream2, stream3)).map(IProgramVar::getTermVariable).collect(Collectors.toSet());
    }

    private static Set<Check> getCheckedSpecifications(IIcfg<?> iIcfg, IFloydHoareAnnotation<IcfgLocation> iFloydHoareAnnotation) {
        ISpecification iSpecification = iFloydHoareAnnotation.getSpecification();
        assert (((PrePostConditionSpecification)iSpecification).isUnreachabilitySpecification()) : "Only unreachability specifications currently supported";
        return IcfgUtils.getAllLocations(iIcfg).filter(((PrePostConditionSpecification)iSpecification)::isFinalState).map(Check::getAnnotation).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static boolean isAuxiliaryProcedure(String string) {
        return "ULTIMATE.init".equals(string) || "ULTIMATE.start".equals(string);
    }
}

