/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.icfgtochc;

import de.uni_freiburg.informatik.ultimate.lib.chc.HcBodyAuxVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcBodyVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.IcfgToChcObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ChcProviderForCalls
implements IcfgToChcObserver.IChcProvider {
    private final ManagedScript mMgdScript;
    private final HcSymbolTable mHcSymbolTable;
    private IIcfg<IcfgLocation> mIcfg;
    private final Map<String, List<IProgramVar>> mProcToVarList = new LinkedHashMap<String, List<IProgramVar>>();
    private final TermVariable mAssertionViolatedVar;
    private final Map<TermVariable, IProgramVar> mTermVarToProgVar = new LinkedHashMap<TermVariable, IProgramVar>();
    private static final String ASSERTIONVIOLATEDVARNAME = "V";

    public ChcProviderForCalls(ManagedScript managedScript, HcSymbolTable hcSymbolTable) {
        this.mMgdScript = managedScript;
        this.mHcSymbolTable = hcSymbolTable;
        this.mMgdScript.lock((Object)this);
        this.mAssertionViolatedVar = this.mMgdScript.constructFreshTermVariable(ASSERTIONVIOLATEDVARNAME, SmtSortUtils.getBoolSort((ManagedScript)this.mMgdScript));
    }

    @Override
    public Collection<HornClause> getHornClauses(IIcfg<IcfgLocation> iIcfg) {
        this.mIcfg = iIcfg;
        ArrayList<HornClause> arrayList = new ArrayList<HornClause>();
        IcfgEdgeIterator icfgEdgeIterator = new IcfgEdgeIterator(this.mIcfg);
        while (icfgEdgeIterator.hasNext()) {
            Object object;
            IcfgEdge icfgEdge = icfgEdgeIterator.next();
            if (icfgEdge instanceof IIcfgInternalTransition) {
                if (icfgEdge instanceof IIcfgSummaryTransition) {
                    object = (IIcfgSummaryTransition)icfgEdge;
                    if (object.calledProcedureHasImplementation()) continue;
                    Collection<HornClause> collection = this.computeChcForInternalEdge((IIcfgInternalTransition<IcfgLocation>)((IIcfgInternalTransition)icfgEdge));
                    collection.forEach(hornClause -> hornClause.setComment("Type: internal"));
                    arrayList.addAll(collection);
                    continue;
                }
                if (this.isErrorLocation((IcfgLocation)icfgEdge.getTarget())) {
                    object = this.computeChcForInternalErrorEdge((IIcfgInternalTransition<IcfgLocation>)((IIcfgInternalTransition)icfgEdge));
                    object.forEach(hornClause -> hornClause.setComment("Type: assert edge"));
                } else {
                    object = this.computeChcForInternalEdge((IIcfgInternalTransition<IcfgLocation>)((IIcfgInternalTransition)icfgEdge));
                    object.forEach(hornClause -> hornClause.setComment("Type: internal"));
                }
                arrayList.addAll((Collection<HornClause>)object);
                continue;
            }
            if (icfgEdge instanceof IIcfgCallTransition) continue;
            if (icfgEdge instanceof IIcfgReturnTransition) {
                object = this.computeChcForReturnEdge((IIcfgReturnTransition<IcfgLocation, Call>)((IIcfgReturnTransition)icfgEdge));
                object.forEach(hornClause -> hornClause.setComment("Type: return edge"));
                arrayList.addAll((Collection<HornClause>)object);
                continue;
            }
            throw new AssertionError((Object)"unforseen edge type (not internal, call, or return");
        }
        this.computeClausesForEntryPoints(this.mIcfg, arrayList);
        this.computeClausesForExitPoints(this.mIcfg, arrayList);
        this.mHcSymbolTable.finishConstruction();
        this.mMgdScript.unlock((Object)this);
        return arrayList;
    }

    private <LOC extends IcfgLocation> void computeClausesForEntryPoints(IIcfg<LOC> iIcfg, Collection<HornClause> collection) {
        for (Map.Entry entry : iIcfg.getProcedureEntryNodes().entrySet()) {
            IProgramVar iProgramVar;
            TermVariable termVariable;
            String string = (String)entry.getKey();
            HcPredicateSymbol hcPredicateSymbol = this.getOrConstructPredicateSymbolForIcfgLocation((IcfgLocation)entry.getValue());
            LinkedHashMap<TermVariable, TermVariable> linkedHashMap = new LinkedHashMap<TermVariable, TermVariable>();
            HcHeadVar hcHeadVar = null;
            ArrayList<HcHeadVar> arrayList = new ArrayList<HcHeadVar>();
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            Term term = this.getTermVariableListForPredForProcedure(string);
            int n = 0;
            while (n < term.size()) {
                termVariable = term.get(n);
                iProgramVar = this.mTermVarToProgVar.get(termVariable);
                HcHeadVar hcHeadVar2 = this.getPrettyHeadVar(hcPredicateSymbol, n, termVariable.getSort(), (IProgramVarOrConst)iProgramVar);
                arrayList.add(hcHeadVar2);
                if (termVariable.equals(this.mAssertionViolatedVar)) {
                    hcHeadVar = hcHeadVar2;
                } else if (iProgramVar.isGlobal()) {
                    if (!iProgramVar.isOldvar()) {
                        if (this.mIcfg.getCfgSmtToolkit().getModifiableGlobalsTable().getModifiedBoogieVars(string).contains(iProgramVar)) {
                            arrayList2.add(SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)iProgramVar.getTermVariable(), (Term)((IProgramNonOldVar)iProgramVar).getOldVar().getTermVariable()));
                            linkedHashMap.put(iProgramVar.getTermVariable(), hcHeadVar2.getTermVariable());
                        }
                    } else if (iProgramVar.isOldvar() && this.mIcfg.getCfgSmtToolkit().getModifiableGlobalsTable().getModifiedBoogieVars(string).contains(((IProgramOldVar)iProgramVar).getNonOldVar())) {
                        linkedHashMap.put(iProgramVar.getTermVariable(), hcHeadVar2.getTermVariable());
                    }
                }
                ++n;
            }
            term = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])arrayList2.toArray(new Term[arrayList2.size()]));
            Term term2 = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{SmtUtils.not((Script)this.mMgdScript.getScript(), (Term)hcHeadVar.getTermVariable()), term});
            termVariable = PureSubstitution.apply((ManagedScript)this.mMgdScript, linkedHashMap, (Term)term2);
            this.updateLogicWrtConstraint((Term)termVariable);
            if (!this.checkNoFreeVars(arrayList, Collections.emptySet(), (Term)termVariable)) {
                throw new UnsupportedOperationException("implement this");
            }
            iProgramVar = new HornClause(this.mMgdScript, this.mHcSymbolTable, (Term)termVariable, hcPredicateSymbol, arrayList, Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
            iProgramVar.setComment("Type: (not V) -> procEntry");
            collection.add((HornClause)iProgramVar);
        }
    }

    private <LOC extends IcfgLocation> void computeClausesForExitPoints(IIcfg<LOC> iIcfg, Collection<HornClause> collection) {
        for (Map.Entry entry : iIcfg.getProcedureExitNodes().entrySet()) {
            TermVariable termVariable;
            String string = (String)entry.getKey();
            IcfgLocation icfgLocation = (IcfgLocation)iIcfg.getProcedureEntryNodes().get(string);
            if (!iIcfg.getInitialNodes().contains(icfgLocation)) continue;
            HcPredicateSymbol hcPredicateSymbol = this.getOrConstructPredicateSymbolForIcfgLocation((IcfgLocation)entry.getValue());
            List<TermVariable> list = this.getTermVariableListForPredForProcedure((String)entry.getKey());
            LinkedHashSet<HcVar> linkedHashSet = new LinkedHashSet<HcVar>();
            ArrayList<Term> arrayList = new ArrayList<Term>();
            HcBodyVar hcBodyVar = null;
            int n = 0;
            while (n < list.size()) {
                termVariable = list.get(n);
                HcBodyVar hcBodyVar2 = this.getPrettyBodyVar(hcPredicateSymbol, n, termVariable.getSort(), (IProgramVarOrConst)this.mTermVarToProgVar.get(termVariable));
                linkedHashSet.add((HcVar)hcBodyVar2);
                arrayList.add(hcBodyVar2.getTerm());
                if (termVariable.equals(this.mAssertionViolatedVar)) {
                    hcBodyVar = hcBodyVar2;
                }
                ++n;
            }
            TermVariable termVariable2 = hcBodyVar.getTermVariable();
            this.updateLogicWrtConstraint((Term)termVariable2);
            if (!this.checkNoFreeVars(Collections.emptyList(), linkedHashSet, (Term)termVariable2)) {
                throw new UnsupportedOperationException("implement this");
            }
            termVariable = new HornClause(this.mMgdScript, this.mHcSymbolTable, (Term)termVariable2, Collections.singletonList(hcPredicateSymbol), Collections.singletonList(arrayList), linkedHashSet);
            termVariable.setComment("Type: entryProcExit(..., V) /\\ V -> false");
            collection.add((HornClause)termVariable);
        }
    }

    private Collection<HornClause> computeChcForReturnEdge(IIcfgReturnTransition<IcfgLocation, Call> iIcfgReturnTransition) {
        TermVariable termVariable;
        HcBodyVar hcBodyVar;
        IProgramVar iProgramVar;
        Object object;
        TermVariable termVariable2;
        HcHeadVar hcHeadVar;
        Object object2;
        Object object3;
        UnmodifiableTransFormula unmodifiableTransFormula = iIcfgReturnTransition.getAssignmentOfReturn();
        UnmodifiableTransFormula unmodifiableTransFormula2 = iIcfgReturnTransition.getLocalVarsAssignmentOfCall();
        UnmodifiableTransFormula unmodifiableTransFormula3 = this.mIcfg.getCfgSmtToolkit().getOldVarsAssignmentCache().getOldVarsAssignment(iIcfgReturnTransition.getPrecedingProcedure());
        List<TermVariable> list = this.getTermVariableListForPredForProcedure(iIcfgReturnTransition.getPrecedingProcedure());
        List<TermVariable> list2 = this.getTermVariableListForPredForProcedure(iIcfgReturnTransition.getSucceedingProcedure());
        if (this.isErrorLocation(iIcfgReturnTransition.getTarget())) {
            throw new AssertionError((Object)"return edge whose target is an error location -- that is unexpected");
        }
        if (this.mIcfg.getInitialNodes().contains(iIcfgReturnTransition.getSource())) {
            throw new AssertionError((Object)"source of a return edge is an initial location -- that is unexpected");
        }
        LinkedHashMap<TermVariable, TermVariable> linkedHashMap = new LinkedHashMap<TermVariable, TermVariable>();
        LinkedHashMap<Object, TermVariable> linkedHashMap2 = new LinkedHashMap<Object, TermVariable>();
        LinkedHashMap<Object, TermVariable> linkedHashMap3 = new LinkedHashMap<Object, TermVariable>();
        HcPredicateSymbol hcPredicateSymbol = this.getOrConstructPredicateSymbolForIcfgLocation(iIcfgReturnTransition.getTarget());
        HcHeadVar hcHeadVar2 = null;
        ArrayList<HcHeadVar> arrayList = new ArrayList<HcHeadVar>();
        int n = 0;
        while (n < list2.size()) {
            object3 = list2.get(n);
            object2 = (IProgramVarOrConst)this.mTermVarToProgVar.get(object3);
            hcHeadVar = this.getPrettyHeadVar(hcPredicateSymbol, n, object3.getSort(), (IProgramVarOrConst)object2);
            arrayList.add(hcHeadVar);
            if (object3.equals(this.mAssertionViolatedVar)) {
                hcHeadVar2 = hcHeadVar;
            } else if (!object2.isGlobal() && (termVariable2 = (TermVariable)unmodifiableTransFormula.getOutVars().get(object2)) != null) {
                linkedHashMap.put(termVariable2, hcHeadVar.getTermVariable());
            }
            ++n;
        }
        hcHeadVar = null;
        termVariable2 = null;
        ArrayList<HcPredicateSymbol> arrayList2 = new ArrayList<HcPredicateSymbol>();
        arrayList2.add(this.getOrConstructPredicateSymbolForIcfgLocation(iIcfgReturnTransition.getCallerProgramPoint()));
        arrayList2.add(this.getOrConstructPredicateSymbolForIcfgLocation(iIcfgReturnTransition.getSource()));
        object2 = new LinkedHashSet();
        TermVariable termVariable32 = new ArrayList();
        int n2 = 0;
        while (n2 < list2.size()) {
            TermVariable termVariable4 = list2.get(n2);
            object = (IProgramVarOrConst)this.mTermVarToProgVar.get(termVariable4);
            iProgramVar = this.getPrettyBodyVar((HcPredicateSymbol)arrayList2.get(0), n2, termVariable4.getSort(), (IProgramVarOrConst)object);
            object2.add(iProgramVar);
            if (termVariable4.equals(this.mAssertionViolatedVar)) {
                termVariable32.add(iProgramVar.getTermVariable());
                hcHeadVar = iProgramVar;
            } else if (object.isGlobal()) {
                if (this.mIcfg.getCfgSmtToolkit().getModifiableGlobalsTable().getModifiedBoogieVars(iIcfgReturnTransition.getPrecedingProcedure()).contains(object)) {
                    termVariable32.add(iProgramVar.getTermVariable());
                    hcBodyVar = (TermVariable)unmodifiableTransFormula3.getInVars().get(object);
                    assert (hcBodyVar != null);
                    linkedHashMap3.put(hcBodyVar, iProgramVar.getTermVariable());
                    termVariable = (TermVariable)unmodifiableTransFormula2.getInVars().get(object);
                    if (termVariable != null) {
                        linkedHashMap2.put(termVariable, iProgramVar.getTermVariable());
                    }
                } else {
                    termVariable32.add(((HcHeadVar)arrayList.get(n2)).getTermVariable());
                    hcBodyVar = (TermVariable)unmodifiableTransFormula2.getInVars().get(object);
                    if (hcBodyVar != null) {
                        linkedHashMap2.put(hcBodyVar, ((HcHeadVar)arrayList.get(n2)).getTermVariable());
                    }
                }
            } else {
                if (unmodifiableTransFormula.getAssignedVars().contains(object)) {
                    termVariable32.add(iProgramVar.getTermVariable());
                } else {
                    termVariable32.add(((HcHeadVar)arrayList.get(n2)).getTermVariable());
                }
                hcBodyVar = (TermVariable)unmodifiableTransFormula2.getInVars().get(object);
                if (hcBodyVar != null) {
                    linkedHashMap2.put(hcBodyVar, ((HcHeadVar)arrayList.get(n2)).getTermVariable());
                }
            }
            ++n2;
        }
        Term term = new ArrayList();
        int n3 = 0;
        while (n3 < list.size()) {
            object = list.get(n3);
            iProgramVar = this.mTermVarToProgVar.get(object);
            hcBodyVar = this.getPrettyBodyVar((HcPredicateSymbol)arrayList2.get(1), n3, object.getSort(), (IProgramVarOrConst)iProgramVar);
            object2.add(hcBodyVar);
            if (object.equals(this.mAssertionViolatedVar)) {
                term.add((TermVariable)hcBodyVar.getTermVariable());
                termVariable2 = hcBodyVar;
            } else if (iProgramVar.isGlobal()) {
                if (iProgramVar.isOldvar()) {
                    term.add((TermVariable)hcBodyVar.getTermVariable());
                    termVariable = (TermVariable)unmodifiableTransFormula3.getOutVars().get(iProgramVar);
                    assert (termVariable != null);
                    linkedHashMap3.put(termVariable, hcBodyVar.getTermVariable());
                } else {
                    int n4 = list2.indexOf(iProgramVar.getTermVariable());
                    var25_33 = (HcHeadVar)arrayList.get(n4);
                    term.add((TermVariable)var25_33.getTermVariable());
                }
            } else {
                termVariable = (TermVariable)unmodifiableTransFormula2.getOutVars().get(iProgramVar);
                var25_33 = (TermVariable)unmodifiableTransFormula.getInVars().get(iProgramVar);
                if (termVariable == null && var25_33 == null) {
                    term.add((TermVariable)hcBodyVar.getTermVariable());
                } else if (termVariable != null && var25_33 == null) {
                    term.add((TermVariable)hcBodyVar.getTermVariable());
                    linkedHashMap2.put(termVariable, hcBodyVar.getTermVariable());
                } else if (termVariable == null && var25_33 != null) {
                    term.add((TermVariable)hcBodyVar.getTermVariable());
                    linkedHashMap.put(var25_33, hcBodyVar.getTermVariable());
                } else {
                    throw new AssertionError();
                }
            }
            ++n3;
        }
        object3 = new ArrayList();
        object3.add(termVariable32);
        object3.add(term);
        for (TermVariable termVariable32 : unmodifiableTransFormula2.getAuxVars()) {
            HcBodyAuxVar hcBodyAuxVar = this.mHcSymbolTable.getOrConstructBodyAuxVar(termVariable32, (Object)this);
            object2.add(hcBodyAuxVar);
        }
        for (TermVariable termVariable32 : unmodifiableTransFormula.getAuxVars()) {
            HcBodyAuxVar hcBodyAuxVar = this.mHcSymbolTable.getOrConstructBodyAuxVar(termVariable32, (Object)this);
            object2.add(hcBodyAuxVar);
        }
        for (TermVariable termVariable32 : unmodifiableTransFormula3.getAuxVars()) {
            HcBodyAuxVar hcBodyAuxVar = this.mHcSymbolTable.getOrConstructBodyAuxVar(termVariable32, (Object)this);
            object2.add(hcBodyAuxVar);
        }
        termVariable32 = SmtUtils.binaryBooleanEquality((Script)this.mMgdScript.getScript(), (Term)hcHeadVar2.getTermVariable(), (Term)SmtUtils.or((Script)this.mMgdScript.getScript(), (Term[])new Term[]{hcHeadVar.getTermVariable(), termVariable2.getTermVariable()}));
        term = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{PureSubstitution.apply((ManagedScript)this.mMgdScript, linkedHashMap2, (Term)unmodifiableTransFormula2.getFormula()), PureSubstitution.apply((ManagedScript)this.mMgdScript, linkedHashMap, (Term)unmodifiableTransFormula.getFormula()), PureSubstitution.apply((ManagedScript)this.mMgdScript, linkedHashMap3, (Term)unmodifiableTransFormula3.getFormula()), termVariable32});
        if (!this.checkNoFreeVars(arrayList, (Set<HcVar>)object2, term)) {
            throw new UnsupportedOperationException("implement this");
        }
        Term term2 = term;
        this.updateLogicWrtConstraint(term2);
        object = new ArrayList();
        object.add(new HornClause(this.mMgdScript, this.mHcSymbolTable, term2, hcPredicateSymbol, arrayList, arrayList2, (List)object3, (Set)object2));
        return object;
    }

    @Deprecated
    private void updateLogicWrtConstraint(Term term) {
    }

    private boolean checkNoFreeVars(List<HcHeadVar> list, Set<HcVar> set, Term term) {
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        if (list != null) {
            linkedHashSet.removeAll(list.stream().map(hcHeadVar -> hcHeadVar.getTermVariable()).collect(Collectors.toList()));
        }
        linkedHashSet.removeAll(set.stream().map(hcVar -> hcVar.getTermVariable()).collect(Collectors.toList()));
        linkedHashSet.remove(this.mAssertionViolatedVar);
        return linkedHashSet.isEmpty();
    }

    private Collection<HornClause> computeChcForInternalErrorEdge(IIcfgInternalTransition<IcfgLocation> iIcfgInternalTransition) {
        Object object;
        HcHeadVar hcHeadVar3;
        IProgramVarOrConst iProgramVarOrConst;
        Object object2;
        UnmodifiableTransFormula unmodifiableTransFormula = iIcfgInternalTransition.getTransformula();
        String string = iIcfgInternalTransition.getPrecedingProcedure();
        List<TermVariable> list = this.getTermVariableListForPredForProcedure(string);
        LinkedHashMap<TermVariable, TermVariable> linkedHashMap = new LinkedHashMap<TermVariable, TermVariable>();
        HcPredicateSymbol hcPredicateSymbol = this.getOrConstructPredicateSymbolForIcfgLocation((IcfgLocation)this.mIcfg.getProcedureExitNodes().get(string));
        ArrayList<HcHeadVar> arrayList = new ArrayList<HcHeadVar>();
        HcHeadVar hcHeadVar2 = null;
        int n = 0;
        while (n < list.size()) {
            object2 = list.get(n);
            iProgramVarOrConst = (IProgramVarOrConst)this.mTermVarToProgVar.get(object2);
            hcHeadVar3 = this.getPrettyHeadVar(hcPredicateSymbol, n, object2.getSort(), iProgramVarOrConst);
            arrayList.add(hcHeadVar3);
            if (object2 == this.mAssertionViolatedVar) {
                hcHeadVar2 = hcHeadVar3;
            } else {
                TermVariable termVariable = (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVarOrConst);
                if (termVariable != null) {
                    linkedHashMap.put(termVariable, hcHeadVar3.getTermVariable());
                }
            }
            ++n;
        }
        List<HcPredicateSymbol> list2 = Collections.singletonList(this.getOrConstructPredicateSymbolForIcfgLocation(iIcfgInternalTransition.getSource()));
        iProgramVarOrConst = new LinkedHashSet();
        hcHeadVar3 = new ArrayList();
        int n2 = 0;
        while (n2 < list.size()) {
            object = list.get(n2);
            HcBodyVar hcBodyVar = this.getPrettyBodyVar(list2.get(0), n2, object.getSort(), (IProgramVarOrConst)this.mTermVarToProgVar.get(object));
            iProgramVarOrConst.add(hcBodyVar);
            if (object == this.mAssertionViolatedVar) {
                hcHeadVar3.add(hcBodyVar.getTermVariable());
            } else {
                IProgramVarOrConst iProgramVarOrConst2 = (IProgramVarOrConst)this.mTermVarToProgVar.get(object);
                assert (iProgramVarOrConst2 != null);
                TermVariable termVariable = (TermVariable)unmodifiableTransFormula.getInVars().get(iProgramVarOrConst2);
                TermVariable termVariable2 = (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVarOrConst2);
                if (termVariable == null && termVariable2 == null) {
                    hcHeadVar3.add(((HcHeadVar)arrayList.get(n2)).getTermVariable());
                } else if (termVariable == null && termVariable2 != null) {
                    hcHeadVar3.add(hcBodyVar.getTermVariable());
                } else if (termVariable != null && termVariable2 == null) {
                    hcHeadVar3.add(hcBodyVar.getTermVariable());
                    linkedHashMap.put(termVariable, hcBodyVar.getTermVariable());
                } else if (termVariable == termVariable2) {
                    hcHeadVar3.add(((HcHeadVar)arrayList.get(n2)).getTermVariable());
                } else {
                    assert (linkedHashMap.containsKey(termVariable2)) : "subs should have been added during head processing";
                    hcHeadVar3.add(hcBodyVar.getTermVariable());
                    linkedHashMap.put(termVariable, hcBodyVar.getTermVariable());
                }
            }
            ++n2;
        }
        object2 = Collections.singletonList(hcHeadVar3);
        for (HcHeadVar hcHeadVar3 : unmodifiableTransFormula.getAuxVars()) {
            object = this.mHcSymbolTable.getOrConstructBodyAuxVar((TermVariable)hcHeadVar3, (Object)this);
            iProgramVarOrConst.add(object);
        }
        HcHeadVar hcHeadVar4 = hcHeadVar3 = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{PureSubstitution.apply((ManagedScript)this.mMgdScript, linkedHashMap, (Term)unmodifiableTransFormula.getFormula()), hcHeadVar2.getTermVariable()});
        assert (this.checkNoFreeVars(arrayList, (Set<HcVar>)iProgramVarOrConst, (Term)hcHeadVar4));
        this.updateLogicWrtConstraint((Term)hcHeadVar4);
        object = new ArrayList();
        object.add(new HornClause(this.mMgdScript, this.mHcSymbolTable, (Term)hcHeadVar4, hcPredicateSymbol, arrayList, list2, (List)object2, (Set)iProgramVarOrConst));
        return object;
    }

    private Collection<HornClause> computeChcForInternalEdge(IIcfgInternalTransition<IcfgLocation> iIcfgInternalTransition) {
        Object object;
        HcHeadVar hcHeadVar3;
        IProgramVarOrConst iProgramVarOrConst;
        Object object2;
        assert (!this.isErrorLocation(iIcfgInternalTransition.getTarget())) : "use other method for that";
        UnmodifiableTransFormula unmodifiableTransFormula = iIcfgInternalTransition.getTransformula();
        String string = iIcfgInternalTransition.getPrecedingProcedure();
        List<TermVariable> list = this.getTermVariableListForPredForProcedure(string);
        LinkedHashMap<TermVariable, TermVariable> linkedHashMap = new LinkedHashMap<TermVariable, TermVariable>();
        HcPredicateSymbol hcPredicateSymbol = this.getOrConstructPredicateSymbolForIcfgLocation(iIcfgInternalTransition.getTarget());
        ArrayList<HcHeadVar> arrayList = new ArrayList<HcHeadVar>();
        HcHeadVar hcHeadVar2 = null;
        int n = 0;
        while (n < list.size()) {
            object2 = list.get(n);
            iProgramVarOrConst = (IProgramVarOrConst)this.mTermVarToProgVar.get(object2);
            hcHeadVar3 = this.getPrettyHeadVar(hcPredicateSymbol, n, object2.getSort(), iProgramVarOrConst);
            arrayList.add(hcHeadVar3);
            if (object2.equals(this.mAssertionViolatedVar)) {
                hcHeadVar2 = hcHeadVar3;
            } else {
                TermVariable termVariable = (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVarOrConst);
                if (termVariable != null) {
                    linkedHashMap.put(termVariable, hcHeadVar3.getTermVariable());
                }
            }
            ++n;
        }
        List<HcPredicateSymbol> list2 = Collections.singletonList(this.getOrConstructPredicateSymbolForIcfgLocation(iIcfgInternalTransition.getSource()));
        iProgramVarOrConst = new LinkedHashSet();
        hcHeadVar3 = new ArrayList();
        int n2 = 0;
        while (n2 < list.size()) {
            object = list.get(n2);
            IProgramVarOrConst iProgramVarOrConst2 = (IProgramVarOrConst)this.mTermVarToProgVar.get(object);
            HcBodyVar hcBodyVar = this.getPrettyBodyVar(list2.get(0), n2, object.getSort(), iProgramVarOrConst2);
            iProgramVarOrConst.add(hcBodyVar);
            if (object.equals(this.mAssertionViolatedVar)) {
                hcHeadVar3.add(hcHeadVar2.getTermVariable());
            } else {
                TermVariable termVariable = (TermVariable)unmodifiableTransFormula.getInVars().get(iProgramVarOrConst2);
                TermVariable termVariable2 = (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVarOrConst2);
                if (termVariable == null && termVariable2 == null) {
                    hcHeadVar3.add(((HcHeadVar)arrayList.get(n2)).getTermVariable());
                } else if (termVariable == null && termVariable2 != null) {
                    hcHeadVar3.add(hcBodyVar.getTermVariable());
                } else if (termVariable != null && termVariable2 == null) {
                    hcHeadVar3.add(hcBodyVar.getTermVariable());
                    linkedHashMap.put(termVariable, hcBodyVar.getTermVariable());
                } else if (termVariable == termVariable2) {
                    hcHeadVar3.add(((HcHeadVar)arrayList.get(n2)).getTermVariable());
                } else {
                    assert (linkedHashMap.containsKey(termVariable2)) : "subs should have been added during head processing";
                    hcHeadVar3.add(hcBodyVar.getTermVariable());
                    linkedHashMap.put(termVariable, hcBodyVar.getTermVariable());
                }
            }
            ++n2;
        }
        object2 = Collections.singletonList(hcHeadVar3);
        for (HcHeadVar hcHeadVar3 : unmodifiableTransFormula.getAuxVars()) {
            object = this.mHcSymbolTable.getOrConstructBodyAuxVar((TermVariable)hcHeadVar3, (Object)this);
            iProgramVarOrConst.add(object);
        }
        Term term = PureSubstitution.apply((ManagedScript)this.mMgdScript, linkedHashMap, (Term)unmodifiableTransFormula.getFormula());
        hcHeadVar3 = SmtUtils.or((Script)this.mMgdScript.getScript(), (Term[])new Term[]{hcHeadVar2.getTermVariable(), term});
        assert (this.checkNoFreeVars(arrayList, (Set<HcVar>)iProgramVarOrConst, (Term)hcHeadVar3));
        term = hcHeadVar3;
        this.updateLogicWrtConstraint(term);
        object = new ArrayList(2);
        object.add(new HornClause(this.mMgdScript, this.mHcSymbolTable, term, hcPredicateSymbol, arrayList, list2, (List)object2, (Set)iProgramVarOrConst));
        return object;
    }

    private HcHeadVar getPrettyHeadVar(HcPredicateSymbol hcPredicateSymbol, int n, Sort sort, IProgramVarOrConst iProgramVarOrConst) {
        this.mMgdScript.unlock((Object)this);
        HcHeadVar hcHeadVar = this.mHcSymbolTable.getOrConstructHeadVar(hcPredicateSymbol, n, sort, (Object)iProgramVarOrConst);
        this.mMgdScript.lock((Object)this);
        String string = iProgramVarOrConst != null ? iProgramVarOrConst.toString() + "'" : "V'";
        hcHeadVar.setComment(string);
        return hcHeadVar;
    }

    private HcBodyVar getPrettyBodyVar(HcPredicateSymbol hcPredicateSymbol, int n, Sort sort, IProgramVarOrConst iProgramVarOrConst) {
        this.mMgdScript.unlock((Object)this);
        HcBodyVar hcBodyVar = this.mHcSymbolTable.getOrConstructBodyVar(hcPredicateSymbol, n, iProgramVarOrConst);
        this.mMgdScript.lock((Object)this);
        String string = iProgramVarOrConst != null ? iProgramVarOrConst.toString() : ASSERTIONVIOLATEDVARNAME;
        hcBodyVar.setComment(string);
        return hcBodyVar;
    }

    private boolean isErrorLocation(IcfgLocation icfgLocation) {
        Set set = (Set)this.mIcfg.getProcedureErrorNodes().get(icfgLocation.getProcedure());
        if (set == null) {
            return false;
        }
        return set.contains(icfgLocation);
    }

    private HcPredicateSymbol getOrConstructPredicateSymbolForIcfgLocation(IcfgLocation icfgLocation) {
        assert (this.mHcSymbolTable != null) : "hcSymboltable not yet set up; this method can only be used inside processIcfg";
        String string = this.computePredicateNameForIcfgLocation(icfgLocation);
        List<Sort> list = this.computeSortsForIcfgLocationPredicate(icfgLocation);
        return this.mHcSymbolTable.getOrConstructHornClausePredicateSymbol(string, list);
    }

    private List<Sort> computeSortsForIcfgLocationPredicate(IcfgLocation icfgLocation) {
        List<TermVariable> list = this.getTermVariableListForPredForProcedure(icfgLocation.getProcedure());
        return list.stream().map(termVariable -> termVariable.getSort()).collect(Collectors.toList());
    }

    private List<TermVariable> getTermVariableListForPredForProcedure(String string) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        for (IProgramVar iProgramVar : this.getProgramVariableListForProcedure(string)) {
            this.mTermVarToProgVar.put(iProgramVar.getTermVariable(), iProgramVar);
            arrayList.add(iProgramVar.getTermVariable());
        }
        arrayList.add(this.mAssertionViolatedVar);
        return Collections.unmodifiableList(arrayList);
    }

    private List<IProgramVar> getProgramVariableListForProcedure(String string) {
        List<IProgramVar> list = this.mProcToVarList.get(string);
        if (list == null) {
            Set set = this.mIcfg.getCfgSmtToolkit().getSymbolTable().getGlobals();
            Set set2 = this.mIcfg.getCfgSmtToolkit().getModifiableGlobalsTable().getModifiedBoogieVars(string);
            Set set3 = this.mIcfg.getCfgSmtToolkit().getSymbolTable().getLocals(string);
            list = new ArrayList<IProgramVar>();
            for (IProgramNonOldVar iProgramNonOldVar : set) {
                list.add((IProgramVar)iProgramNonOldVar);
                if (!set2.contains(iProgramNonOldVar)) continue;
                list.add((IProgramVar)iProgramNonOldVar.getOldVar());
            }
            list.addAll(set3);
            this.mProcToVarList.put(string, Collections.unmodifiableList(list));
        }
        return list;
    }

    private String computePredicateNameForIcfgLocation(IcfgLocation icfgLocation) {
        return icfgLocation.getProcedure() + "_" + icfgLocation.toString();
    }
}

