/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.alternating.AlternatingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.alternating.visualization.AlternatingAutomatonWriter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CaWriter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.CaDatastructureWriter;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.CountingAutomatonDataStructure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.INwaAtsFormatter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.NwaWriter;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.BranchingProcessWriterToString;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.IPetriAtsFormatter;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.NetWriter;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.visualization.TreeAutomatonWriter;
import de.uni_freiburg.informatik.ultimate.automata.tree.visualization.TreeAutomatonWriterUniqueId;
import java.io.PrintWriter;

public class AtsFormat
implements AutomatonDefinitionPrinter.IFormat {
    @Override
    public String getFileEnding() {
        return "ats";
    }

    @Override
    public void printHeader(PrintWriter printWriter, String string) {
        printWriter.println("// Testfile dumped by Ultimate at " + AtsFormat.getDateTimeNice());
        printWriter.println("//");
        printWriter.println("// " + string);
    }

    @Override
    public <L, S> void printNestedWordAutomaton(PrintWriter printWriter, String string, INestedWordAutomaton<L, S> iNestedWordAutomaton) {
        new NwaWriter<L, S>(printWriter, string, iNestedWordAutomaton, this.getNwaFormatter());
    }

    protected <L, S> INwaAtsFormatter<L, S> getNwaFormatter() {
        return new INwaAtsFormatter.ToString();
    }

    @Override
    public <L, S> void printCountingAutomaton(PrintWriter printWriter, String string, CountingAutomaton<L, S> countingAutomaton) {
        new CaWriter<L, S>(printWriter, string, countingAutomaton);
    }

    @Override
    public <L, S> void printTreeAutomaton(PrintWriter printWriter, String string, TreeAutomatonBU<? extends IRankedLetter, S> treeAutomatonBU) {
        new TreeAutomatonWriter<IRankedLetter, S>(printWriter, string, treeAutomatonBU);
    }

    @Override
    public <L, S> void printCountingAutomatonDataStructure(PrintWriter printWriter, String string, CountingAutomatonDataStructure<L, S> countingAutomatonDataStructure) {
        new CaDatastructureWriter<L, S>(printWriter, string, countingAutomatonDataStructure);
    }

    @Override
    public <L, S> void printPetriNet(PrintWriter printWriter, String string, BoundedPetriNet<L, S> boundedPetriNet) {
        new NetWriter<L, S>(printWriter, string, boundedPetriNet, this.getPetriFormatter());
    }

    protected <L, S> IPetriAtsFormatter<L, S> getPetriFormatter() {
        return new IPetriAtsFormatter.ToString();
    }

    @Override
    public <L, S> void printAlternatingAutomaton(PrintWriter printWriter, String string, AlternatingAutomaton<L, S> alternatingAutomaton) {
        new AlternatingAutomatonWriter<L, S>(printWriter, string, alternatingAutomaton);
    }

    @Override
    public <L, S> void printBranchingProcess(PrintWriter printWriter, String string, BranchingProcess<L, S> branchingProcess) {
        new BranchingProcessWriterToString<L, S>(printWriter, string, branchingProcess);
    }

    private static String getDateTimeNice() {
        return AutomatonDefinitionPrinter.getDateTimeFromFormat("yyyy/MM/dd HH:mm:ss");
    }

    static class AtsNumerateFormat
    extends AtsFormat {
        AtsNumerateFormat() {
        }

        @Override
        protected <L, S> INwaAtsFormatter<L, S> getNwaFormatter() {
            return new INwaAtsFormatter.UniqueId();
        }

        @Override
        public <L, S> void printCountingAutomaton(PrintWriter printWriter, String string, CountingAutomaton<L, S> countingAutomaton) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        @Override
        public <L, S> void printTreeAutomaton(PrintWriter printWriter, String string, TreeAutomatonBU<? extends IRankedLetter, S> treeAutomatonBU) {
            new TreeAutomatonWriterUniqueId<IRankedLetter, S>(printWriter, string, treeAutomatonBU);
        }

        @Override
        public <L, S> void printCountingAutomatonDataStructure(PrintWriter printWriter, String string, CountingAutomatonDataStructure<L, S> countingAutomatonDataStructure) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        @Override
        protected <L, S> IPetriAtsFormatter<L, S> getPetriFormatter() {
            return new IPetriAtsFormatter.UniqueId();
        }

        @Override
        public <L, S> void printAlternatingAutomaton(PrintWriter printWriter, String string, AlternatingAutomaton<L, S> alternatingAutomaton) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        @Override
        public <L, S> void printBranchingProcess(PrintWriter printWriter, String string, BranchingProcess<L, S> branchingProcess) {
            AutomatonDefinitionPrinter.failUnsupported();
        }
    }

    static class AtsQuotedFormat
    extends AtsFormat {
        AtsQuotedFormat() {
        }

        @Override
        protected <L, S> INwaAtsFormatter<L, S> getNwaFormatter() {
            return new INwaAtsFormatter.ToStringWithHash();
        }

        @Override
        public <L, S> void printCountingAutomaton(PrintWriter printWriter, String string, CountingAutomaton<L, S> countingAutomaton) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        @Override
        public <L, S> void printTreeAutomaton(PrintWriter printWriter, String string, TreeAutomatonBU<? extends IRankedLetter, S> treeAutomatonBU) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        @Override
        public <L, S> void printCountingAutomatonDataStructure(PrintWriter printWriter, String string, CountingAutomatonDataStructure<L, S> countingAutomatonDataStructure) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        @Override
        protected <L, S> IPetriAtsFormatter<L, S> getPetriFormatter() {
            return new IPetriAtsFormatter.ToStringWithUniqueNumber();
        }

        @Override
        public <L, S> void printAlternatingAutomaton(PrintWriter printWriter, String string, AlternatingAutomaton<L, S> alternatingAutomaton) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        @Override
        public <L, S> void printBranchingProcess(PrintWriter printWriter, String string, BranchingProcess<L, S> branchingProcess) {
            AutomatonDefinitionPrinter.failUnsupported();
        }
    }
}

