/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SetOfStates<STATE> {
    private static final String NOT_A_STATE = "Not a state: ";
    private final Set<STATE> mStates = new HashSet<STATE>();
    private final Set<STATE> mInitialStates = new HashSet<STATE>();
    private final Set<STATE> mAcceptingStates = new HashSet<STATE>();
    private final STATE mEmptyStackState;

    public SetOfStates(STATE STATE) {
        this.mEmptyStackState = STATE;
    }

    public void addState(boolean bl, boolean bl2, STATE STATE) {
        if (STATE == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        if (this.mStates.contains(STATE)) {
            throw new IllegalArgumentException("state already exists: " + String.valueOf(STATE));
        }
        this.mStates.add(STATE);
        if (bl) {
            this.mInitialStates.add(STATE);
        }
        if (bl2) {
            this.mAcceptingStates.add(STATE);
        }
    }

    public void removeState(STATE STATE) {
        boolean bl = this.mStates.remove(STATE);
        if (!bl) {
            throw new IllegalArgumentException(NOT_A_STATE + String.valueOf(STATE));
        }
        this.mInitialStates.remove(STATE);
        this.mAcceptingStates.remove(STATE);
    }

    @Deprecated
    public void makeStateNonInitial(STATE STATE) {
        if (!this.mStates.contains(STATE)) {
            throw new IllegalArgumentException(NOT_A_STATE + String.valueOf(STATE));
        }
        boolean bl = this.mInitialStates.remove(STATE);
        if (!bl) {
            throw new IllegalArgumentException("Can only make initial states non-initial");
        }
    }

    public Set<STATE> getStates() {
        return Collections.unmodifiableSet(this.mStates);
    }

    public Set<STATE> getInitialStates() {
        return Collections.unmodifiableSet(this.mInitialStates);
    }

    public Set<STATE> getAcceptingStates() {
        return Collections.unmodifiableSet(this.mAcceptingStates);
    }

    public STATE getEmptyStackState() {
        return this.mEmptyStackState;
    }

    public boolean isInitial(STATE STATE) {
        if (!this.mStates.contains(STATE)) {
            throw new IllegalArgumentException(NOT_A_STATE + String.valueOf(STATE));
        }
        return this.mInitialStates.contains(STATE);
    }

    public boolean isAccepting(STATE STATE) {
        if (!this.mStates.contains(STATE)) {
            throw new IllegalArgumentException(NOT_A_STATE + String.valueOf(STATE));
        }
        return this.mAcceptingStates.contains(STATE);
    }
}

