/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;

public class ProtectedIndependenceRelation<S, L>
implements IIndependenceRelation<S, L> {
    private final IIndependenceRelation<S, L> mUnderlying;
    private final IFilter<L> mFilter;
    private final Statistics mStatistics;

    public ProtectedIndependenceRelation(IIndependenceRelation<S, L> iIndependenceRelation, IFilter<L> iFilter) {
        this.mUnderlying = iIndependenceRelation;
        this.mFilter = iFilter;
        this.mStatistics = new Statistics();
    }

    @Override
    public boolean isSymmetric() {
        return this.mUnderlying.isSymmetric();
    }

    @Override
    public boolean isConditional() {
        return this.mUnderlying.isConditional();
    }

    @Override
    public IIndependenceRelation.Dependence isIndependent(S s, L l, L l2) {
        if (this.mFilter.test(l) && this.mFilter.test(l2)) {
            IIndependenceRelation.Dependence dependence = this.mUnderlying.isIndependent(s, l, l2);
            this.mFilter.update(l, l2, dependence);
            this.mStatistics.reportQuery(dependence, s != null);
            return dependence;
        }
        this.mStatistics.reportProtectedQuery(s != null);
        return IIndependenceRelation.Dependence.UNKNOWN;
    }

    @Override
    public ISymbolicIndependenceRelation<L, S> getSymbolicRelation() {
        ISymbolicIndependenceRelation<L, S> iSymbolicIndependenceRelation = this.mUnderlying.getSymbolicRelation();
        if (iSymbolicIndependenceRelation == null) {
            return null;
        }
        return new SymbolicProtectedIndependence(iSymbolicIndependenceRelation);
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    @FunctionalInterface
    public static interface IFilter<L> {
        public boolean test(L var1);

        default public void update(L l, L l2, IIndependenceRelation.Dependence dependence) {
        }
    }

    private final class Statistics
    extends IndependenceStatisticsDataProvider {
        public static final String PROTECTED_QUERIES = "Protected Queries";
        private int mProtectedQueries;

        private Statistics() {
            super(ProtectedIndependenceRelation.class, ProtectedIndependenceRelation.this.mUnderlying);
            this.declare(PROTECTED_QUERIES, () -> this.mProtectedQueries, KeyType.COUNTER);
        }

        private void reportProtectedQuery(boolean bl) {
            ++this.mProtectedQueries;
            this.reportQuery(IIndependenceRelation.Dependence.UNKNOWN, bl);
        }
    }

    private class SymbolicProtectedIndependence
    implements ISymbolicIndependenceRelation<L, S> {
        private final ISymbolicIndependenceRelation<L, S> mUnderlyingSymbolic;

        public SymbolicProtectedIndependence(ISymbolicIndependenceRelation<L, S> iSymbolicIndependenceRelation) {
            this.mUnderlyingSymbolic = iSymbolicIndependenceRelation;
        }

        @Override
        public S getCommutativityCondition(S s, L l, L l2) {
            if (ProtectedIndependenceRelation.this.mFilter.test(l) && ProtectedIndependenceRelation.this.mFilter.test(l2)) {
                return this.mUnderlyingSymbolic.getCommutativityCondition(s, l, l2);
            }
            return null;
        }

        @Override
        public boolean isSymmetric() {
            return this.mUnderlyingSymbolic.isSymmetric();
        }

        @Override
        public boolean isConditional() {
            return this.mUnderlyingSymbolic.isConditional();
        }
    }
}

