/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EdgeInfo {
    IcfgEdge mEdge;

    public EdgeInfo(IcfgEdge icfgEdge) {
        this.mEdge = icfgEdge;
    }

    public IProgramVarOrConst getProgramVarOrConstForTerm(Term term) {
        return TransFormulaUtils.getProgramVarOrConstForTerm((TransFormula)this.mEdge.getTransformula(), (Term)term);
    }

    public IcfgLocation getSourceLocation() {
        return (IcfgLocation)this.mEdge.getSource();
    }

    public IcfgEdge getEdge() {
        return this.mEdge;
    }

    public String toString() {
        return "(" + String.valueOf(this.mEdge) + ")";
    }

    public int hashCode() {
        return Objects.hash(this.mEdge);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EdgeInfo edgeInfo = (EdgeInfo)object;
        return !(this.mEdge == null ? edgeInfo.mEdge != null : !this.mEdge.equals(edgeInfo.mEdge));
    }

    public IProgramVar getInVar(Term term) {
        if (!(term instanceof TermVariable)) {
            return null;
        }
        for (Map.Entry entry : this.mEdge.getTransformula().getInVars().entrySet()) {
            if (!((TermVariable)entry.getValue()).equals(term)) continue;
            return (IProgramVar)entry.getKey();
        }
        return null;
    }

    public IProgramVar getOutVar(Term term) {
        if (!(term instanceof TermVariable)) {
            return null;
        }
        for (Map.Entry entry : this.mEdge.getTransformula().getOutVars().entrySet()) {
            if (!((TermVariable)entry.getValue()).equals(term)) continue;
            return (IProgramVar)entry.getKey();
        }
        return null;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mEdge.getTransformula().getInVars();
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mEdge.getTransformula().getOutVars();
    }

    public Set<TermVariable> getAuxVars() {
        return this.mEdge.getTransformula().getAuxVars();
    }

    public Set<IProgramConst> getNonTheoryConsts() {
        return this.mEdge.getTransformula().getNonTheoryConsts();
    }
}

