/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiFunction;

public final class Interval
implements INonrelationalValue<Interval> {
    public static final Interval TOP = new Interval(Rational.NEGATIVE_INFINITY, Rational.POSITIVE_INFINITY);
    public static final Interval BOTTOM = new Interval(Rational.ONE, Rational.ZERO);
    public static final Interval ZERO = new Interval(Rational.ZERO);
    public static final Interval ONE = new Interval(Rational.ONE);
    private final Rational mLower;
    private final Rational mUpper;

    private Interval(Rational rational) {
        this(rational, rational);
    }

    private Interval(Rational rational, Rational rational2) {
        this.mLower = rational;
        this.mUpper = rational2;
    }

    public static Interval point(Rational rational) {
        return Interval.of(rational, rational);
    }

    public static Interval of(Rational rational, Rational rational2) {
        if (Interval.isNan(rational) || Interval.isNan(rational2) || rational.compareTo(rational2) > 0) {
            return BOTTOM;
        }
        if (Interval.isNegInf(rational) && Interval.isPosInf(rational2)) {
            return TOP;
        }
        return new Interval(rational, rational2);
    }

    public boolean hasLower() {
        return this.mLower.isRational();
    }

    public boolean hasUpper() {
        return this.mUpper.isRational();
    }

    public Rational getLower() {
        return this.mLower;
    }

    public Rational getUpper() {
        return this.mUpper;
    }

    @Override
    public boolean isBottom() {
        assert (this == BOTTOM == this.mLower.compareTo(this.mUpper) > 0) : "Empty interval was not unified";
        return this == BOTTOM;
    }

    public boolean isPoint() {
        return this.mLower.equals((Object)this.mUpper);
    }

    public boolean containsZero() {
        return this.mLower.signum() <= 0 && this.mUpper.signum() >= 0;
    }

    @Override
    public boolean isTop() {
        assert (this == TOP == (Interval.isNegInf(this.mLower) && Interval.isPosInf(this.mUpper))) : "Top interval was not unified";
        return this == TOP;
    }

    public Interval negate() {
        return Interval.of(this.mUpper.negate(), this.mLower.negate());
    }

    public Interval add(Interval interval) {
        return Interval.of(this.mLower.add(interval.mLower), this.mUpper.add(interval.mUpper));
    }

    public Interval subtract(Interval interval) {
        return Interval.of(this.mLower.sub(interval.mUpper), this.mUpper.sub(interval.mLower));
    }

    public Interval multiply(Interval interval) {
        return this.minMaxFromCartesianOp(interval, Rational::mul);
    }

    public Interval divide(Interval interval) {
        if (interval.containsZero()) {
            return TOP;
        }
        return this.minMaxFromCartesianOp(interval, Rational::div);
    }

    private Interval minMaxFromCartesianOp(Interval interval, BiFunction<Rational, Rational, Rational> biFunction) {
        Rational rational = biFunction.apply(this.mLower, interval.mLower);
        Rational rational2 = biFunction.apply(this.mLower, interval.mUpper);
        Rational rational3 = biFunction.apply(this.mUpper, interval.mLower);
        Rational rational4 = biFunction.apply(this.mUpper, interval.mUpper);
        return Interval.of(Interval.min(Interval.min(rational, rational2), Interval.min(rational3, rational4)), Interval.max(Interval.max(rational, rational2), Interval.max(rational3, rational4)));
    }

    public SatisfyingInputs satisfyEqual(Interval interval) {
        return new SatisfyingInputs(this.intersect(interval));
    }

    public SatisfyingInputs satisfyDistinct(Interval interval) {
        if (this.isPoint() && interval.isPoint() && this.mLower.equals((Object)interval.mLower)) {
            return new SatisfyingInputs(BOTTOM);
        }
        return new SatisfyingInputs(this, interval);
    }

    public SatisfyingInputs satisfyLessOrEqual(Interval interval) {
        return new SatisfyingInputs(Interval.of(this.mLower, Interval.min(this.mUpper, interval.mUpper)), Interval.of(Interval.max(interval.mLower, this.mLower), interval.mUpper));
    }

    public SatisfyingInputs satisfyGreaterOrEqual(Interval interval) {
        return interval.satisfyLessOrEqual(this).swap();
    }

    @Override
    public Interval join(Interval interval) {
        return Interval.of(Interval.min(this.mLower, interval.mLower), Interval.max(this.mUpper, interval.mUpper));
    }

    @Override
    public Interval widen(Interval interval) {
        return Interval.of(interval.mLower.compareTo(this.mLower) < 0 ? Rational.NEGATIVE_INFINITY : this.mLower, this.mUpper.compareTo(interval.mUpper) < 0 ? Rational.POSITIVE_INFINITY : this.mUpper);
    }

    public Interval intersect(Interval interval) {
        return Interval.of(Interval.max(this.mLower, interval.mLower), Interval.min(this.mUpper, interval.mUpper));
    }

    public Interval complement() {
        boolean bl = Interval.isNegInf(this.mLower);
        boolean bl2 = Interval.isPosInf(this.mUpper);
        if (bl && !bl2) {
            return Interval.of(this.mUpper, Rational.POSITIVE_INFINITY);
        }
        if (!bl && bl2) {
            return Interval.of(Rational.NEGATIVE_INFINITY, this.mLower);
        }
        if (this.isBottom()) {
            return TOP;
        }
        return BOTTOM;
    }

    public int hashCode() {
        return Objects.hash(this.mLower, this.mUpper);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Interval interval = (Interval)object;
        return Objects.equals(this.mLower, interval.mLower) && Objects.equals(this.mUpper, interval.mUpper);
    }

    public String toString() {
        if (this.isBottom()) {
            return "\u2205";
        }
        return String.format("[%s, %s]", this.mLower, this.mUpper);
    }

    @Override
    public Term toTerm(Term term, Script script) {
        Term term2;
        if (this.isPoint()) {
            Term term3 = SmtUtils.rational2Term((Script)script, (Rational)this.mLower, (Sort)term.getSort());
            return SmtUtils.binaryEquality((Script)script, (Term)term, (Term)term3);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>(2);
        if (this.hasLower()) {
            term2 = SmtUtils.rational2Term((Script)script, (Rational)this.mLower, (Sort)term.getSort());
            arrayList.add(SmtUtils.geq((Script)script, (Term)term, (Term)term2));
        }
        if (this.hasUpper()) {
            term2 = SmtUtils.rational2Term((Script)script, (Rational)this.mUpper, (Sort)term.getSort());
            arrayList.add(SmtUtils.leq((Script)script, (Term)term, (Term)term2));
        }
        return SmtUtils.and((Script)script, arrayList);
    }

    private static boolean isNan(Rational rational) {
        boolean bl;
        boolean bl2 = bl = rational == Rational.NAN;
        assert (bl == (!rational.isRational() && rational.signum() == 0));
        return bl;
    }

    private static boolean isPosInf(Rational rational) {
        boolean bl;
        boolean bl2 = bl = rational == Rational.POSITIVE_INFINITY;
        assert (bl == (!rational.isRational() && rational.signum() > 0));
        return bl;
    }

    private static boolean isNegInf(Rational rational) {
        boolean bl;
        boolean bl2 = bl = rational == Rational.NEGATIVE_INFINITY;
        assert (bl == (!rational.isRational() && rational.signum() < 0));
        return bl;
    }

    private static Rational max(Rational rational, Rational rational2) {
        if (Interval.isNan(rational) || Interval.isNan(rational2)) {
            return Rational.NAN;
        }
        return rational.compareTo(rational2) > 0 ? rational : rational2;
    }

    private static Rational min(Rational rational, Rational rational2) {
        if (Interval.isNan(rational) || Interval.isNan(rational2)) {
            return Rational.NAN;
        }
        return rational.compareTo(rational2) < 0 ? rational : rational2;
    }

    public static class SatisfyingInputs {
        private final Interval mLhs;
        private final Interval mRhs;

        public SatisfyingInputs(Interval interval) {
            this(interval, interval);
        }

        public SatisfyingInputs(Interval interval, Interval interval2) {
            this.mLhs = interval;
            this.mRhs = interval2;
        }

        protected SatisfyingInputs swap() {
            return new SatisfyingInputs(this.mRhs, this.mLhs);
        }

        public Interval getLhs() {
            return this.mLhs;
        }

        public Interval getRhs() {
            return this.mRhs;
        }

        public int hashCode() {
            return Objects.hash(this.mLhs, this.mRhs);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SatisfyingInputs satisfyingInputs = (SatisfyingInputs)object;
            return Objects.equals(this.mLhs, satisfyingInputs.mLhs) && Objects.equals(this.mRhs, satisfyingInputs.mRhs);
        }

        public String toString() {
            return String.format("%s R %s", this.mLhs, this.mRhs);
        }
    }
}

