/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.core.CCorePreferenceConstants;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.IParserSettings2;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IProject;

public class ParserSettings2
extends IParserSettings2.Default {
    private final boolean limitTokensPerTU;
    private final int maxTokensPerTU;

    public ParserSettings2() {
        this((ICProject)null);
    }

    public ParserSettings2(IProject project) {
        this(CModelManager.getDefault().create(project));
    }

    public ParserSettings2(ICProject cProject) {
        this.limitTokensPerTU = CCorePreferenceConstants.getPreference("scalability.limitTokensPerTU", cProject, false);
        this.maxTokensPerTU = CCorePreferenceConstants.getPreference("scalability.maximumTokens", cProject, 25000000);
    }

    @Override
    public boolean shouldLimitTokensPerTranslationUnit() {
        return this.limitTokensPerTU;
    }

    @Override
    public int getMaximumTokensPerTranslationUnit() {
        return this.maxTokensPerTU;
    }
}

