/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;

public class BoogieAstCopier
extends BoogieTransformer {
    public Unit copy(Unit unit) {
        Declaration[] declarationArray = unit.getDeclarations();
        Declaration[] declarationArray2 = new Declaration[declarationArray.length];
        int n = 0;
        while (n < declarationArray.length) {
            declarationArray2[n] = this.processDeclaration(declarationArray[n]);
            ModelUtils.copyAnnotations((IElement)declarationArray[n], (IElement)declarationArray2[n]);
            ++n;
        }
        Unit unit2 = new Unit(unit.getLocation(), declarationArray2);
        ModelUtils.copyAnnotations((IElement)unit, (IElement)unit2);
        return unit2;
    }

    @Override
    protected Expression processExpression(Expression expression) {
        Expression expression2;
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            IdentifierExpression identifierExpression2 = new IdentifierExpression(identifierExpression.getLocation(), identifierExpression.getIdentifier());
            DeclarationInformation declarationInformation = identifierExpression.getDeclarationInformation();
            if (declarationInformation != null) {
                identifierExpression2.setDeclarationInformation(declarationInformation);
            }
            expression2 = identifierExpression2;
        } else if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            expression2 = new BooleanLiteral(booleanLiteral.getLocation(), booleanLiteral.getType(), booleanLiteral.getValue());
        } else if (expression instanceof IntegerLiteral) {
            IntegerLiteral integerLiteral = (IntegerLiteral)expression;
            expression2 = new IntegerLiteral(integerLiteral.getLocation(), integerLiteral.getType(), integerLiteral.getValue());
        } else if (expression instanceof BitvecLiteral) {
            BitvecLiteral bitvecLiteral = (BitvecLiteral)expression;
            expression2 = new BitvecLiteral(bitvecLiteral.getLocation(), bitvecLiteral.getType(), bitvecLiteral.getValue(), bitvecLiteral.getLength());
        } else if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            expression2 = new StringLiteral(stringLiteral.getLocation(), stringLiteral.getType(), stringLiteral.getValue());
        } else {
            expression2 = expression instanceof WildcardExpression ? new WildcardExpression(expression.getLocation(), expression.getType()) : super.processExpression(expression);
        }
        ModelUtils.copyAnnotations((IElement)expression, (IElement)expression2);
        return expression2;
    }
}

