/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import java.util.Objects;

public class DeclarationInformation {
    public static final DeclarationInformation DECLARATIONINFO_GLOBAL = new DeclarationInformation(StorageClass.GLOBAL, null);
    private final StorageClass mStorageClass;
    private final String mProcedure;

    public DeclarationInformation(StorageClass storageClass, String string) {
        assert (this.isValid(storageClass, string));
        this.mStorageClass = storageClass;
        this.mProcedure = string;
    }

    public StorageClass getStorageClass() {
        return this.mStorageClass;
    }

    public String getProcedure() {
        return this.mProcedure;
    }

    private boolean isValid(StorageClass storageClass, String string) {
        return switch (storageClass) {
            case StorageClass.GLOBAL, StorageClass.QUANTIFIED, StorageClass.IMPLEMENTATION, StorageClass.PROC_FUNC -> {
                if (string == null) {
                    yield true;
                }
                yield false;
            }
            case StorageClass.PROC_FUNC_INPARAM, StorageClass.PROC_FUNC_OUTPARAM, StorageClass.IMPLEMENTATION_INPARAM, StorageClass.IMPLEMENTATION_OUTPARAM, StorageClass.LOCAL -> {
                if (string != null) {
                    yield true;
                }
                yield false;
            }
            default -> throw new MatchException(null, null);
        };
    }

    public String toString() {
        if (this.mProcedure == null) {
            return this.mStorageClass.toString();
        }
        return "<" + this.mStorageClass.toString() + "," + this.mProcedure + ">";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mProcedure, this.mStorageClass});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DeclarationInformation declarationInformation = (DeclarationInformation)object;
        if (this.mProcedure == null ? declarationInformation.mProcedure != null : !this.mProcedure.equals(declarationInformation.mProcedure)) {
            return false;
        }
        return this.mStorageClass == declarationInformation.mStorageClass;
    }

    public static enum StorageClass {
        GLOBAL,
        PROC_FUNC_INPARAM,
        PROC_FUNC_OUTPARAM,
        IMPLEMENTATION_INPARAM,
        IMPLEMENTATION_OUTPARAM,
        LOCAL,
        QUANTIFIED,
        IMPLEMENTATION,
        PROC_FUNC;

    }
}

