/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Dnf;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.ScriptWithTermConstructionChecks;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.ConstraintSynthesisUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractLinearInvariantPattern;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.IInvariantPatternProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.IInvariantPatternProcessorFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.ILinearInequalityInvariantPatternStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.KindOfInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearInequalityInvariantPatternProcessor;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinearInequalityInvariantPatternProcessorFactory
implements IInvariantPatternProcessorFactory<Dnf<AbstractLinearInvariantPattern>> {
    protected final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    protected final IPredicateUnifier predUnifier;
    protected final CfgSmtToolkit mCsToolkit;
    protected final ILinearInequalityInvariantPatternStrategy<Dnf<AbstractLinearInvariantPattern>> mStrategy;
    private final boolean mUseNonlinearConstraints;
    private final boolean mUseUnsatCores;
    private final boolean mSynthesizeEntryPattern;
    private final KindOfInvariant mKindOfInvariant;
    private final SolverBuilder.SolverSettings mSolverSettings;
    private final SmtFunctionsAndAxioms mSmtSymbols;
    private final Map<IcfgLocation, IPredicate> mLoc2underApprox;
    private final Map<IcfgLocation, IPredicate> mLoc2overApprox;

    public LinearInequalityInvariantPatternProcessorFactory(IUltimateServiceProvider iUltimateServiceProvider, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, ILinearInequalityInvariantPatternStrategy<Dnf<AbstractLinearInvariantPattern>> iLinearInequalityInvariantPatternStrategy, boolean bl, boolean bl2, SolverBuilder.SolverSettings solverSettings, SmtUtils.SimplificationTechnique simplificationTechnique, SmtFunctionsAndAxioms smtFunctionsAndAxioms, Map<IcfgLocation, IPredicate> map, Map<IcfgLocation, IPredicate> map2, boolean bl3, KindOfInvariant kindOfInvariant) {
        this.mServices = iUltimateServiceProvider;
        this.mSimplificationTechnique = simplificationTechnique;
        this.predUnifier = iPredicateUnifier;
        this.mCsToolkit = cfgSmtToolkit;
        this.mSmtSymbols = smtFunctionsAndAxioms;
        this.mStrategy = iLinearInequalityInvariantPatternStrategy;
        this.mUseNonlinearConstraints = bl;
        this.mUseUnsatCores = bl2;
        this.mSynthesizeEntryPattern = bl3;
        this.mKindOfInvariant = kindOfInvariant;
        this.mSolverSettings = solverSettings;
        this.mLoc2underApprox = map;
        this.mLoc2overApprox = map2;
    }

    protected Script produceSmtSolver() {
        boolean bl = true;
        ConstraintSynthesisUtils.Linearity linearity = this.mUseNonlinearConstraints ? ConstraintSynthesisUtils.Linearity.NONLINEAR : ConstraintSynthesisUtils.Linearity.LINEAR;
        Logics logics = ConstraintSynthesisUtils.getLogic(linearity, bl);
        SolverBuilder.SolverSettings solverSettings = this.mSolverSettings.setSolverMode(SolverBuilder.SolverMode.External_DefaultMode).setSolverLogics(logics);
        Script script = SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)solverSettings, (String)"InvariantSynthesis");
        script = new ScriptWithTermConstructionChecks(script);
        return script;
    }

    @Override
    public IInvariantPatternProcessor<Dnf<AbstractLinearInvariantPattern>> produce(List<IcfgLocation> list, List<IcfgInternalTransition> list2, IPredicate iPredicate, IPredicate iPredicate2, IcfgLocation icfgLocation, Set<IcfgLocation> set) {
        return new LinearInequalityInvariantPatternProcessor(this.mServices, this.predUnifier, this.mCsToolkit, this.mSmtSymbols, this.produceSmtSolver(), list, list2, iPredicate, iPredicate2, icfgLocation, set, this.mStrategy, this.mUseNonlinearConstraints, this.mUseUnsatCores, this.mSimplificationTechnique, this.mLoc2underApprox, this.mLoc2overApprox, this.mSynthesizeEntryPattern, this.mKindOfInvariant);
    }
}

