/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.req.printer;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.core.lib.models.ObjectContainer;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PatternContainer;
import de.uni_freiburg.informatik.ultimate.req.printer.Activator;
import de.uni_freiburg.informatik.ultimate.req.printer.ReqPrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ReqPrinterObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;

    public ReqPrinterObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof Unit) {
            PatternContainer patternContainer = PatternContainer.getAnnotation((IElement)iElement);
            if (patternContainer == null) {
                this.mLogger.warn((Object)"No requirements found");
                return false;
            }
            ArrayList<PatternType> arrayList = new ArrayList<PatternType>(patternContainer.getPatterns());
            this.printPatternList(iElement, arrayList);
            return false;
        }
        if (iElement instanceof ObjectContainer) {
            if (((ObjectContainer)iElement).getValue() instanceof List) {
                List list = (List)((ObjectContainer)iElement).getValue();
                this.printPatternList(iElement, list);
            }
            return false;
        }
        return true;
    }

    private void printPatternList(IElement iElement, List<PatternType> list) {
        PrintWriter printWriter = this.openTempFile(iElement);
        list.sort((patternType, patternType2) -> {
            if (patternType instanceof DeclarationPattern) {
                if (!(patternType2 instanceof DeclarationPattern)) return -1;
                DeclarationPattern.VariableCategory variableCategory = ((DeclarationPattern)patternType).getCategory();
                DeclarationPattern.VariableCategory variableCategory2 = ((DeclarationPattern)patternType2).getCategory();
                if (variableCategory == DeclarationPattern.VariableCategory.CONST && variableCategory2 != DeclarationPattern.VariableCategory.CONST) {
                    return -1;
                }
                if (variableCategory2 != DeclarationPattern.VariableCategory.CONST || variableCategory == DeclarationPattern.VariableCategory.CONST) return patternType.getId().compareToIgnoreCase(patternType2.getId());
                return 1;
            }
            if (!(patternType2 instanceof DeclarationPattern)) return patternType.getId().compareToIgnoreCase(patternType2.getId());
            return 1;
        });
        for (PatternType patternType3 : list) {
            printWriter.println(patternType3.toString());
        }
        printWriter.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrintWriter openTempFile(IElement iElement) {
        String string = this.getPath(iElement);
        try {
            File file;
            if (this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Use automatic naming")) {
                file = File.createTempFile(ReqPrinter.class.getSimpleName() + "_" + new File(ILocation.getAnnotation((IElement)iElement).getFileName()).getName() + "_UID", ".req", new File(string));
            } else {
                String string2 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Output file name");
                file = new File(string + File.separatorChar + string2);
                if (!(file.isFile() && file.canWrite() || !file.exists())) {
                    this.mLogger.warn((Object)("Cannot write to: " + file.getAbsolutePath()));
                    return null;
                }
                if (file.exists()) {
                    this.mLogger.info((Object)("File already exists and will be overwritten: " + file.getAbsolutePath()));
                }
                file.createNewFile();
            }
            this.mLogger.info((Object)("Writing to file " + file.getAbsolutePath()));
            return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))), false);
        }
        catch (IOException iOException) {
            this.mLogger.fatal((Object)"Cannot open file", (Throwable)iOException);
            return null;
        }
    }

    private String getPath(IElement iElement) {
        if (this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Save file in source directory")) {
            ILocation iLocation = ILocation.getAnnotation((IElement)iElement);
            File file = new File(iLocation.getFileName());
            String string = file.isDirectory() ? file.getPath() : file.getParent();
            if (string != null) {
                return string;
            }
            this.mLogger.warn((Object)"Model does not provide a valid source location, falling back to default dump path...");
        }
        return this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Output directory");
    }

    public void finish() {
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public boolean performedChanges() {
        return false;
    }
}

