/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.LinkedScopedHashMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;

public class FunctionPointerVisitor
extends ASTVisitor {
    private final Map<String, IASTNode> mFunctionTable;
    private final LinkedScopedHashMap<String, IASTNode> mTemporarySymbolTable;
    private final FlatSymbolTable mSymTab;
    private final LinkedHashSet<String> mFunctions;

    public FunctionPointerVisitor(FlatSymbolTable flatSymbolTable, Map<String, IASTNode> map) {
        this.shouldVisitDeclarations = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclSpecifiers = true;
        this.mSymTab = flatSymbolTable;
        this.mTemporarySymbolTable = new LinkedScopedHashMap();
        this.mFunctionTable = map;
        this.mFunctions = new LinkedHashSet();
    }

    public Set<String> getResult() {
        return Collections.unmodifiableSet(this.mFunctions);
    }

    public int visit(IASTDeclSpecifier iASTDeclSpecifier) {
        if (iASTDeclSpecifier instanceof IASTCompositeTypeSpecifier) {
            this.mTemporarySymbolTable.beginScope();
        }
        return super.visit(iASTDeclSpecifier);
    }

    public int leave(IASTDeclSpecifier iASTDeclSpecifier) {
        if (iASTDeclSpecifier instanceof IASTCompositeTypeSpecifier) {
            this.mTemporarySymbolTable.endScope();
        }
        return super.leave(iASTDeclSpecifier);
    }

    public int visit(IASTParameterDeclaration iASTParameterDeclaration) {
        String string = iASTParameterDeclaration.getDeclarator().getName().toString();
        if (string.isEmpty() && iASTParameterDeclaration.getDeclarator() instanceof IASTFunctionDeclarator) {
            string = iASTParameterDeclaration.getDeclarator().getNestedDeclarator().getName().toString();
        }
        this.mTemporarySymbolTable.put((Object)string, (Object)iASTParameterDeclaration);
        return super.visit(iASTParameterDeclaration);
    }

    public int visit(IASTExpression iASTExpression) {
        if (iASTExpression instanceof IASTUnaryExpression) {
            String string;
            IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)iASTExpression;
            if (iASTUnaryExpression.getOperator() == 5 && (string = this.extractExpressionId((IASTNode)iASTUnaryExpression.getOperand())) != null) {
                this.addFunction(string, iASTExpression.getContainingFilename());
            }
        } else if (!(!(iASTExpression instanceof IASTIdExpression) || iASTExpression.getParent() instanceof IASTFunctionCallExpression && ((IASTFunctionCallExpression)iASTExpression.getParent()).getFunctionNameExpression().equals(iASTExpression))) {
            String string = ((IASTIdExpression)iASTExpression).getName().toString();
            this.addFunction(string, iASTExpression.getContainingFilename());
        }
        return super.visit(iASTExpression);
    }

    public int visit(IASTDeclaration iASTDeclaration) {
        if (iASTDeclaration instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclaration;
            IASTDeclarator[] iASTDeclaratorArray = iASTSimpleDeclaration.getDeclarators();
            int n = iASTDeclaratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator iASTDeclarator;
                IASTDeclarator iASTDeclarator2 = iASTDeclarator = iASTDeclaratorArray[n2];
                while (iASTDeclarator2 != null) {
                    this.addNameOfNonFunctionDeclarator(iASTDeclarator2);
                    iASTDeclarator2 = iASTDeclarator2.getNestedDeclarator();
                }
                ++n2;
            }
        } else if (iASTDeclaration instanceof IASTFunctionDefinition) {
            this.mTemporarySymbolTable.beginScope();
        }
        return super.visit(iASTDeclaration);
    }

    public int leave(IASTDeclaration iASTDeclaration) {
        if (iASTDeclaration instanceof IASTFunctionDefinition) {
            this.mTemporarySymbolTable.endScope();
        }
        return super.visit(iASTDeclaration);
    }

    public int visit(IASTStatement iASTStatement) {
        if (iASTStatement instanceof IASTCompoundStatement && !(iASTStatement.getParent() instanceof IASTFunctionDefinition) && !(iASTStatement.getParent() instanceof IASTForStatement)) {
            this.mTemporarySymbolTable.beginScope();
        }
        if (iASTStatement instanceof IASTSwitchStatement) {
            this.mTemporarySymbolTable.beginScope();
        }
        if (iASTStatement instanceof IASTForStatement) {
            this.mTemporarySymbolTable.beginScope();
        }
        return super.visit(iASTStatement);
    }

    public int leave(IASTStatement iASTStatement) {
        if (iASTStatement instanceof IASTCompoundStatement && !(iASTStatement.getParent() instanceof IASTFunctionDefinition) && !(iASTStatement.getParent() instanceof IASTForStatement)) {
            this.mTemporarySymbolTable.endScope();
        }
        if (iASTStatement instanceof IASTSwitchStatement) {
            this.mTemporarySymbolTable.endScope();
        }
        if (iASTStatement instanceof IASTForStatement) {
            this.mTemporarySymbolTable.endScope();
        }
        return super.leave(iASTStatement);
    }

    private String extractExpressionId(IASTNode iASTNode) {
        IASTUnaryExpression iASTUnaryExpression;
        if (iASTNode instanceof IASTIdExpression) {
            String string = ((IASTIdExpression)iASTNode).getName().toString();
            return this.mSymTab.applyMultiparseRenaming(iASTNode.getContainingFilename(), string);
        }
        if (iASTNode instanceof IASTFieldReference && !((IASTFieldReference)iASTNode).isPointerDereference()) {
            return this.extractExpressionId((IASTNode)((IASTFieldReference)iASTNode).getFieldOwner());
        }
        if (iASTNode instanceof IASTArraySubscriptExpression) {
            return this.extractExpressionId((IASTNode)((IASTArraySubscriptExpression)iASTNode).getArrayExpression());
        }
        if (iASTNode instanceof IASTUnaryExpression && (iASTUnaryExpression = (IASTUnaryExpression)iASTNode).getOperator() == 11) {
            return this.extractExpressionId((IASTNode)iASTUnaryExpression.getOperand());
        }
        return null;
    }

    private void addNameOfNonFunctionDeclarator(IASTDeclarator iASTDeclarator) {
        if (!(iASTDeclarator instanceof IASTFunctionDeclarator)) {
            String string = iASTDeclarator.getName().toString();
            String string2 = this.mSymTab.applyMultiparseRenaming(iASTDeclarator.getContainingFilename(), string);
            this.mTemporarySymbolTable.put((Object)string2, (Object)iASTDeclarator);
        }
    }

    private void addFunction(String string, String string2) {
        String string3 = this.mSymTab.applyMultiparseRenaming(string2, string);
        IASTNode iASTNode = this.mFunctionTable.get(string3);
        if (iASTNode != null) {
            this.mFunctions.add(string3);
        }
    }
}

