/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness;

import de.uni_freiburg.informatik.ultimate.acsl.parser.ACSLSyntaxErrorException;
import de.uni_freiburg.informatik.ultimate.acsl.parser.Parser;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class ExtractedFunctionContract {
    private final String mRequires;
    private final String mEnsures;
    private final IASTNode mMatchedNode;

    public ExtractedFunctionContract(String string, String string2, IASTNode iASTNode) {
        this.mRequires = string;
        this.mEnsures = string2;
        this.mMatchedNode = iASTNode;
    }

    private int getStartLine() {
        return this.mMatchedNode.getFileLocation().getStartingLineNumber();
    }

    public String toString() {
        return "Function contract at [L" + this.getStartLine() + "]: requires " + this.mRequires + ", ensures " + this.mEnsures;
    }

    private ACSLNode parseString(ILocation iLocation, String string) {
        try {
            return Parser.parseComment((String)("gstart\n " + string + ";"), (int)this.getStartLine(), (int)1);
        }
        catch (ACSLSyntaxErrorException aCSLSyntaxErrorException) {
            throw new UnsupportedSyntaxException(iLocation, String.format("Cannot parse contract \"%s\" at %s (%s)", string, iLocation, aCSLSyntaxErrorException.getMessageText()));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public List<ACSLNode> getAcslContractClauses() {
        ArrayList<ACSLNode> arrayList = new ArrayList<ACSLNode>();
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation(this.mMatchedNode);
        if (this.mRequires != null) {
            arrayList.add(this.parseString(cACSLLocation, "requires " + this.mRequires));
        }
        if (this.mEnsures != null) {
            arrayList.add(this.parseString(cACSLLocation, "ensures " + this.mEnsures));
        }
        return arrayList;
    }
}

