/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.decorator;

import de.uni_freiburg.informatik.ultimate.cdt.decorator.DecoratedUnit;
import de.uni_freiburg.informatik.ultimate.cdt.decorator.DecoratorNode;
import de.uni_freiburg.informatik.ultimate.cdt.parser.MultiparseSymbolTable;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class ASTDecorator {
    private final List<DecoratedUnit> mDecoratedUnits = new ArrayList<DecoratedUnit>();
    private MultiparseSymbolTable mSymbolTable;
    private List<ACSLNode> mAcslASTs;
    private int mCurrentStartLineNr;

    public DecoratorNode mapASTs(IASTNode iASTNode) {
        if (!(iASTNode instanceof IASTTranslationUnit)) {
            throw new IllegalArgumentException("First node of C-AST must be TU!");
        }
        this.mCurrentStartLineNr = 1;
        DecoratorNode decoratorNode = this.mapASTs(iASTNode, null).get(0);
        assert (this.mAcslASTs.isEmpty());
        return decoratorNode;
    }

    private List<DecoratorNode> mapASTs(IASTNode iASTNode, DecoratorNode decoratorNode) {
        if (iASTNode.getFileLocation() == null) {
            return null;
        }
        ArrayList<DecoratorNode> arrayList = new ArrayList<DecoratorNode>();
        if (decoratorNode != null && this.containsAcsl(this.mCurrentStartLineNr, iASTNode.getFileLocation().getStartingLineNumber())) {
            arrayList.addAll(this.getAllTheAcsl(decoratorNode, this.mCurrentStartLineNr, iASTNode.getFileLocation().getStartingLineNumber()));
        }
        if (!this.containsAcsl(iASTNode)) {
            this.mCurrentStartLineNr = iASTNode.getFileLocation().getEndingLineNumber() + 1;
            arrayList.add(new DecoratorNode(decoratorNode, iASTNode));
            return arrayList;
        }
        DecoratorNode decoratorNode2 = new DecoratorNode(decoratorNode, iASTNode);
        arrayList.add(decoratorNode2);
        boolean bl = false;
        int n = 0;
        while (n < iASTNode.getChildren().length) {
            if (iASTNode.getChildren()[n].isPartOfTranslationUnitFile()) {
                if (!bl) {
                    bl = true;
                    this.mCurrentStartLineNr = iASTNode.getFileLocation().getStartingLineNumber();
                }
                List<DecoratorNode> list = this.mapASTs(iASTNode.getChildren()[n], decoratorNode2);
                for (DecoratorNode decoratorNode3 : list) {
                    if (decoratorNode3 == null) continue;
                    decoratorNode2.addChildren(decoratorNode3);
                }
            }
            ++n;
        }
        if (this.containsAcsl(this.mCurrentStartLineNr, iASTNode.getFileLocation().getEndingLineNumber() + 1)) {
            decoratorNode2.addAllChildren(this.getAllTheAcsl(decoratorNode2, this.mCurrentStartLineNr, iASTNode.getFileLocation().getEndingLineNumber()));
        }
        this.mCurrentStartLineNr = iASTNode.getFileLocation().getEndingLineNumber();
        return arrayList;
    }

    private List<DecoratorNode> getAllTheAcsl(DecoratorNode decoratorNode, int n, int n2) {
        ArrayList<DecoratorNode> arrayList = new ArrayList<DecoratorNode>();
        int n3 = 0;
        while (n3 < this.mAcslASTs.size()) {
            if (this.mAcslASTs.get(n3).getEndingLineNumber() <= n2 && this.mAcslASTs.get(n3).getStartingLineNumber() >= n) {
                arrayList.add(new DecoratorNode(decoratorNode, this.mAcslASTs.remove(n3)));
                --n3;
            }
            ++n3;
        }
        return arrayList;
    }

    private boolean containsAcsl(IASTNode iASTNode) {
        if (iASTNode.getFileLocation() == null) {
            return false;
        }
        int n = iASTNode.getFileLocation().getStartingLineNumber();
        int n2 = iASTNode.getFileLocation().getEndingLineNumber();
        return this.containsAcsl(n, n2);
    }

    private boolean containsAcsl(int n, int n2) {
        for (ACSLNode aCSLNode : this.mAcslASTs) {
            if (n > aCSLNode.getStartingLineNumber() || n2 < aCSLNode.getEndingLineNumber()) continue;
            return true;
        }
        return false;
    }

    public void provideAcslASTs(List<ACSLNode> list) {
        this.mAcslASTs = new LinkedList<ACSLNode>(list);
    }

    public void addDecoratedUnit(DecoratedUnit decoratedUnit) {
        this.mDecoratedUnits.add(decoratedUnit);
    }

    public int countUnits() {
        return this.mDecoratedUnits.size();
    }

    public DecoratedUnit getUnit(int n) {
        return this.mDecoratedUnits.get(n);
    }

    public List<DecoratedUnit> getUnits() {
        return Collections.unmodifiableList(this.mDecoratedUnits);
    }

    public void setSymbolTable(MultiparseSymbolTable multiparseSymbolTable) {
        this.mSymbolTable = multiparseSymbolTable;
    }

    public MultiparseSymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }
}

