/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class LambdaTerm
extends Term {
    private final TermVariable[] mVariables;
    private final Term mSubTerm;
    private final Sort mSort;

    LambdaTerm(TermVariable[] termVariableArray, Term term, int n) {
        super(n);
        this.mVariables = termVariableArray;
        this.mSubTerm = term;
        Sort sort = term.getSort();
        int n2 = termVariableArray.length - 1;
        while (n2 >= 0) {
            sort = sort.getTheory().getSort("->", termVariableArray[n2].getSort(), sort);
            --n2;
        }
        this.mSort = sort;
    }

    public TermVariable[] getVariables() {
        return this.mVariables;
    }

    public Term getSubterm() {
        return this.mSubTerm;
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    public static final int hashLambda(TermVariable[] termVariableArray, Term term) {
        return HashUtils.hashJenkins((int)term.hashCode(), (Object[])termVariableArray);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> arrayDeque) {
        arrayDeque.addLast(")");
        arrayDeque.addLast(this.getSubterm());
        arrayDeque.addLast(")) ");
        TermVariable[] termVariableArray = this.getVariables();
        int n = termVariableArray.length - 1;
        while (n > 0) {
            arrayDeque.addLast(termVariableArray[n].getSort());
            arrayDeque.addLast(") (" + String.valueOf(termVariableArray[n]) + " ");
            --n;
        }
        arrayDeque.addLast(termVariableArray[0].getSort());
        arrayDeque.addLast("(lambda ((" + String.valueOf(termVariableArray[0]) + " ");
    }
}

