/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class QuantifiedFormula
extends Term {
    public static final int EXISTS = 0;
    public static final int FORALL = 1;
    private final int mQuantifier;
    private final TermVariable[] mVariables;
    private final Term mSubFormula;

    QuantifiedFormula(int n, TermVariable[] termVariableArray, Term term, int n2) {
        super(n2);
        this.mQuantifier = n;
        this.mVariables = termVariableArray;
        this.mSubFormula = term;
    }

    public int getQuantifier() {
        return this.mQuantifier;
    }

    public TermVariable[] getVariables() {
        return this.mVariables;
    }

    public Term getSubformula() {
        return this.mSubFormula;
    }

    @Override
    public Sort getSort() {
        return this.mSubFormula.getSort();
    }

    public static final int hashQuantifier(int n, TermVariable[] termVariableArray, Term term) {
        return HashUtils.hashJenkins((int)(term.hashCode() ^ n), (Object[])termVariableArray);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> arrayDeque) {
        arrayDeque.addLast(")");
        arrayDeque.addLast(this.getSubformula());
        arrayDeque.addLast(")) ");
        TermVariable[] termVariableArray = this.getVariables();
        int n = termVariableArray.length - 1;
        while (n > 0) {
            arrayDeque.addLast(termVariableArray[n].getSort());
            arrayDeque.addLast(") (" + String.valueOf(termVariableArray[n]) + " ");
            --n;
        }
        arrayDeque.addLast(termVariableArray[0].getSort());
        arrayDeque.addLast("(" + (this.getQuantifier() == 0 ? "exists" : "forall") + " ((" + String.valueOf(termVariableArray[0]) + " ");
    }
}

