/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;

public class TermEquivalence
extends NonRecursive {
    private final ScopedHashMap<TermVariable, TermVariable> mRenaming = new ScopedHashMap();

    private void beginScope() {
        this.mRenaming.beginScope();
    }

    private void endScope() {
        this.mRenaming.endScope();
    }

    private void addRenaming(TermVariable termVariable, TermVariable termVariable2) {
        this.mRenaming.put((Object)termVariable, (Object)termVariable2);
    }

    private boolean checkRenaming(TermVariable termVariable, TermVariable termVariable2) {
        return this.mRenaming.get((Object)termVariable) == termVariable2;
    }

    public boolean equal(Term term, Term term2) {
        try {
            this.run(new TermEq(term, term2));
            return true;
        }
        catch (NotEq notEq) {
            this.reset();
            return false;
        }
    }

    private static final class AddRenaming
    implements NonRecursive.Walker {
        private final TermVariable mLvar;
        private final TermVariable mRvar;

        public AddRenaming(TermVariable termVariable, TermVariable termVariable2) {
            this.mLvar = termVariable;
            this.mRvar = termVariable2;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermEquivalence termEquivalence = (TermEquivalence)nonRecursive;
            termEquivalence.addRenaming(this.mLvar, this.mRvar);
        }
    }

    private static final class ArrayEq
    implements NonRecursive.Walker {
        private final Object[] mLhs;
        private final Object[] mRhs;

        public ArrayEq(Object[] objectArray, Object[] objectArray2) {
            this.mLhs = objectArray;
            this.mRhs = objectArray2;
        }

        private final void notEqual() {
            throw new NotEq();
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermEquivalence termEquivalence = (TermEquivalence)nonRecursive;
            if (this.mLhs != this.mRhs) {
                if (this.mLhs.getClass() != this.mRhs.getClass()) {
                    this.notEqual();
                }
                if (this.mLhs.length != this.mRhs.length) {
                    this.notEqual();
                }
                int n = 0;
                while (n < this.mLhs.length) {
                    if (this.mLhs[n] != this.mRhs[n]) {
                        if (this.mLhs[n] instanceof Term && this.mRhs[n] instanceof Term) {
                            termEquivalence.enqueueWalker(new TermEq((Term)this.mLhs[n], (Term)this.mRhs[n]));
                        } else if (this.mLhs[n] instanceof Object[] && this.mRhs[n] instanceof Object[]) {
                            termEquivalence.enqueueWalker(new ArrayEq((Object[])this.mLhs[n], (Object[])this.mRhs[n]));
                        } else if (!(this.mLhs[n] == this.mRhs[n] || this.mLhs[n] != null && this.mLhs[n].equals(this.mRhs[n]))) {
                            this.notEqual();
                        }
                    }
                    ++n;
                }
            }
        }
    }

    private static final class EndScope
    implements NonRecursive.Walker {
        public static final EndScope INSTANCE = new EndScope();

        private EndScope() {
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermEquivalence termEquivalence = (TermEquivalence)nonRecursive;
            termEquivalence.endScope();
        }
    }

    private static final class NotEq
    extends RuntimeException {
        private NotEq() {
        }
    }

    private static final class TermEq
    implements NonRecursive.Walker {
        private final Term mLhs;
        private final Term mRhs;

        public TermEq(Term term, Term term2) {
            this.mLhs = term;
            this.mRhs = term2;
        }

        private final void notEqual() {
            throw new NotEq();
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermEquivalence termEquivalence = (TermEquivalence)nonRecursive;
            if (this.mLhs != this.mRhs) {
                TermVariable termVariable;
                TermVariable termVariable2;
                if (this.mLhs.getClass() != this.mRhs.getClass()) {
                    this.notEqual();
                }
                if (this.mLhs instanceof ApplicationTerm) {
                    Term[] termArray;
                    Term[] termArray2;
                    ApplicationTerm applicationTerm = (ApplicationTerm)this.mLhs;
                    ApplicationTerm applicationTerm2 = (ApplicationTerm)this.mRhs;
                    if (applicationTerm.getFunction() != applicationTerm2.getFunction()) {
                        this.notEqual();
                    }
                    if ((termArray2 = applicationTerm.getParameters()).length != (termArray = applicationTerm2.getParameters()).length) {
                        this.notEqual();
                    }
                    int n = 0;
                    while (n < termArray2.length) {
                        termEquivalence.enqueueWalker(new TermEq(termArray2[n], termArray[n]));
                        ++n;
                    }
                } else if (this.mLhs instanceof AnnotatedTerm) {
                    AnnotatedTerm annotatedTerm = (AnnotatedTerm)this.mLhs;
                    AnnotatedTerm annotatedTerm2 = (AnnotatedTerm)this.mRhs;
                    Annotation[] annotationArray = annotatedTerm.getAnnotations();
                    Annotation[] annotationArray2 = annotatedTerm2.getAnnotations();
                    if (annotationArray2.length != annotationArray.length) {
                        this.notEqual();
                    }
                    int n = 0;
                    while (n < annotationArray.length) {
                        if (!annotationArray[n].getKey().equals(annotationArray2[n].getKey())) {
                            this.notEqual();
                        }
                        if (annotationArray[n].getValue() instanceof Term && annotationArray2[n].getValue() instanceof Term) {
                            termEquivalence.enqueueWalker(new TermEq((Term)annotationArray[n].getValue(), (Term)annotationArray2[n].getValue()));
                        } else if (annotationArray[n].getValue() instanceof Object[] && annotationArray2[n].getValue() instanceof Object[]) {
                            termEquivalence.enqueueWalker(new ArrayEq((Object[])annotationArray[n].getValue(), (Object[])annotationArray2[n].getValue()));
                        } else if (!(annotationArray[n].getValue() == annotationArray2[n].getValue() || annotationArray[n].getValue() != null && annotationArray[n].getValue().equals(annotationArray2[n].getValue()))) {
                            this.notEqual();
                        }
                        ++n;
                    }
                } else if (this.mLhs instanceof LetTerm) {
                    TermVariable[] termVariableArray;
                    LetTerm letTerm = (LetTerm)this.mLhs;
                    LetTerm letTerm2 = (LetTerm)this.mRhs;
                    TermVariable[] termVariableArray2 = letTerm.getVariables();
                    if (termVariableArray2.length != (termVariableArray = letTerm2.getVariables()).length) {
                        this.notEqual();
                    }
                    termEquivalence.enqueueWalker(EndScope.INSTANCE);
                    termEquivalence.enqueueWalker(new TermEq(letTerm.getSubTerm(), letTerm2.getSubTerm()));
                    Term[] termArray = letTerm.getValues();
                    Term[] termArray3 = letTerm2.getValues();
                    int n = 0;
                    while (n < termVariableArray2.length) {
                        termEquivalence.enqueueWalker(new AddRenaming(termVariableArray2[n], termVariableArray[n]));
                        termEquivalence.enqueueWalker(new TermEq(termArray[n], termArray3[n]));
                        ++n;
                    }
                    termEquivalence.beginScope();
                } else if (this.mLhs instanceof QuantifiedFormula) {
                    TermVariable[] termVariableArray;
                    TermVariable[] termVariableArray3;
                    QuantifiedFormula quantifiedFormula = (QuantifiedFormula)this.mLhs;
                    QuantifiedFormula quantifiedFormula2 = (QuantifiedFormula)this.mRhs;
                    if (quantifiedFormula.getQuantifier() != quantifiedFormula2.getQuantifier()) {
                        this.notEqual();
                    }
                    if ((termVariableArray3 = quantifiedFormula.getVariables()).length != (termVariableArray = quantifiedFormula2.getVariables()).length) {
                        this.notEqual();
                    }
                    termEquivalence.enqueueWalker(EndScope.INSTANCE);
                    termEquivalence.beginScope();
                    int n = 0;
                    while (n < termVariableArray3.length) {
                        if (termVariableArray3[n] != termVariableArray[n]) {
                            if (termVariableArray3[n].getSort() != termVariableArray[n].getSort()) {
                                this.notEqual();
                            }
                            termEquivalence.addRenaming(termVariableArray3[n], termVariableArray[n]);
                        }
                        ++n;
                    }
                    termEquivalence.enqueueWalker(new TermEq(quantifiedFormula.getSubformula(), quantifiedFormula2.getSubformula()));
                } else if (this.mLhs instanceof TermVariable && !termEquivalence.checkRenaming(termVariable2 = (TermVariable)this.mLhs, termVariable = (TermVariable)this.mRhs)) {
                    this.notEqual();
                }
            }
        }
    }
}

