/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.astbuilder;

import de.uni_freiburg.informatik.ultimate.astbuilder.Emit;
import de.uni_freiburg.informatik.ultimate.astbuilder.Grammar;
import de.uni_freiburg.informatik.ultimate.astbuilder.Node;
import de.uni_freiburg.informatik.ultimate.astbuilder.Parameter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Predicate;

public abstract class EmitAstWithVisitors
extends Emit {
    private static final String COMMA = ", ";
    private static final String BLANK = " ";
    private static final String CLOSE_PARENTHESIS_SEMICOLON = ");";
    private static final String NEW = "new";
    private static final String OR = " || ";
    private static final int LENGTH_OF_OR = 4;
    private static final int MIN_SIZE_EMIT_CLASS_DECLARATION = 33;
    protected final String mTimestamp;

    protected boolean isNonClassicNode(Node node) {
        return this.getNonClassicNode().contains(node.getName());
    }

    protected abstract Set<String> getNonClassicNode();

    protected abstract String getVisitorName();

    protected abstract String getTransformerName();

    protected abstract String getRootClassName();

    public EmitAstWithVisitors() {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        simpleDateFormat.setTimeZone(timeZone);
        this.mTimestamp = simpleDateFormat.format(new Date());
    }

    protected boolean isRootSerializable() {
        return false;
    }

    @Override
    public void emitToplevelComment(Node node) {
        this.mWriter.println(String.format("/* %s -- Automatically generated by TreeBuilder (%s) */", node.getName(), this.mTimestamp));
    }

    @Override
    public void emitPreamble(Node node) {
        boolean bl;
        super.emitPreamble(node);
        this.mWriter.println("import java.util.List;");
        if (this.needsArraysPackage(node)) {
            this.mWriter.println("import java.util.Arrays;");
        }
        if ((bl = this.getAllParameters(node).stream().anyMatch(EmitAstWithVisitors::isArrayType)) && !node.isAbstract()) {
            this.mWriter.println("import java.util.ArrayList;");
        }
    }

    @Override
    public void emitClassDeclaration(Node node) {
        super.emitClassDeclaration(node);
        if (this.isNonClassicNode(node)) {
            return;
        }
        if (this.isRootSerializable()) {
            this.mWriter.println("    private static final long serialVersionUID = 1L;");
        }
        this.mWriter.println("    private static final java.util.function.Predicate<" + this.getRootClassName() + "> VALIDATOR = ");
        this.mWriter.println("\t\t\t" + this.getRootClassName() + ".VALIDATORS.get(" + node.getName() + ".class);");
    }

    @Override
    protected Optional<String> getBaseClass(Node node) {
        Optional<String> optional = super.getBaseClass(node);
        if (optional.isPresent()) {
            return optional;
        }
        if (this.isNonClassicNode(node)) {
            return Optional.empty();
        }
        return Optional.of(this.getRootClassName());
    }

    @Override
    protected boolean isSealed(Node node) {
        return !this.isNonClassicNode(node);
    }

    @Override
    public void emitNodeHook(Node node) {
        if (node.name.equals(this.getVisitorName())) {
            this.emitVisitorHook();
        } else if (node.name.equals(this.getTransformerName())) {
            this.emitTransformerHook();
        } else {
            this.emitClassicNodeHook(node);
        }
    }

    private void emitClassicNodeHook(Node node) {
        Object object;
        this.mWriter.println();
        this.mWriter.println("    public List<" + this.getRootClassName() + "> getOutgoingNodes() {");
        this.mWriter.println("        List<" + this.getRootClassName() + "> children = super.getOutgoingNodes();");
        Parameter[] parameterArray = node.getParameters();
        System.out.println(node.getName() + " has " + parameterArray.length + " parameters");
        Parameter[] parameterArray2 = parameterArray;
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = parameterArray2[n2];
            if (!this.isNoRegularChild(((Parameter)object).getType())) {
                System.out.println(((Parameter)object).getName() + " is an array? " + EmitAstWithVisitors.isArray(((Parameter)object).getType()));
                if (EmitAstWithVisitors.isArray(((Parameter)object).getType())) {
                    this.mWriter.println(String.format("        if(%s!=null){", ((Parameter)object).getName()));
                    this.mWriter.println(String.format("            children.addAll(Arrays.asList(%s));", ((Parameter)object).getName()));
                    this.mWriter.println("        }");
                } else {
                    this.mWriter.println("        children.add(" + ((Parameter)object).getName() + CLOSE_PARENTHESIS_SEMICOLON);
                }
            }
            ++n2;
        }
        this.mWriter.println("        return children;");
        this.mWriter.println("    }");
        if (!node.isAbstract()) {
            object = this.getAllParameters(node);
            this.writeVisitorAcceptMethod(node, (List<Parameter>)object);
            this.writeTransformerAcceptMethod(node, (List<Parameter>)object);
        } else {
            this.mWriter.println();
            this.mWriter.println("    public abstract void accept(" + this.getVisitorName() + " visitor);");
            this.mWriter.println();
            this.mWriter.println("    public abstract " + node.name + " accept(" + this.getTransformerName() + " visitor);");
        }
    }

    private void emitTransformerHook() {
        for (Node node : this.mGrammar.getNodeTable().values()) {
            if (this.getNonClassicNode().contains(node.getName())) continue;
            String string = this.getAbstractParentName(node);
            this.mWriter.println();
            this.mWriter.println("    public " + string + " transform(" + node.name + " node) {");
            this.mWriter.println("        return node;");
            this.mWriter.println("    }");
        }
    }

    private String getAbstractParentName(Node node) {
        Node node2 = this.getAbstractParent(node);
        if (node2 == null) {
            return node.name;
        }
        return node2.name;
    }

    private Node getAbstractParent(Node node) {
        if (node == null || node.isAbstract) {
            return node;
        }
        return this.getAbstractParent(node.parent);
    }

    private void emitVisitorHook() {
        for (Node node : this.mGrammar.getNodeTable().values()) {
            if (this.getNonClassicNode().contains(node.getName())) continue;
            this.mWriter.println();
            this.mWriter.println("    public boolean visit(" + node.name + " node) {");
            this.mWriter.println("        return true;");
            this.mWriter.println("    }");
        }
    }

    @Override
    public void emitConstructors(Node node) {
        int n = 1;
        int n2 = 1;
        Node node2 = node;
        while (node2 != null) {
            Parameter[] parameterArray = node2.parameters;
            int n3 = node2.parameters.length;
            int n4 = 0;
            while (n4 < n3) {
                Parameter parameter = parameterArray[n4];
                ++n2;
                if (!parameter.isOptional()) {
                    ++n;
                }
                ++n4;
            }
            node2 = node2.getParent();
        }
        if (n < n2) {
            this.emitConstructor(node, false);
        }
        this.emitConstructor(node, true);
    }

    @Override
    public void emitConstructorAfterParamAssign(Node node, boolean bl) {
        super.emitConstructorAfterParamAssign(node, bl);
        if (this.isNonClassicNode(node)) {
            return;
        }
        this.mWriter.println("        assert VALIDATOR == null || VALIDATOR.test(this) : \"Invalid " + node.getName() + ": \" + this;");
    }

    protected static boolean isArray(String string) {
        return string.contains("[");
    }

    protected boolean isNoRegularChild(String string) {
        String string2 = string;
        while (string2.endsWith("[]")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return !this.mGrammar.getNodeTable().containsKey(string2);
    }

    private static boolean isArrayType(Parameter parameter) {
        return parameter.getType().contains("[]");
    }

    private static String getBaseType(Parameter parameter) {
        return parameter.getType().replace("[]", "");
    }

    protected boolean needsArraysPackage(Node node) {
        Predicate<String> predicate = this::isNoRegularChild;
        return Arrays.stream(node.getParameters()).map(Parameter::getType).filter(predicate.negate()).anyMatch(EmitAstWithVisitors::isArray);
    }

    private void writeTransformerAcceptMethod(Node node, List<Parameter> list) {
        String string;
        String string2 = this.getAbstractParentName(node);
        this.mWriter.println();
        this.mWriter.println("    public " + string2 + " accept(" + this.getTransformerName() + " visitor) {");
        this.mWriter.println("        " + string2 + " node = visitor.transform(this);");
        this.mWriter.println("        if(node != this){");
        this.mWriter.println("            return node;");
        this.mWriter.println("        }");
        this.mWriter.println();
        boolean bl = false;
        for (Parameter parameter : list) {
            String string3 = NEW + parameter.getName();
            string = "tmpList" + (String)string3;
            boolean bl2 = EmitAstWithVisitors.isArrayType(parameter);
            String string4 = bl2 ? EmitAstWithVisitors.getBaseType(parameter) : parameter.type;
            if (bl2) {
                if (!bl) {
                    this.mWriter.println("        boolean isChanged=false;");
                    bl = true;
                }
                this.mWriter.println("            ArrayList<" + string4 + "> " + string + " = new ArrayList<>();");
            } else {
                this.mWriter.println("            " + string4 + BLANK + (String)string3 + " = null;");
            }
            this.mWriter.println("        if(" + parameter.getName() + " != null){");
            if (bl2) {
                this.mWriter.println("            for(" + string4 + " elem : " + parameter.getName() + "){");
                this.mWriter.println("                " + string4 + BLANK + (String)string3 + " = (" + string4 + ")elem.accept(visitor);");
                this.mWriter.println("                isChanged = isChanged || " + (String)string3 + " != elem;");
                this.mWriter.println("                " + string + ".add(" + (String)string3 + CLOSE_PARENTHESIS_SEMICOLON);
                this.mWriter.println("            }");
            } else {
                this.mWriter.println("            " + (String)string3 + " = (" + string4 + ")" + parameter.getName() + ".accept(visitor);");
            }
            this.mWriter.println("        }");
        }
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("        if(");
            if (bl) {
                stringBuilder.append("isChanged || ");
            }
            for (Parameter parameter : list) {
                if (EmitAstWithVisitors.isArrayType(parameter)) continue;
                string = NEW + parameter.getName();
                stringBuilder.append(parameter.name).append(" != ").append(string).append(OR);
            }
            if (OR.equals(stringBuilder.substring(stringBuilder.length() - 4, stringBuilder.length()))) {
                stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
            }
            stringBuilder.append("){");
            this.mWriter.println(stringBuilder.toString());
            this.mWriter.println("            return new " + node.name + "(" + this.getNewCallParams(node) + CLOSE_PARENTHESIS_SEMICOLON);
            this.mWriter.println("        }");
        }
        this.mWriter.println("        return this;");
        this.mWriter.println("    }");
    }

    private String getNewCallParams(Node node) {
        if (node == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getNewCallParams(node.getParent()));
        String string = "";
        if (stringBuilder.length() > 0) {
            string = COMMA;
        }
        Parameter[] parameterArray = node.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            Object object = !this.mGrammar.nodeTable.containsKey(EmitAstWithVisitors.getBaseType(parameter)) ? parameter.getName() : (EmitAstWithVisitors.isArrayType(parameter) ? "tmpListnew" + parameter.getName() + ".toArray(new " + EmitAstWithVisitors.getBaseType(parameter) + "[0])" : NEW + parameter.getName());
            stringBuilder.append(string).append((String)object);
            string = COMMA;
            ++n2;
        }
        return stringBuilder.toString();
    }

    private void writeVisitorAcceptMethod(Node node, List<Parameter> list) {
        this.mWriter.println();
        this.mWriter.println("    public void accept(" + this.getVisitorName() + " visitor) {");
        String string = System.getProperty("line.separator");
        Node node2 = node.getParent();
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        if (node2 != null) {
            Object object;
            int n2;
            while (node2 != null) {
                n2 = n + 1;
                object = "    ";
                while (n2 > 0) {
                    object = (String)object + "    ";
                    --n2;
                }
                stringBuilder.append((String)object).append(String.format("if (visitor.visit((%s)this)) {", node2.name)).append(string);
                stringBuilder.append((String)object).append("    ").append("//visit parent types higher up if necessary").append(string);
                node2 = node2.getParent();
                ++n;
            }
            while (n > 0) {
                n2 = n + 1;
                object = "";
                while (n2 > 0) {
                    object = (String)object + "    ";
                    --n2;
                }
                stringBuilder.append((String)object).append("} else {").append(string);
                stringBuilder.append("    ").append((String)object).append("return;").append(string);
                stringBuilder.append("    ");
                --n;
            }
            stringBuilder.append("    ").append('}');
            this.mWriter.println(stringBuilder.toString());
        }
        if (list.isEmpty()) {
            this.mWriter.println("        visitor.visit(this);");
        } else {
            this.mWriter.println("        if (visitor.visit(this)) {");
            for (Parameter parameter : list) {
                this.mWriter.println("            if(" + parameter.getName() + "!=null){");
                if (EmitAstWithVisitors.isArrayType(parameter)) {
                    this.mWriter.println("                for (" + EmitAstWithVisitors.getBaseType(parameter) + " elem : " + parameter.getName() + ") {");
                    this.mWriter.println("                    elem.accept(visitor);");
                    this.mWriter.println("                }");
                } else {
                    this.mWriter.println("                " + parameter.getName() + ".accept(visitor);");
                }
                this.mWriter.println("            }");
            }
            this.mWriter.println("        }");
        }
        this.mWriter.println("    }");
    }

    protected List<Parameter> getAllParameters(Node node) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        Node node2 = node;
        while (node2 != null) {
            Parameter[] parameterArray = node2.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                if (this.mGrammar.nodeTable.containsKey(EmitAstWithVisitors.getBaseType(parameter))) {
                    arrayList.add(parameter);
                }
                ++n2;
            }
            node2 = node2.getParent();
        }
        return arrayList;
    }

    @Override
    public void setGrammar(Grammar grammar) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Node node : grammar.getNodeTable().values()) {
            hashSet.add(node.name);
        }
        grammar.getNodeTable().put(this.getVisitorName(), new Node(this.getVisitorName(), null, null, "", hashSet, false, new Parameter[0]));
        grammar.getNodeTable().put(this.getTransformerName(), new Node(this.getTransformerName(), null, null, "", hashSet, false, new Parameter[0]));
        super.setGrammar(grammar);
    }
}

