/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser.graph;

import de.uni_freiburg.informatik.ultimate.core.lib.models.ModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessLocation;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import java.util.Objects;

public class WitnessEdge
extends ModifiableMultigraphEdge<WitnessNode, WitnessEdge, WitnessNode, WitnessEdge> {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private final String mSourceCode;
    private final WitnessLocation mLocation;

    public WitnessEdge(WitnessNode witnessNode, WitnessNode witnessNode2, String string, WitnessLocation witnessLocation, String string2) {
        super((IModifiableExplicitEdgesMultigraph)witnessNode, (IModifiableExplicitEdgesMultigraph)witnessNode2);
        this.mName = string;
        this.mLocation = witnessLocation;
        this.mSourceCode = string2;
        this.redirectSource((IModifiableExplicitEdgesMultigraph)witnessNode);
        this.redirectTarget((IModifiableExplicitEdgesMultigraph)witnessNode2);
    }

    public ILocation getLocation() {
        return this.mLocation;
    }

    public String getName() {
        return this.mName;
    }

    public String getSourceCode() {
        return this.mSourceCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mName != null) {
            stringBuilder.append("[" + this.mName + "] ");
        }
        if (this.mLocation != null) {
            stringBuilder.append("L").append(this.mLocation.getStartLine()).append(" ");
        }
        if (this.mSourceCode != null) {
            stringBuilder.append(this.mSourceCode);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mLocation, this.mName, this.mSourceCode});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        WitnessEdge witnessEdge = (WitnessEdge)((Object)object);
        return Objects.equals((Object)this.mLocation, (Object)witnessEdge.mLocation) && Objects.equals(this.mName, witnessEdge.mName) && Objects.equals(this.mSourceCode, witnessEdge.mSourceCode);
    }

    public WitnessEdge getLabel() {
        return this;
    }
}

