/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;

public class LoopExitAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = LoopExitAnnotation.class.getName();
    @Visualizable
    private final LoopExitType mType;

    public LoopExitAnnotation(LoopExitType loopExitType) {
        this.mType = loopExitType;
    }

    public LoopExitType getLoopExitType() {
        return this.mType;
    }

    public void annotate(IElement iElement) {
        iElement.getPayload().getAnnotations().put(KEY, this);
    }

    public static LoopExitAnnotation getAnnotation(IElement iElement) {
        return (LoopExitAnnotation)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (LoopExitAnnotation)iAnnotations);
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations instanceof LoopExitAnnotation) {
            LoopExitAnnotation loopExitAnnotation = (LoopExitAnnotation)iAnnotations;
            if (loopExitAnnotation.mType.equals((Object)this.mType)) {
                return this;
            }
            return new LoopExitAnnotation(LoopExitType.UNKNOWN);
        }
        return super.merge(iAnnotations);
    }

    public String toString() {
        return this.mType.toString();
    }

    public static enum LoopExitType {
        BREAK,
        RETURN,
        GOTO,
        WHILE,
        UNKNOWN;

    }
}

