/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MultiDimensionalSelect
implements ITermProvider {
    private final Term mArray;
    private final ArrayIndex mIndex;

    public MultiDimensionalSelect(Term term, ArrayIndex arrayIndex) {
        if (arrayIndex.isEmpty()) {
            throw new AssertionError((Object)"Zero dimensions are not supported");
        }
        this.mArray = term;
        this.mIndex = arrayIndex;
    }

    public static MultiDimensionalSelect of(Term term) {
        ApplicationTerm applicationTerm;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        while (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getFunction().getName().equals("select")) {
            assert (applicationTerm.getParameters().length == 2);
            arrayList.add(0, applicationTerm.getParameters()[1]);
            term = applicationTerm.getParameters()[0];
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new MultiDimensionalSelect(term, new ArrayIndex(arrayList));
    }

    public Term getArray() {
        return this.mArray;
    }

    public ArrayIndex getIndex() {
        return this.mIndex;
    }

    public int getDimension() {
        return this.getIndex().size();
    }

    public Sort getSort() {
        Sort sort = this.mArray.getSort();
        int n = 0;
        while (n < this.getDimension()) {
            assert (sort.getArguments().length == 2);
            sort = sort.getArguments()[1];
            ++n;
        }
        return sort;
    }

    @Override
    public Term toTerm(Script script) {
        Term term = SmtUtils.multiDimensionalSelect(script, this.getArray(), this.getIndex());
        assert (term.getSort() == this.getSort());
        return term;
    }

    public String toString() {
        return String.format("(select %s %s)", this.mArray, this.mIndex);
    }

    public int hashCode() {
        return Objects.hash(this.mArray, this.mIndex);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalSelect multiDimensionalSelect = (MultiDimensionalSelect)object;
        return Objects.equals(this.mArray, multiDimensionalSelect.mArray) && Objects.equals(this.mIndex, multiDimensionalSelect.mIndex);
    }

    public static List<MultiDimensionalSelect> extractSelectShallow(Term term) {
        ArrayList<MultiDimensionalSelect> arrayList = new ArrayList<MultiDimensionalSelect>();
        Set<ApplicationTerm> set = SmtUtils.extractApplicationTerms("select", term, true);
        for (Term term2 : set) {
            MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of(term2);
            if (multiDimensionalSelect.getIndex().size() == 0) {
                throw new AssertionError((Object)"MultiDimensionalSelect must not have dimension 0 here");
            }
            arrayList.add(multiDimensionalSelect);
        }
        return arrayList;
    }

    public static List<MultiDimensionalSelect> extractSelectDeep(Term term) {
        LinkedList<MultiDimensionalSelect> linkedList = new LinkedList<MultiDimensionalSelect>();
        List<MultiDimensionalSelect> list = MultiDimensionalSelect.extractSelectShallow(term);
        while (!list.isEmpty()) {
            linkedList.addAll(0, list);
            List<MultiDimensionalSelect> list2 = list;
            list = new ArrayList<MultiDimensionalSelect>();
            for (MultiDimensionalSelect multiDimensionalSelect : list2) {
                list.addAll(MultiDimensionalSelect.extractSelectShallow(multiDimensionalSelect.getArray()));
                ArrayIndex arrayIndex = multiDimensionalSelect.getIndex();
                for (Term term2 : arrayIndex) {
                    list.addAll(MultiDimensionalSelect.extractSelectShallow(term2));
                }
            }
        }
        return linkedList;
    }
}

