/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DualJunctionSgi
extends DualJunctionQuantifierElimination {
    public DualJunctionSgi(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider);
    }

    @Override
    public String getName() {
        return "syntax guided instantiation";
    }

    @Override
    public String getAcronym() {
        return "SGI";
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask eliminationTask) {
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getContext().getCriticalConstraint());
        Term[] termArray2 = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        List<Term> list = Arrays.asList(termArray);
        List<Term> list2 = Arrays.asList(termArray2);
        List<Map<TermVariable, Term>> list3 = this.instantiateCartesian(eliminationTask.getEliminatees(), list2, list);
        if (list3 != null) {
            return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask.update(this.mScript.term("true", new Term[0])), Collections.emptySet());
        }
        return null;
    }

    public List<Map<TermVariable, Term>> instantiateCartesian(Set<TermVariable> set, List<Term> list, List<Term> list2) {
        boolean bl = false;
        ArrayList<Map<TermVariable, Term>> arrayList = new ArrayList<Map<TermVariable, Term>>();
        int n = 0;
        while (n < list.size()) {
            block6: {
                Collections.rotate(list, 1);
                List<Map<TermVariable, Term>> list3 = new ArrayList<Map<TermVariable, Term>>();
                HashSet<Integer> hashSet = new HashSet<Integer>();
                boolean bl2 = false;
                for (Term term : list) {
                    List<Map<TermVariable, Term>> list4 = null;
                    int n2 = 0;
                    while (n2 < list2.size()) {
                        List<Map<TermVariable, Term>> list5;
                        if (!hashSet.contains(n2) && (list4 = this.matchExpression(set, term, list2.get(n2))) != null && (list5 = this.mergeAllMaps(list3, list4)) != null) {
                            list3 = list5;
                            bl2 = true;
                            hashSet.add(n2);
                            break;
                        }
                        ++n2;
                    }
                    if (list4 != null) {
                        continue;
                    }
                    break block6;
                }
                bl = bl || bl2;
                arrayList.addAll(list3);
            }
            ++n;
        }
        if (bl) {
            return arrayList;
        }
        return null;
    }

    public List<Map<TermVariable, Term>> instantiatePairwise(Set<TermVariable> set, List<Term> list, List<Term> list2) {
        List<Map<TermVariable, Term>> list3 = new ArrayList<Map<TermVariable, Term>>();
        int n = 0;
        while (n < list.size()) {
            List<Map<TermVariable, Term>> list4 = null;
            list4 = this.matchExpression(set, list.get(n), list2.get(n));
            if (list4 != null) {
                if ((list3 = this.mergeAllMaps(list3, list4)) == null) {
                    return null;
                }
            } else {
                return null;
            }
            ++n;
        }
        return list3;
    }

    public List<Map<TermVariable, Term>> mergeAllMaps(List<Map<TermVariable, Term>> list, List<Map<TermVariable, Term>> list2) {
        ArrayList<Map<TermVariable, Term>> arrayList = new ArrayList<Map<TermVariable, Term>>();
        if (list.isEmpty()) {
            arrayList.addAll(list2);
            return arrayList;
        }
        int n = 0;
        while (n < list.size()) {
            int n2 = 0;
            while (n2 < list2.size()) {
                Map<TermVariable, Term> map = this.mergeTwoMaps(list.get(n), list2.get(n2));
                if (map != null) {
                    arrayList.add(map);
                }
                ++n2;
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public Map<TermVariable, Term> mergeTwoMaps(Map<TermVariable, Term> map, Map<TermVariable, Term> map2) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (TermVariable termVariable : map.keySet()) {
            if (!map2.containsKey(termVariable) || map.get(termVariable) == map2.get(termVariable)) continue;
            return null;
        }
        hashMap.putAll(map);
        hashMap.putAll(map2);
        return hashMap;
    }

    public List<Map<TermVariable, Term>> matchExpression(Set<TermVariable> set, Term term, Term term2) {
        if (term instanceof ApplicationTerm && term2 instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
            if (applicationTerm.getFunction() == applicationTerm2.getFunction()) {
                Boolean bl = CommuhashUtils.isKnownToBeCommutative(applicationTerm.getFunction().getName());
                if (Arrays.asList(applicationTerm.getParameters()).size() == Arrays.asList(applicationTerm2.getParameters()).size()) {
                    List<Map<TermVariable, Term>> list = bl != false ? this.instantiateCartesian(set, Arrays.asList(applicationTerm.getParameters()), Arrays.asList(applicationTerm2.getParameters())) : this.instantiatePairwise(set, Arrays.asList(applicationTerm.getParameters()), Arrays.asList(applicationTerm2.getParameters()));
                    return list;
                }
            } else {
                return null;
            }
        }
        if (term instanceof TermVariable) {
            if (set.contains(term)) {
                return List.of(Collections.singletonMap((TermVariable)term, term2));
            }
            if (term == term2) {
                return List.of(Collections.emptyMap());
            }
            if (term != term2) {
                return null;
            }
        }
        if (term instanceof ConstantTerm && term2 instanceof ConstantTerm && ((ConstantTerm)term).getValue() == ((ConstantTerm)term2).getValue()) {
            return List.of(Collections.emptyMap());
        }
        return null;
    }
}

