/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisTermTransducer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeHashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class XnfScout
extends CondisTermTransducer<Result> {
    private static final boolean OPTION_OMIT_DESCED_FOR_DER = false;
    private final Script mScript;
    private final int mQuantifier;
    private final TermVariable mEliminatee;
    private final Set<TermVariable> mQuantifiedInAncestors;

    public XnfScout(Script script, int n, TermVariable termVariable, Set<TermVariable> set) {
        this.mScript = script;
        this.mQuantifier = n;
        this.mEliminatee = termVariable;
        this.mQuantifiedInAncestors = set;
    }

    private Occurrence classify(Script script, int n, Term term, TermVariable termVariable, Set<TermVariable> set) {
        if (!Arrays.asList(term.getFreeVars()).contains(termVariable)) {
            return Occurrence.ABSENT;
        }
        if (SmtSortUtils.isBoolSort(termVariable.getSort())) {
            if (term.equals(termVariable) || termVariable.equals(SmtUtils.unzipNot(term))) {
                return Occurrence.DER;
            }
            return Occurrence.OTHER_OCCURRENCE;
        }
        if (SmtSortUtils.isArraySort(termVariable.getSort())) {
            if (this.isDerRelationForArray(n, term, termVariable)) {
                return Occurrence.DER;
            }
            return Occurrence.ELIMINABLE;
        }
        PolynomialRelation polynomialRelation = PolynomialRelation.of(script, term);
        if (polynomialRelation == null) {
            return Occurrence.OTHER_OCCURRENCE;
        }
        SolvedBinaryRelation solvedBinaryRelation = polynomialRelation.solveForSubject(script, (Term)termVariable);
        if (solvedBinaryRelation == null) {
            return Occurrence.OTHER_OCCURRENCE;
        }
        if (polynomialRelation.getRelationSymbol() == QuantifierUtils.getDerOperator(n)) {
            return Occurrence.DER;
        }
        return Occurrence.ELIMINABLE;
    }

    private boolean isDerRelationForArray(int n, Term term, TermVariable termVariable) {
        BinaryEqualityRelation binaryEqualityRelation = BinaryEqualityRelation.convert(term);
        if (binaryEqualityRelation == null) {
            return false;
        }
        SolvedBinaryRelation solvedBinaryRelation = binaryEqualityRelation.solveForSubject(null, (Term)termVariable);
        if (solvedBinaryRelation == null) {
            return false;
        }
        return binaryEqualityRelation.getRelationSymbol() == QuantifierUtils.getDerOperator(n);
    }

    @Override
    protected Result transduceAtom(Term term) {
        long l;
        long l2;
        long l3;
        Occurrence occurrence = this.classify(this.mScript, this.mQuantifier, term, this.mEliminatee, this.mQuantifiedInAncestors);
        return new Result(Adk.ATOM, l3, l2, l, switch (occurrence) {
            case Occurrence.ABSENT -> {
                l3 = 0L;
                l2 = 0L;
                l = 0L;
                yield true;
            }
            case Occurrence.DER -> {
                l3 = 1L;
                l2 = 0L;
                l = 0L;
                yield false;
            }
            case Occurrence.ELIMINABLE -> {
                l3 = 0L;
                l2 = 1L;
                l = 0L;
                yield false;
            }
            case Occurrence.OTHER_OCCURRENCE -> {
                l3 = 0L;
                l2 = 0L;
                l = 1L;
                yield false;
            }
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)occurrence)));
        });
    }

    @Override
    protected Result transduceConjunction(ApplicationTerm applicationTerm, List<Result> list) {
        Result result;
        if (this.mQuantifier == 0) {
            result = this.transduceDual(applicationTerm, Adk.CONJUNCTION, list);
        } else if (this.mQuantifier == 1) {
            result = this.transduceCorresponding(applicationTerm, Adk.CONJUNCTION, list);
        } else {
            throw new AssertionError((Object)("Unknown quantifier " + this.mQuantifier));
        }
        return result;
    }

    private Result transduceCorresponding(ApplicationTerm applicationTerm, Adk adk, List<Result> list) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        for (Result result : list) {
            if (result.getAdk() == adk) {
                throw new AssertionError((Object)"Expected alternation between conjunction and disjunction");
            }
            d += result.getDerCorrespondingJuncts();
            d2 += result.getEliminableCorrespondingJuncts();
            d3 += result.getOccurringCorrespondingJuncts();
            bl |= result.isAtLeastOneNonInvolvedCorrespondingJunct();
        }
        return new Result(adk, d, d2, d3, bl);
    }

    private Result transduceDual(ApplicationTerm applicationTerm, Adk adk, List<Result> list) {
        double d = QuantifierUtils.getCorrespondingFiniteJuncts(this.mQuantifier, applicationTerm.getParameters()[0]).length;
        double d2 = list.get(0).getDerCorrespondingJuncts();
        double d3 = list.get(0).getEliminableCorrespondingJuncts();
        double d4 = list.get(0).getOccurringCorrespondingJuncts();
        boolean bl = list.get(0).isAtLeastOneNonInvolvedCorrespondingJunct();
        int n = 1;
        while (n < list.size()) {
            if (list.get(n).getAdk() == adk) {
                throw new AssertionError((Object)"Expected alternation between conjunction and disjunction");
            }
            double d5 = d;
            double d6 = d2;
            double d7 = d3;
            double d8 = d4;
            double d9 = bl ? 1 : 0;
            double d10 = QuantifierUtils.getCorrespondingFiniteJuncts(this.mQuantifier, applicationTerm.getParameters()[n]).length;
            double d11 = list.get(n).getDerCorrespondingJuncts();
            double d12 = list.get(n).getEliminableCorrespondingJuncts();
            double d13 = list.get(n).getOccurringCorrespondingJuncts();
            double d14 = list.get(n).isAtLeastOneNonInvolvedCorrespondingJunct() ? 1 : 0;
            d = d5 * d10;
            d2 = d6 * d11 + d6 * d12 + d6 * d13 + d6 * d14 + d7 * d11 + d8 * d11 + d9 * d11;
            d4 = d8 * d12 + d8 * d13 + d8 * d14 + d7 * d13 + d9 * d13;
            d3 = d7 * d12 + d7 * d14 + d9 * d12;
            bl &= list.get(n).isAtLeastOneNonInvolvedCorrespondingJunct();
            ++n;
        }
        return new Result(adk, d2, d3, d4, bl);
    }

    @Override
    protected Result transduceDisjunction(ApplicationTerm applicationTerm, List<Result> list) {
        Result result;
        if (this.mQuantifier == 0) {
            result = this.transduceCorresponding(applicationTerm, Adk.DISJUNCTION, list);
        } else if (this.mQuantifier == 1) {
            result = this.transduceDual(applicationTerm, Adk.DISJUNCTION, list);
        } else {
            throw new AssertionError((Object)("Unknown quantifier " + this.mQuantifier));
        }
        return result;
    }

    public static TermVariable selectBestEliminatee(Script script, int n, List<TermVariable> list, List<Term> list2) {
        if (list.size() == 1) {
            return list.iterator().next();
        }
        Map<TermVariable, Result> map = XnfScout.computeApplicabilityScore(script, n, list, list2);
        TreeHashRelation treeHashRelation = new TreeHashRelation();
        treeHashRelation.reverseAddAll(map);
        Map.Entry entry = (Map.Entry)treeHashRelation.entrySet().iterator().next();
        return (TermVariable)((HashSet)entry.getValue()).iterator().next();
    }

    private static Map<TermVariable, Result> computeApplicabilityScore(Script script, int n, List<TermVariable> list, List<Term> list2) {
        Term term = QuantifierUtils.applyDualFiniteConnective(script, n, list2);
        HashMap<TermVariable, Result> hashMap = new HashMap<TermVariable, Result>();
        for (TermVariable termVariable : list) {
            Result result = (Result)new XnfScout(script, n, termVariable, null).transduce(term);
            hashMap.put(termVariable, result);
        }
        return hashMap;
    }

    public static int computeRecommendation(Script script, Set<TermVariable> set, Term[] termArray, int n) {
        int n2 = XnfScout.computeRecommendationDer(script, set, termArray, n);
        if (n2 == -1) {
            n2 = XnfScout.computeRecommendationEliminable(script, set, termArray, n);
        }
        return n2;
    }

    public static int computeRecommendation(Script script, Set<TermVariable> set, Term[] termArray, int n, Function<Result, Double> function) {
        ArrayList<Double> arrayList = new ArrayList<Double>(termArray.length);
        int n2 = 0;
        while (n2 < termArray.length) {
            arrayList.add(null);
            Term term = termArray[n2];
            if (QuantifierUtils.isCorrespondingFiniteJunction(n, term)) {
                arrayList.set(n2, 0.0);
                for (TermVariable termVariable : set) {
                    Result result = (Result)new XnfScout(script, n, termVariable, null).transduce(term);
                    double d = function.apply(result);
                    arrayList.set(n2, (Double)arrayList.get(n2) + d);
                }
            }
            ++n2;
        }
        n2 = -1;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            if (arrayList.get(n3) != null && (Double)arrayList.get(n3) > 0.0) {
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    public static int computeRecommendationDer(Script script, Set<TermVariable> set, Term[] termArray, int n) {
        return XnfScout.computeRecommendation(script, set, termArray, n, result -> result.computeDerRatio());
    }

    public static int computeRecommendationEliminable(Script script, Set<TermVariable> set, Term[] termArray, int n) {
        return XnfScout.computeRecommendation(script, set, termArray, n, result -> result.computeEliminableRatio());
    }

    public static int computeRecommendation2(Script script, Set<TermVariable> set, Term[] termArray, int n) {
        int n2;
        TermVariable termVariable = XnfScout.selectBestEliminatee(script, n, new ArrayList<TermVariable>(set), Arrays.asList(termArray));
        int n3 = XnfScout.computeRecommendationDer(script, Collections.singleton(termVariable), termArray, n);
        if (n3 == -1) {
            n3 = XnfScout.computeRecommendationEliminable(script, Collections.singleton(termVariable), termArray, n);
        }
        if (n3 != (n2 = XnfScout.computeRecommendation(script, set, termArray, n))) {
            termVariable.toString();
        }
        return n3;
    }

    public static enum Adk {
        ATOM,
        DISJUNCTION,
        CONJUNCTION;

    }

    public static enum Occurrence {
        DER,
        ELIMINABLE,
        OTHER_OCCURRENCE,
        ABSENT;

    }

    public static class Result
    implements Comparable<Result> {
        private final Adk mAdk;
        private final boolean mAtLeastOneNonInvolvedCorrespondingJunct;
        private final double mDerCorrespondingJuncts;
        private final double mEliminableCorrespondingJuncts;
        private final double mOccurringCorrespondingJuncts;

        public Result(Adk adk, double d, double d2, double d3, boolean bl) {
            this.mAdk = adk;
            this.mAtLeastOneNonInvolvedCorrespondingJunct = bl;
            this.mDerCorrespondingJuncts = d;
            this.mEliminableCorrespondingJuncts = d2;
            this.mOccurringCorrespondingJuncts = d3;
        }

        public Adk getAdk() {
            return this.mAdk;
        }

        public boolean isAtLeastOneNonInvolvedCorrespondingJunct() {
            return this.mAtLeastOneNonInvolvedCorrespondingJunct;
        }

        public double getDerCorrespondingJuncts() {
            return this.mDerCorrespondingJuncts;
        }

        public double getEliminableCorrespondingJuncts() {
            return this.mEliminableCorrespondingJuncts;
        }

        public double getOccurringCorrespondingJuncts() {
            return this.mOccurringCorrespondingJuncts;
        }

        public String toString() {
            return String.format("%s: %s DER, %s eliminable, %s other occurring, %s non-involved", new Object[]{this.mAdk, this.mDerCorrespondingJuncts, this.mEliminableCorrespondingJuncts, this.mOccurringCorrespondingJuncts, this.mAtLeastOneNonInvolvedCorrespondingJunct});
        }

        @Override
        public int compareTo(Result result) {
            int n = Double.compare(this.getOccurringCorrespondingJuncts(), result.getOccurringCorrespondingJuncts());
            if (n != 0) {
                return n;
            }
            n = Double.compare(this.getEliminableCorrespondingJuncts(), result.getEliminableCorrespondingJuncts());
            if (n != 0) {
                return n;
            }
            n = Double.compare(this.getDerCorrespondingJuncts(), result.getDerCorrespondingJuncts());
            if (n != 0) {
                return n;
            }
            n = Boolean.compare(this.isAtLeastOneNonInvolvedCorrespondingJunct(), result.isAtLeastOneNonInvolvedCorrespondingJunct());
            if (n != 0) {
                return n;
            }
            return 0;
        }

        public Double computeDerRatio() {
            double d = this.getDerCorrespondingJuncts() + this.getEliminableCorrespondingJuncts() + this.getOccurringCorrespondingJuncts() + (double)(this.isAtLeastOneNonInvolvedCorrespondingJunct() ? 1 : 0);
            double d2 = this.getDerCorrespondingJuncts() / d;
            return d2;
        }

        public Double computeEliminableRatio() {
            double d = this.getDerCorrespondingJuncts() + this.getEliminableCorrespondingJuncts() + this.getOccurringCorrespondingJuncts() + (double)(this.isAtLeastOneNonInvolvedCorrespondingJunct() ? 1 : 0);
            double d2 = this.getEliminableCorrespondingJuncts() / d;
            return d2;
        }
    }
}

