/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Polynomial {
    private final Map<Map<Term, Integer>, Rational> mSummands = new LinkedHashMap<Map<Term, Integer>, Rational>();

    public Polynomial() {
    }

    public Polynomial(Term term) {
        this();
        Term[] termArray = term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("+") ? ((ApplicationTerm)term).getParameters() : new Term[]{term};
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Term term2 = termArray2[n2];
            Rational rational = Rational.ONE;
            Term[] termArray3 = term2 instanceof ApplicationTerm && ((ApplicationTerm)term2).getFunction().getName() == "*" ? ((ApplicationTerm)term2).getParameters() : new Term[]{term2};
            Map<Object, Object> map = new LinkedHashMap();
            Term[] termArray4 = termArray3;
            int n3 = termArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                object = termArray4[n4];
                Rational rational2 = Polynomial.parseConstant((Term)object);
                if (rational2 != null) {
                    rational = rational.mul(rational2);
                } else {
                    Integer n5;
                    if (object instanceof ApplicationTerm && ((ApplicationTerm)object).getFunction().getName() == "to_real") {
                        object = ((ApplicationTerm)object).getParameters()[0];
                    }
                    map.put(object, (n5 = (Integer)map.get(object)) == null ? 1 : n5 + 1);
                }
                ++n4;
            }
            if (map.isEmpty()) {
                map = Collections.emptyMap();
            } else if (map.size() == 1) {
                object = map.entrySet().iterator().next();
                map = Collections.singletonMap((Term)object.getKey(), (Integer)object.getValue());
            }
            object = this.mSummands.get(map);
            this.mSummands.put(map, object == null ? rational : object.add(rational));
            ++n2;
        }
    }

    public static boolean isToReal(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("to_real");
    }

    private static Rational convertConstantTerm(ConstantTerm constantTerm) {
        Rational rational;
        Object object = constantTerm.getValue();
        if (object instanceof BigInteger) {
            rational = Rational.valueOf((BigInteger)((BigInteger)object), (BigInteger)BigInteger.ONE);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.scale() <= 0) {
                BigInteger bigInteger = bigDecimal.toBigInteger();
                rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
            } else {
                BigInteger bigInteger = bigDecimal.unscaledValue();
                BigInteger bigInteger2 = BigInteger.TEN.pow(bigDecimal.scale());
                rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)bigInteger2);
            }
        } else if (object instanceof Rational) {
            rational = (Rational)object;
        } else {
            return null;
        }
        return rational;
    }

    private static Rational parseConstantWithoutFraction(Term term) {
        boolean bl = false;
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("-") && ((ApplicationTerm)term).getParameters().length == 1) {
            term = ((ApplicationTerm)term).getParameters()[0];
            bl = true;
        }
        if (Polynomial.isToReal(term)) {
            term = ((ApplicationTerm)term).getParameters()[0];
        }
        if (term instanceof ConstantTerm) {
            Rational rational = Polynomial.convertConstantTerm((ConstantTerm)term);
            if (bl && rational != null) {
                rational = rational.negate();
            }
            return rational;
        }
        return null;
    }

    public static Rational parseConstant(Term term) {
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("/")) {
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            Rational rational = Polynomial.parseConstantWithoutFraction(termArray[0]);
            Rational rational2 = Polynomial.parseConstantWithoutFraction(termArray[1]);
            if (rational == null || rational2 == null || rational2.signum() <= 0 || !rational.isIntegral() || !rational2.isIntegral()) {
                return null;
            }
            return rational.div(rational2);
        }
        return Polynomial.parseConstantWithoutFraction(term);
    }

    public void mul(Rational rational) {
        if (rational == Rational.ZERO) {
            this.mSummands.clear();
            return;
        }
        for (Map.Entry<Map<Term, Integer>, Rational> entry : this.mSummands.entrySet()) {
            entry.setValue(entry.getValue().mul(rational));
        }
    }

    public Map<Term, Integer> mulMonomials(Map<Term, Integer> map, Map<Term, Integer> map2) {
        LinkedHashMap<Term, Integer> linkedHashMap = new LinkedHashMap<Term, Integer>();
        linkedHashMap.putAll(map);
        Iterator<Map.Entry<Term, Integer>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer n;
            Map.Entry<Term, Integer> entry;
            linkedHashMap.put(entry.getKey(), (n = (Integer)linkedHashMap.get((entry = iterator.next()).getKey())) == null ? entry.getValue() : n + entry.getValue());
        }
        return linkedHashMap;
    }

    public void mul(Polynomial polynomial) {
        if (polynomial.isConstant()) {
            this.mul(polynomial.getConstant());
            return;
        }
        if (this.isConstant()) {
            Rational rational = this.getConstant();
            this.mSummands.clear();
            this.add(rational, polynomial);
            return;
        }
        Polynomial polynomial2 = new Polynomial();
        for (Map.Entry<Map<Term, Integer>, Rational> entry : polynomial.mSummands.entrySet()) {
            for (Map.Entry<Map<Term, Integer>, Rational> entry2 : this.mSummands.entrySet()) {
                Map<Term, Integer> map = this.mulMonomials(entry.getKey(), entry2.getKey());
                polynomial2.add(entry.getValue().mul(entry2.getValue()), map);
            }
        }
        this.mSummands.clear();
        this.mSummands.putAll(polynomial2.mSummands);
    }

    public void add(Rational rational, Map<Term, Integer> map) {
        Rational rational2;
        Rational rational3 = this.mSummands.get(map);
        Rational rational4 = rational2 = rational3 == null ? rational : rational3.add(rational);
        if (rational2 == Rational.ZERO) {
            this.mSummands.remove(map);
        } else {
            this.mSummands.put(map, rational2);
        }
    }

    public void add(Rational rational) {
        this.add(rational, Collections.emptyMap());
    }

    public void add(Rational rational, Polynomial polynomial) {
        for (Map.Entry<Map<Term, Integer>, Rational> entry : polynomial.mSummands.entrySet()) {
            this.add(rational.mul(entry.getValue()), entry.getKey());
        }
    }

    public void add(Rational rational, Term term) {
        this.add(rational, new Polynomial(term));
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty() || this.mSummands.size() == 1 && this.mSummands.keySet().iterator().next().isEmpty();
    }

    public Rational getConstant() {
        Rational rational = this.mSummands.get(Collections.emptyMap());
        return rational == null ? Rational.ZERO : rational;
    }

    public boolean isZero() {
        return this.mSummands.isEmpty();
    }

    public Rational getGcd() {
        Rational rational = Rational.ZERO;
        for (Map.Entry<Map<Term, Integer>, Rational> entry : this.mSummands.entrySet()) {
            if (entry.getKey().isEmpty()) continue;
            rational = rational.gcd(entry.getValue().abs());
        }
        return rational;
    }

    public Map<Map<Term, Integer>, Rational> getSummands() {
        return this.mSummands;
    }

    public Term toTerm(Sort sort) {
        assert (sort.isNumericSort());
        if (this.mSummands.isEmpty()) {
            return Rational.ZERO.toTerm(sort);
        }
        Theory theory = sort.getTheory();
        int n = this.mSummands.size();
        Term[] termArray = new Term[n];
        int n2 = 0;
        for (Map.Entry<Map<Term, Integer>, Rational> entry : this.mSummands.entrySet()) {
            Map<Term, Integer> map = entry.getKey();
            ArrayList<Term> arrayList = new ArrayList<Term>();
            arrayList.add(entry.getValue().toTerm(sort));
            for (Map.Entry<Term, Integer> entry2 : map.entrySet()) {
                int n3 = entry2.getValue();
                assert (n3 > 0);
                int n4 = 0;
                while (n4 < n3) {
                    arrayList.add(entry2.getKey());
                    ++n4;
                }
            }
            termArray[n2++] = arrayList.size() == 1 ? (Term)arrayList.get(0) : theory.term("*", arrayList.toArray(new Term[arrayList.size()]));
        }
        return n == 1 ? termArray[0] : theory.term("+", termArray);
    }

    public String toString() {
        if (this.mSummands.isEmpty()) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Map.Entry<Map<Term, Integer>, Rational> entry : this.mSummands.entrySet()) {
            stringBuilder.append(string);
            stringBuilder.append(entry.getValue());
            for (Map.Entry<Term, Integer> entry2 : entry.getKey().entrySet()) {
                int n = entry2.getValue();
                assert (n > 0);
                String string2 = " * " + String.valueOf(entry2.getKey());
                int n2 = 0;
                while (n2 < entry2.getValue()) {
                    stringBuilder.append(string2);
                    ++n2;
                }
            }
            string = " + ";
        }
        return stringBuilder.toString();
    }

    public boolean isAllIntSummands() {
        for (Map<Term, Integer> map : this.mSummands.keySet()) {
            for (Term term : map.keySet()) {
                if (term.getSort().getName().equals("Int")) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Polynomial)) {
            return false;
        }
        Polynomial polynomial = (Polynomial)object;
        return this.mSummands.equals(polynomial.mSummands);
    }

    public int hashCode() {
        return this.mSummands.hashCode();
    }
}

