/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;

public class ProofRules {
    public static final String RES = "res";
    public static final String ASSUME = "assume";
    public static final String AXIOM = "axiom";
    public static final String ORACLE = "oracle";
    public static final String FALSEE = "false-";
    public static final String TRUEI = "true+";
    public static final String NOTI = "not+";
    public static final String NOTE = "not-";
    public static final String ORI = "or+";
    public static final String ORE = "or-";
    public static final String ANDI = "and+";
    public static final String ANDE = "and-";
    public static final String IMPI = "=>+";
    public static final String IMPE = "=>-";
    public static final String IFFI1 = "=+1";
    public static final String IFFI2 = "=+2";
    public static final String IFFE1 = "=-1";
    public static final String IFFE2 = "=-2";
    public static final String XORI = "xor+";
    public static final String XORE = "xor-";
    public static final String FORALLI = "forall+";
    public static final String FORALLE = "forall-";
    public static final String EXISTSI = "exists+";
    public static final String EXISTSE = "exists-";
    public static final String EQI = "=+";
    public static final String EQE = "=-";
    public static final String DISTINCTI = "distinct+";
    public static final String DISTINCTE = "distinct-";
    public static final String ITE1 = "ite1";
    public static final String ITE2 = "ite2";
    public static final String REFL = "refl";
    public static final String SYMM = "symm";
    public static final String TRANS = "trans";
    public static final String CONG = "cong";
    public static final String EXPAND = "expand";
    public static final String DELANNOT = "del!";
    public static final String DIVISIBLEDEF = "divisible-def";
    public static final String GTDEF = ">def";
    public static final String GEQDEF = ">=def";
    public static final String TRICHOTOMY = "trichotomy";
    public static final String TOTAL = "total";
    public static final String TOTALINT = "total-int";
    public static final String FARKAS = "farkas";
    public static final String MULPOS = "mulpos";
    public static final String TOINTHIGH = "to_int-high";
    public static final String TOINTLOW = "to_int-low";
    public static final String MINUSDEF = "-def";
    public static final String DIVIDEDEF = "/def";
    public static final String POLYADD = "poly+";
    public static final String POLYMUL = "poly*";
    public static final String TOREALDEF = "to_real-def";
    public static final String DIVLOW = "div-low";
    public static final String DIVHIGH = "div-high";
    public static final String MODDEF = "mod-def";
    public static final String SELECTSTORE1 = "selectstore1";
    public static final String SELECTSTORE2 = "selectstore2";
    public static final String EXTDIFF = "extdiff";
    public static final String CONST = "const";
    public static final String DT_PROJECT = "dt-project";
    public static final String DT_CONS = "dt-cons";
    public static final String DT_TESTI = "dt-test+";
    public static final String DT_TESTE = "dt-test-";
    public static final String DT_EXHAUST = "dt-exhaust";
    public static final String DT_ACYCLIC = "dt-acyclic";
    public static final String DT_MATCH = "dt-match";
    public static final String PROOF = "Proof";
    public static final String CHOOSE = "choose";
    public static final String PREFIX = "..";
    public static final String ANNOT_VALUES = ":values";
    public static final String ANNOT_COEFFS = ":coeffs";
    public static final String ANNOT_DIVISOR = ":divisor";
    public static final String ANNOT_POS = ":pos";
    public static final String ANNOT_UNIT = ":unit";
    public static final String ANNOT_DEFINE_FUN = ":define-fun";
    public static final String ANNOT_DECLARE_FUN = ":declare-fun";
    private final Theory mTheory;
    private final Term mAxiom;

    public ProofRules(Theory theory) {
        this.mTheory = theory;
        this.setupTheory();
        this.mAxiom = theory.term("..axiom", new Term[0]);
    }

    private void setupTheory() {
        Sort sort;
        Sort[] sortArray;
        if (this.mTheory.getDeclaredSorts().containsKey("..Proof")) {
            return;
        }
        if (this.mTheory.getLogic().isArray() && !this.mTheory.getFunctionFactories().containsKey("@diff")) {
            sortArray = this.mTheory.createSortVariables(new String[]{"Index", "Elem"});
            sort = this.mTheory.getSort("Array", sortArray);
            this.mTheory.declareInternalPolymorphicFunction("@diff", sortArray, new Sort[]{sort, sort}, sortArray[0], 64);
        }
        this.mTheory.declareInternalSort("..Proof", 0, 0);
        sortArray = this.mTheory.getSort("..Proof", new Sort[0]);
        sort = this.mTheory.getBooleanSort();
        Sort[] sortArray2 = this.mTheory.createSortVariables(new String[]{"X"});
        Sort[] sortArray3 = new Sort[]{sort};
        Sort[] sortArray4 = new Sort[]{};
        Sort[] sortArray5 = new Sort[]{this.mTheory.getSort("->", new Sort[]{sortArray2[0], sort})};
        this.mTheory.declareInternalFunction("..res", new Sort[]{sort, sortArray, sortArray}, (Sort)sortArray, 0);
        this.mTheory.declareInternalFunction("..axiom", sortArray4, (Sort)sortArray, 0);
        this.mTheory.declareInternalFunction("..assume", sortArray3, (Sort)sortArray, 0);
        this.mTheory.declareInternalPolymorphicFunction("..choose", sortArray2, sortArray5, sortArray2[0], 0);
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    private static boolean isKeyword(Object object) {
        return object instanceof String && ((String)object).charAt(0) == ':';
    }

    static Annotation[] convertSExprToAnnotation(Object[] objectArray) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        int n = 0;
        while (n < objectArray.length) {
            assert (ProofRules.isKeyword(objectArray[n]));
            String string = (String)objectArray[n];
            Object object = null;
            if (n + 1 < objectArray.length && !ProofRules.isKeyword(objectArray[n + 1])) {
                object = objectArray[++n];
            }
            arrayList.add(new Annotation(string, object));
            ++n;
        }
        return arrayList.toArray(new Annotation[arrayList.size()]);
    }

    static Object[] convertAnnotationsToSExpr(Annotation[] annotationArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Annotation[] annotationArray2 = annotationArray;
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray2[n2];
            arrayList.add(annotation.getKey());
            if (annotation.getValue() != null) {
                arrayList.add(annotation.getValue());
            }
            ++n2;
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public Term resolutionRule(Term term, Term term2, Term term3) {
        return this.mTheory.term("..res", new Term[]{term, term2, term3});
    }

    public Term asserted(Term term) {
        return this.mTheory.term("..assume", new Term[]{term});
    }

    public static Object[] convertProofLiteralsToAnnotation(ProofLiteral[] proofLiteralArray) {
        Object[] objectArray = new Object[2 * proofLiteralArray.length];
        int n = 0;
        while (n < proofLiteralArray.length) {
            objectArray[2 * n] = proofLiteralArray[n].getPolarity() ? "+" : "-";
            objectArray[2 * n + 1] = proofLiteralArray[n].getAtom();
            ++n;
        }
        return objectArray;
    }

    public static ProofLiteral[] proofLiteralsFromAnnotation(Object[] objectArray) {
        assert (objectArray.length % 2 == 0);
        ProofLiteral[] proofLiteralArray = new ProofLiteral[objectArray.length / 2];
        int n = 0;
        while (n < proofLiteralArray.length) {
            assert (objectArray[2 * n] == "+" || objectArray[2 * n] == "-");
            proofLiteralArray[n] = new ProofLiteral((Term)objectArray[2 * n + 1], objectArray[2 * n] == "+");
            ++n;
        }
        return proofLiteralArray;
    }

    public Term oracle(ProofLiteral[] proofLiteralArray, Annotation[] annotationArray) {
        Object[] objectArray = ProofRules.convertProofLiteralsToAnnotation(proofLiteralArray);
        return this.mTheory.annotatedTerm(this.annotate(":oracle", objectArray, annotationArray), this.mAxiom);
    }

    public Term choose(TermVariable termVariable, Term term) {
        Term term2 = this.mTheory.lambda(new TermVariable[]{termVariable}, term);
        return this.mTheory.term("..choose", new Term[]{term2});
    }

    public Term[] getSkolemVars(TermVariable[] termVariableArray, Term term, boolean bl) {
        Term[] termArray = new Term[termVariableArray.length];
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        int n = 0;
        while (n < termArray.length) {
            TermVariable[] termVariableArray2;
            Term term2 = term;
            if (n + 1 < termArray.length) {
                termVariableArray2 = new TermVariable[termArray.length - n - 1];
                System.arraycopy(termVariableArray, n + 1, termVariableArray2, 0, termVariableArray2.length);
                Term term3 = term2 = bl ? this.mTheory.forall(termVariableArray2, term2) : this.mTheory.exists(termVariableArray2, term2);
            }
            if (bl) {
                term2 = this.mTheory.term("not", new Term[]{term2});
            }
            if (n > 0) {
                termVariableArray2 = new TermVariable[n];
                Term[] termArray2 = new Term[n];
                System.arraycopy(termVariableArray, 0, termVariableArray2, 0, n);
                System.arraycopy(termArray, 0, termArray2, 0, n);
                term2 = formulaUnLet.unlet(this.mTheory.let(termVariableArray2, termArray2, term2));
            }
            termArray[n] = this.choose(termVariableArray[n], term2);
            ++n;
        }
        return termArray;
    }

    private Annotation[] annotate(String string, Object object, Annotation ... annotationArray) {
        Annotation[] annotationArray2 = new Annotation[annotationArray.length + 1];
        annotationArray2[0] = new Annotation(string, object);
        System.arraycopy(annotationArray, 0, annotationArray2, 1, annotationArray.length);
        return annotationArray2;
    }

    public Term trueIntro() {
        return this.mTheory.annotatedTerm(this.annotate(":true+", null, new Annotation[0]), this.mAxiom);
    }

    public Term falseElim() {
        return this.mTheory.annotatedTerm(this.annotate(":false-", null, new Annotation[0]), this.mAxiom);
    }

    public Term notIntro(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "not");
        return this.mTheory.annotatedTerm(this.annotate(":not+", term, new Annotation[0]), this.mAxiom);
    }

    public Term notElim(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "not");
        return this.mTheory.annotatedTerm(this.annotate(":not-", term, new Annotation[0]), this.mAxiom);
    }

    public Term orIntro(int n, Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "or");
        return this.mTheory.annotatedTerm(this.annotate(":or+", term, new Annotation(ANNOT_POS, (Object)n)), this.mAxiom);
    }

    public Term orElim(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "or");
        return this.mTheory.annotatedTerm(this.annotate(":or-", term, new Annotation[0]), this.mAxiom);
    }

    public Term andIntro(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "and");
        return this.mTheory.annotatedTerm(this.annotate(":and+", term, new Annotation[0]), this.mAxiom);
    }

    public Term andElim(int n, Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "and");
        return this.mTheory.annotatedTerm(this.annotate(":and-", term, new Annotation(ANNOT_POS, (Object)n)), this.mAxiom);
    }

    public Term impIntro(int n, Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "=>");
        return this.mTheory.annotatedTerm(this.annotate(":=>+", term, new Annotation(ANNOT_POS, (Object)n)), this.mAxiom);
    }

    public Term impElim(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "=>");
        return this.mTheory.annotatedTerm(this.annotate(":=>-", term, new Annotation[0]), this.mAxiom);
    }

    public Term iffIntro1(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "=" && ((ApplicationTerm)term).getParameters().length == 2 && ((ApplicationTerm)term).getParameters()[0].getSort().getName() == "Bool");
        return this.mTheory.annotatedTerm(this.annotate(":=+1", term, new Annotation[0]), this.mAxiom);
    }

    public Term iffIntro2(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "=" && ((ApplicationTerm)term).getParameters().length == 2 && ((ApplicationTerm)term).getParameters()[0].getSort().getName() == "Bool");
        return this.mTheory.annotatedTerm(this.annotate(":=+2", term, new Annotation[0]), this.mAxiom);
    }

    public Term iffElim1(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "=" && ((ApplicationTerm)term).getParameters().length == 2 && ((ApplicationTerm)term).getParameters()[0].getSort().getName() == "Bool");
        return this.mTheory.annotatedTerm(this.annotate(":=-1", term, new Annotation[0]), this.mAxiom);
    }

    public Term iffElim2(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "=" && ((ApplicationTerm)term).getParameters().length == 2 && ((ApplicationTerm)term).getParameters()[0].getSort().getName() == "Bool");
        return this.mTheory.annotatedTerm(this.annotate(":=-2", term, new Annotation[0]), this.mAxiom);
    }

    private Term xorAxiom(String string, Term[] ... termArray) {
        assert (ProofRules.checkXorParams(termArray));
        return this.mTheory.annotatedTerm(new Annotation[]{new Annotation(string, (Object)termArray)}, this.mAxiom);
    }

    public Term xorIntro(Term[] termArray, Term[] termArray2, Term[] termArray3) {
        return this.xorAxiom(":xor+", termArray, termArray2, termArray3);
    }

    public Term xorElim(Term[] termArray, Term[] termArray2, Term[] termArray3) {
        return this.xorAxiom(":xor-", termArray, termArray2, termArray3);
    }

    public Term forallIntro(QuantifiedFormula quantifiedFormula) {
        assert (quantifiedFormula.getQuantifier() == 1);
        return this.mTheory.annotatedTerm(this.annotate(":forall+", quantifiedFormula, new Annotation[0]), this.mAxiom);
    }

    public Term forallElim(Term[] termArray, QuantifiedFormula quantifiedFormula) {
        assert (quantifiedFormula.getQuantifier() == 1);
        return this.mTheory.annotatedTerm(this.annotate(":forall-", quantifiedFormula, new Annotation(ANNOT_VALUES, (Object)termArray)), this.mAxiom);
    }

    public Term existsIntro(Term[] termArray, QuantifiedFormula quantifiedFormula) {
        assert (quantifiedFormula.getQuantifier() == 0);
        return this.mTheory.annotatedTerm(this.annotate(":exists+", quantifiedFormula, new Annotation(ANNOT_VALUES, (Object)termArray)), this.mAxiom);
    }

    public Term existsElim(QuantifiedFormula quantifiedFormula) {
        assert (quantifiedFormula.getQuantifier() == 0);
        return this.mTheory.annotatedTerm(this.annotate(":exists-", quantifiedFormula, new Annotation[0]), this.mAxiom);
    }

    public Term equalsIntro(Term term) {
        assert (((ApplicationTerm)term).getFunction().getName() == "=");
        return this.mTheory.annotatedTerm(this.annotate(":=+", term, new Annotation[0]), this.mAxiom);
    }

    public Term equalsElim(int n, int n2, Term term) {
        assert (((ApplicationTerm)term).getFunction().getName() == "=");
        assert (n >= 0 && n < ((ApplicationTerm)term).getParameters().length);
        assert (n2 >= 0 && n2 < ((ApplicationTerm)term).getParameters().length);
        return this.mTheory.annotatedTerm(this.annotate(":=-", term, new Annotation(ANNOT_POS, (Object)new Integer[]{n, n2})), this.mAxiom);
    }

    public Term distinctIntro(Term term) {
        assert (((ApplicationTerm)term).getFunction().getName() == "distinct");
        return this.mTheory.annotatedTerm(this.annotate(":distinct+", term, new Annotation[0]), this.mAxiom);
    }

    public Term distinctElim(int n, int n2, Term term) {
        assert (((ApplicationTerm)term).getFunction().getName() == "distinct");
        assert (n >= 0 && n < ((ApplicationTerm)term).getParameters().length);
        assert (n2 >= 0 && n2 < ((ApplicationTerm)term).getParameters().length);
        return this.mTheory.annotatedTerm(this.annotate(":distinct-", term, new Annotation(ANNOT_POS, (Object)new Integer[]{n, n2})), this.mAxiom);
    }

    public Term refl(Term term) {
        return this.mTheory.annotatedTerm(this.annotate(":refl", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term symm(Term term, Term term2) {
        return this.mTheory.annotatedTerm(this.annotate(":symm", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term trans(Term ... termArray) {
        assert (termArray.length > 2);
        return this.mTheory.annotatedTerm(this.annotate(":trans", termArray, new Annotation[0]), this.mAxiom);
    }

    public Term cong(FunctionSymbol functionSymbol, Term[] termArray, Term[] termArray2) {
        assert (termArray.length == termArray2.length);
        Annotation[] annotationArray = new Annotation[]{new Annotation(":cong", (Object)new Object[]{functionSymbol, termArray, termArray2})};
        return this.mTheory.annotatedTerm(annotationArray, this.mAxiom);
    }

    public Term cong(Term term, Term term2) {
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
        assert (applicationTerm.getFunction() == applicationTerm2.getFunction());
        return this.cong(applicationTerm.getFunction(), applicationTerm.getParameters(), applicationTerm2.getParameters());
    }

    public Term expand(Term term) {
        Annotation[] annotationArray = new Annotation[]{new Annotation(":expand", (Object)new Object[]{((ApplicationTerm)term).getFunction(), ((ApplicationTerm)term).getParameters()})};
        return this.mTheory.annotatedTerm(annotationArray, this.mAxiom);
    }

    public Term ite1(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "ite");
        return this.mTheory.annotatedTerm(this.annotate(":ite1", term, new Annotation[0]), this.mAxiom);
    }

    public Term ite2(Term term) {
        assert (term instanceof TermVariable || ((ApplicationTerm)term).getFunction().getName() == "ite");
        return this.mTheory.annotatedTerm(this.annotate(":ite2", term, new Annotation[0]), this.mAxiom);
    }

    public Term delAnnot(Term term) {
        Term term2 = ((AnnotatedTerm)term).getSubterm();
        Object[] objectArray = ProofRules.convertAnnotationsToSExpr(((AnnotatedTerm)term).getAnnotations());
        return this.mTheory.annotatedTerm(this.annotate(":del!", new Object[]{term2, objectArray}, new Annotation[0]), this.mAxiom);
    }

    public Term divisible(BigInteger bigInteger, Term term) {
        assert (bigInteger.signum() > 0);
        assert (term.getSort().getName().equals("Int"));
        return this.mTheory.annotatedTerm(this.annotate(":divisible-def", new Term[]{term}, new Annotation(ANNOT_DIVISOR, (Object)bigInteger)), this.mAxiom);
    }

    public Term gtDef(Term term) {
        assert (((ApplicationTerm)term).getFunction().getName() == ">");
        return this.mTheory.annotatedTerm(this.annotate(":>def", ((ApplicationTerm)term).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term geqDef(Term term) {
        assert (((ApplicationTerm)term).getFunction().getName() == ">=");
        return this.mTheory.annotatedTerm(this.annotate(":>=def", ((ApplicationTerm)term).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term trichotomy(Term term, Term term2) {
        return this.mTheory.annotatedTerm(this.annotate(":trichotomy", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term total(Term term, Term term2) {
        return this.mTheory.annotatedTerm(this.annotate(":total", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term totalInt(Term term, BigInteger bigInteger) {
        return this.mTheory.annotatedTerm(this.annotate(":total-int", new Object[]{term, bigInteger}, new Annotation[0]), this.mAxiom);
    }

    public Term farkas(Term[] termArray, BigInteger[] bigIntegerArray) {
        return this.mTheory.annotatedTerm(this.annotate(":farkas", termArray, new Annotation(ANNOT_COEFFS, (Object)bigIntegerArray)), this.mAxiom);
    }

    public Term mulPos(Term[] termArray) {
        return this.mTheory.annotatedTerm(this.annotate(":mulpos", termArray, new Annotation[0]), this.mAxiom);
    }

    public Term polyAdd(Term term, Term term2) {
        return this.mTheory.annotatedTerm(this.annotate(":poly+", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term polyMul(Term term, Term term2) {
        return this.mTheory.annotatedTerm(this.annotate(":poly*", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term toRealDef(Term term) {
        assert (ProofRules.isApplication("to_real", term));
        return this.mTheory.annotatedTerm(this.annotate(":to_real-def", ((ApplicationTerm)term).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term divideDef(Term term) {
        assert (ProofRules.isApplication("/", term));
        return this.mTheory.annotatedTerm(this.annotate(":/def", ((ApplicationTerm)term).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term minusDef(Term term) {
        assert (ProofRules.isApplication("-", term));
        return this.mTheory.annotatedTerm(this.annotate(":-def", ((ApplicationTerm)term).getParameters(), new Annotation[0]), this.mAxiom);
    }

    public Term toIntLow(Term term) {
        assert (term.getSort().getSortSymbol().getName().equals("Real"));
        return this.mTheory.annotatedTerm(this.annotate(":to_int-low", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term toIntHigh(Term term) {
        assert (term.getSort().getSortSymbol().getName().equals("Real"));
        return this.mTheory.annotatedTerm(this.annotate(":to_int-high", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term divLow(Term term, Term term2) {
        assert (term.getSort().getSortSymbol().getName().equals("Int"));
        assert (term2.getSort() == term.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":div-low", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term divHigh(Term term, Term term2) {
        assert (term.getSort().getSortSymbol().getName().equals("Int"));
        assert (term2.getSort() == term.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":div-high", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term modDef(Term term, Term term2) {
        assert (term.getSort().getSortSymbol().getName().equals("Int"));
        assert (term2.getSort() == term.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":mod-def", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term selectStore1(Term term, Term term2, Term term3) {
        assert (term.getSort().getSortSymbol().getName().equals("Array"));
        assert (term.getSort().getArguments()[0] == term2.getSort());
        assert (term.getSort().getArguments()[1] == term3.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":selectstore1", new Term[]{term, term2, term3}, new Annotation[0]), this.mAxiom);
    }

    public Term selectStore2(Term term, Term term2, Term term3, Term term4) {
        assert (term.getSort().getSortSymbol().getName().equals("Array"));
        assert (term.getSort().getArguments()[0] == term2.getSort());
        assert (term.getSort().getArguments()[1] == term3.getSort());
        assert (term.getSort().getArguments()[0] == term4.getSort());
        return this.mTheory.annotatedTerm(this.annotate(":selectstore2", new Term[]{term, term2, term3, term4}, new Annotation[0]), this.mAxiom);
    }

    public Term extDiff(Term term, Term term2) {
        assert (term.getSort() == term2.getSort());
        assert (term.getSort().getSortSymbol().getName().equals("Array"));
        return this.mTheory.annotatedTerm(this.annotate(":extdiff", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term constArray(Term term, Term term2) {
        return this.mTheory.annotatedTerm(this.annotate(":const", new Term[]{term, term2}, new Annotation[0]), this.mAxiom);
    }

    public Term defineFun(FunctionSymbol functionSymbol, Term term, Term term2) {
        return this.mTheory.annotatedTerm(new Annotation[]{new Annotation(ANNOT_DEFINE_FUN, (Object)new Object[]{functionSymbol, term})}, term2);
    }

    public Term declareFun(FunctionSymbol functionSymbol, Term term) {
        return this.mTheory.annotatedTerm(new Annotation[]{new Annotation(ANNOT_DECLARE_FUN, (Object)new Object[]{functionSymbol})}, term);
    }

    public Term dtProject(Term term) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-project", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term dtCons(Term term) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-cons", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term dtTestI(Term term) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-test+", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term dtTestE(String string, Term term) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-test-", new Object[]{string, term}, new Annotation[0]), this.mAxiom);
    }

    public Term dtExhaust(Term term) {
        assert (term.getSort().getSortSymbol() instanceof DataType);
        return this.mTheory.annotatedTerm(this.annotate(":dt-exhaust", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public Term dtAcyclic(Term term, int[] nArray) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-acyclic", new Object[]{term, nArray}, new Annotation[0]), this.mAxiom);
    }

    public Term dtMatch(Term term) {
        return this.mTheory.annotatedTerm(this.annotate(":dt-match", new Term[]{term}, new Annotation[0]), this.mAxiom);
    }

    public static void printProof(Appendable appendable, Term term) {
        new PrintProof().append(appendable, term);
    }

    private static boolean isApplication(String string, Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
            return functionSymbol.isIntern() && functionSymbol.getName().equals(string);
        }
        return false;
    }

    public static boolean checkPolyAdd(Term term, Term term2) {
        if (!ProofRules.isApplication("+", term)) {
            return false;
        }
        Polynomial polynomial = new Polynomial();
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term3 = termArray[n2];
            polynomial.add(Rational.ONE, term3);
            ++n2;
        }
        polynomial.add(Rational.MONE, term2);
        return polynomial.isZero();
    }

    public static boolean checkPolyMul(Term term, Term term2) {
        if (!ProofRules.isApplication("*", term)) {
            return false;
        }
        Polynomial polynomial = new Polynomial();
        polynomial.add(Rational.ONE);
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term3 = termArray[n2];
            polynomial.mul(new Polynomial(term3));
            ++n2;
        }
        polynomial.add(Rational.MONE, term2);
        if (!polynomial.isZero()) {
            System.err.println("STOP");
        }
        return polynomial.isZero();
    }

    private static Term computeFactorToReal(Term term) {
        if (term instanceof ConstantTerm && ((ConstantTerm)term).getValue() instanceof Rational) {
            return ((Rational)((ConstantTerm)term).getValue()).toTerm(term.getTheory().getSort("Real", new Sort[0]));
        }
        return term.getTheory().term("to_real", new Term[]{term});
    }

    private static Term computeMonomialToReal(Term term) {
        if (ProofRules.isApplication("*", term)) {
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            Term[] termArray2 = new Term[termArray.length];
            int n = 0;
            while (n < termArray.length) {
                termArray2[n] = ProofRules.computeFactorToReal(termArray[n]);
                ++n;
            }
            return term.getTheory().term("*", termArray2);
        }
        return ProofRules.computeFactorToReal(term);
    }

    public static Term computePolyToReal(Term term) {
        if (ProofRules.isApplication("+", term)) {
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            Term[] termArray2 = new Term[termArray.length];
            int n = 0;
            while (n < termArray.length) {
                termArray2[n] = ProofRules.computeMonomialToReal(termArray[n]);
                ++n;
            }
            return term.getTheory().term("+", termArray2);
        }
        return ProofRules.computeMonomialToReal(term);
    }

    public static Term computePolyMinus(Term term) {
        assert (ProofRules.isApplication("-", term));
        Theory theory = term.getTheory();
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        Term term2 = Rational.MONE.toTerm(term.getSort());
        if (termArray.length == 1) {
            return theory.term("*", new Term[]{term2, termArray[0]});
        }
        Term[] termArray2 = new Term[termArray.length];
        termArray2[0] = termArray[0];
        int n = 1;
        while (n < termArray.length) {
            termArray2[n] = theory.term("*", new Term[]{term2, termArray[n]});
            ++n;
        }
        return theory.term("+", termArray2);
    }

    public static boolean checkFarkas(Term[] termArray, BigInteger[] bigIntegerArray) {
        if (termArray.length != bigIntegerArray.length) {
            return false;
        }
        Polynomial polynomial = new Polynomial();
        boolean bl = false;
        int n = 0;
        while (n < termArray.length) {
            if (bigIntegerArray[n].signum() != 1) {
                return false;
            }
            if (!(ProofRules.isApplication("<", termArray[n]) || ProofRules.isApplication("<=", termArray[n]) || ProofRules.isApplication("=", termArray[n]))) {
                return false;
            }
            ApplicationTerm applicationTerm = (ApplicationTerm)termArray[n];
            Term[] termArray2 = applicationTerm.getParameters();
            if (termArray2.length != 2) {
                return false;
            }
            if (applicationTerm.getFunction().getName() == "<") {
                bl = true;
            }
            Rational rational = Rational.valueOf((BigInteger)bigIntegerArray[n], (BigInteger)BigInteger.ONE);
            polynomial.add(rational, termArray2[0]);
            polynomial.add(rational.negate(), termArray2[1]);
            ++n;
        }
        n = polynomial.isConstant() && polynomial.getConstant().signum() >= (bl ? 0 : 1) ? 1 : 0;
        return n != 0;
    }

    public static boolean checkMulPos(Term[] termArray) {
        Polynomial polynomial = new Polynomial();
        polynomial.add(Rational.ONE);
        boolean bl = true;
        int n = 0;
        while (n < termArray.length) {
            ApplicationTerm applicationTerm;
            Term[] termArray2;
            if (!(ProofRules.isApplication("<", termArray[n]) || ProofRules.isApplication("<=", termArray[n]) || ProofRules.isApplication("=", termArray[n]))) {
                return false;
            }
            if (!ProofRules.isApplication("<", termArray[n])) {
                bl = false;
            }
            if ((termArray2 = (applicationTerm = (ApplicationTerm)termArray[n]).getParameters()).length != 2) {
                return false;
            }
            if (termArray2[0] != Rational.ZERO.toTerm(termArray2[0].getSort())) {
                return false;
            }
            if (n < termArray.length - 1) {
                polynomial.mul(new Polynomial(termArray2[1]));
            } else {
                if (!(ProofRules.isApplication("<=", termArray[n]) || bl && ProofRules.isApplication("<", termArray[n]))) {
                    return false;
                }
                polynomial.add(Rational.MONE, termArray2[1]);
            }
            ++n;
        }
        return polynomial.isZero();
    }

    public static boolean checkXorParams(Term[][] termArray) {
        assert (termArray.length == 3);
        HashSet<Term> hashSet = new HashSet<Term>();
        Term[][] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term[] termArray3;
            Term[] termArray4 = termArray3 = termArray2[n2];
            int n3 = termArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                Term term = termArray4[n4];
                if (hashSet.contains(term)) {
                    hashSet.remove(term);
                } else {
                    hashSet.add(term);
                }
                ++n4;
            }
            ++n2;
        }
        return hashSet.isEmpty();
    }

    public static boolean checkConstructorPath(Term term, int[] nArray) {
        if (nArray.length == 0) {
            return false;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (!applicationTerm.getFunction().isConstructor() || n3 < 0 || n3 >= applicationTerm.getParameters().length) {
                return false;
            }
            term = applicationTerm.getParameters()[n3];
            ++n2;
        }
        return true;
    }

    public static boolean isAxiom(Term term) {
        return term instanceof AnnotatedTerm && ProofRules.isApplication("..axiom", ((AnnotatedTerm)term).getSubterm());
    }

    public static boolean isOracle(Term term) {
        return ProofRules.isAxiom(term) && ((AnnotatedTerm)term).getAnnotations()[0].getKey().equals(":oracle");
    }

    public static boolean isProofRule(String string, Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals(PREFIX + string);
    }

    public static boolean isDefineFun(Term term) {
        return term instanceof AnnotatedTerm && ((AnnotatedTerm)term).getAnnotations()[0].getKey() == ANNOT_DEFINE_FUN;
    }

    public static boolean isDeclareFun(Term term) {
        return term instanceof AnnotatedTerm && ((AnnotatedTerm)term).getAnnotations()[0].getKey() == ANNOT_DECLARE_FUN;
    }

    public static boolean isProof(Term term) {
        return term.getSort().isInternal() && term.getSort().getName().equals("..Proof");
    }

    public static class PrintProof
    extends PrintTerm {
        public void walkTerm(Term term) {
            Annotation[] annotationArray;
            AnnotatedTerm annotatedTerm;
            block235: {
                block233: {
                    if (!(term instanceof AnnotatedTerm)) break block233;
                    annotatedTerm = (AnnotatedTerm)term;
                    annotationArray = annotatedTerm.getAnnotations();
                    if (annotationArray.length == 1 && annotationArray[0].getKey() == ProofRules.ANNOT_DEFINE_FUN) {
                        Object[] objectArray = (Object[])annotationArray[0].getValue();
                        assert (objectArray.length == 2);
                        FunctionSymbol functionSymbol = (FunctionSymbol)objectArray[0];
                        LambdaTerm lambdaTerm = (LambdaTerm)objectArray[1];
                        this.mTodo.add(")");
                        this.mTodo.add(annotatedTerm.getSubterm());
                        this.mTodo.add(" ");
                        this.mTodo.add(")");
                        this.mTodo.add(lambdaTerm.getSubterm());
                        this.mTodo.add(") ");
                        TermVariable[] termVariableArray = lambdaTerm.getVariables();
                        int n = termVariableArray.length - 1;
                        while (n >= 0) {
                            this.mTodo.add(")");
                            this.mTodo.add(termVariableArray[n].getSort());
                            this.mTodo.add(" ");
                            this.mTodo.add(termVariableArray[n]);
                            this.mTodo.add(n == 0 ? "(" : " (");
                            --n;
                        }
                        this.mTodo.add(" (");
                        this.mTodo.add(functionSymbol.getApplicationString());
                        this.mTodo.add("((" + annotationArray[0].getKey().substring(1) + " ");
                        return;
                    }
                    if (annotationArray.length == 1 && annotationArray[0].getKey() == ProofRules.ANNOT_DECLARE_FUN) {
                        Object[] objectArray = (Object[])annotationArray[0].getValue();
                        assert (objectArray.length == 1);
                        FunctionSymbol functionSymbol = (FunctionSymbol)objectArray[0];
                        this.mTodo.add(")");
                        this.mTodo.add(annotatedTerm.getSubterm());
                        this.mTodo.add(" ");
                        this.mTodo.add(")");
                        this.mTodo.add(functionSymbol.getReturnSort());
                        this.mTodo.add(") ");
                        Sort[] sortArray = functionSymbol.getParameterSorts();
                        int n = sortArray.length - 1;
                        while (n >= 0) {
                            this.mTodo.add(sortArray[n]);
                            if (n > 0) {
                                this.mTodo.add(" ");
                            }
                            --n;
                        }
                        this.mTodo.add(" (");
                        this.mTodo.add(functionSymbol.getApplicationString());
                        this.mTodo.add("((" + annotationArray[0].getKey().substring(1) + " ");
                        return;
                    }
                    if (!(annotatedTerm.getSubterm() instanceof ApplicationTerm) || ((ApplicationTerm)annotatedTerm.getSubterm()).getFunction().getName() != "..axiom") break block233;
                    switch (annotationArray[0].getKey()) {
                        case ":oracle": {
                            assert (annotationArray.length >= 1);
                            Object[] objectArray = (Object[])annotationArray[0].getValue();
                            this.mTodo.add(")");
                            int n = annotationArray.length - 1;
                            while (n >= 1) {
                                if (annotationArray[n].getValue() != null) {
                                    this.mTodo.add(annotationArray[n].getValue());
                                    this.mTodo.add(" ");
                                }
                                this.mTodo.add(annotationArray[n].getKey());
                                this.mTodo.add(" ");
                                --n;
                            }
                            this.mTodo.add(objectArray);
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":false-": 
                        case ":true+": {
                            assert (annotationArray.length == 1);
                            assert (annotationArray[0].getValue() == null);
                            this.mTodo.add(annotationArray[0].getKey().substring(1));
                            return;
                        }
                        case ":=+": 
                        case ":=+1": 
                        case ":=+2": 
                        case ":=-1": 
                        case ":=-2": 
                        case ":=>-": 
                        case ":or-": 
                        case ":and+": 
                        case ":ite1": 
                        case ":ite2": 
                        case ":not+": 
                        case ":not-": 
                        case ":distinct+": {
                            assert (annotationArray.length == 1);
                            Term term2 = (Term)annotationArray[0].getValue();
                            this.mTodo.add(")");
                            this.mTodo.add(term2);
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":dt-project": 
                        case ":div-high": 
                        case ":to_int-low": 
                        case ":selectstore1": 
                        case ":selectstore2": 
                        case ":mulpos": 
                        case ":mod-def": 
                        case ":div-low": 
                        case ":to_real-def": 
                        case ":dt-cons": 
                        case ":-def": 
                        case ":/def": 
                        case ":>def": 
                        case ":refl": 
                        case ":symm": 
                        case ":extdiff": 
                        case ":trichotomy": 
                        case ":to_int-high": 
                        case ":dt-exhaust": 
                        case ":>=def": 
                        case ":const": 
                        case ":poly*": 
                        case ":poly+": 
                        case ":total": 
                        case ":trans": 
                        case ":dt-match": 
                        case ":dt-test+": {
                            assert (annotationArray.length == 1);
                            Term[] termArray = (Term[])annotationArray[0].getValue();
                            this.mTodo.add(")");
                            int n = termArray.length - 1;
                            while (n >= 0) {
                                this.mTodo.add(termArray[n]);
                                this.mTodo.add(" ");
                                --n;
                            }
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1));
                            return;
                        }
                        case ":=>+": 
                        case ":or+": 
                        case ":and-": {
                            Term term3 = (Term)annotationArray[0].getValue();
                            assert (annotationArray.length == 2);
                            assert (annotationArray[1].getKey() == ProofRules.ANNOT_POS);
                            this.mTodo.add(")");
                            this.mTodo.add(term3);
                            this.mTodo.add(" ");
                            this.mTodo.add(annotationArray[1].getValue());
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":=-": 
                        case ":distinct-": {
                            Term term4 = (Term)annotationArray[0].getValue();
                            assert (annotationArray.length == 2);
                            assert (annotationArray[1].getKey() == ProofRules.ANNOT_POS);
                            Integer[] integerArray = (Integer[])annotationArray[1].getValue();
                            this.mTodo.add(")");
                            this.mTodo.add(term4);
                            this.mTodo.add(" ");
                            this.mTodo.add(String.valueOf(integerArray[0]) + " " + String.valueOf(integerArray[1]));
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":cong": {
                            assert (annotationArray.length == 1);
                            Object[] objectArray = (Object[])annotationArray[0].getValue();
                            assert (objectArray.length == 3);
                            FunctionSymbol functionSymbol = (FunctionSymbol)objectArray[0];
                            Term[] termArray = (Term[])objectArray[1];
                            Term[] termArray2 = (Term[])objectArray[2];
                            this.mTodo.add("))");
                            int n = termArray2.length - 1;
                            while (n >= 0) {
                                this.mTodo.add(termArray2[n]);
                                this.mTodo.add(" ");
                                --n;
                            }
                            this.mTodo.add(functionSymbol.getApplicationString());
                            this.mTodo.add(") (");
                            n = termArray.length - 1;
                            while (n >= 0) {
                                this.mTodo.add(termArray[n]);
                                this.mTodo.add(" ");
                                --n;
                            }
                            this.mTodo.add(functionSymbol.getApplicationString());
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " (");
                            return;
                        }
                        case ":xor+": 
                        case ":xor-": {
                            assert (annotationArray.length == 1);
                            Term[][] termArray = (Term[][])annotationArray[0].getValue();
                            assert (termArray.length == 3);
                            this.mTodo.add(")");
                            int n = 2;
                            while (n >= 0) {
                                this.mTodo.add(")");
                                int n2 = termArray[n].length - 1;
                                while (n2 >= 0) {
                                    this.mTodo.add(termArray[n][n2]);
                                    if (n2 > 0) {
                                        this.mTodo.add(" ");
                                    }
                                    --n2;
                                }
                                this.mTodo.add(" (");
                                --n;
                            }
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1));
                            return;
                        }
                        case ":expand": {
                            assert (annotationArray.length == 1);
                            Object[] objectArray = (Object[])annotationArray[0].getValue();
                            assert (objectArray.length == 2);
                            FunctionSymbol functionSymbol = (FunctionSymbol)objectArray[0];
                            Term[] termArray = (Term[])objectArray[1];
                            this.mTodo.add(")");
                            if (termArray.length > 0) {
                                this.mTodo.add(")");
                                int n = termArray.length - 1;
                                while (n >= 0) {
                                    this.mTodo.add(termArray[n]);
                                    this.mTodo.add(" ");
                                    --n;
                                }
                                this.mTodo.add(functionSymbol.getApplicationString());
                                this.mTodo.add("(");
                            } else {
                                this.mTodo.add(functionSymbol.getApplicationString());
                            }
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":exists+": 
                        case ":forall-": {
                            assert (annotationArray.length == 2);
                            Term term5 = (Term)annotationArray[0].getValue();
                            assert (annotationArray[1].getKey() == ProofRules.ANNOT_VALUES);
                            Term[] termArray = (Term[])annotationArray[1].getValue();
                            this.mTodo.add(")");
                            this.mTodo.add(term5);
                            this.mTodo.add(") ");
                            int n = termArray.length - 1;
                            while (n >= 0) {
                                this.mTodo.add(termArray[n]);
                                if (n > 0) {
                                    this.mTodo.add(" ");
                                }
                                --n;
                            }
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " (");
                            return;
                        }
                        case ":exists-": 
                        case ":forall+": {
                            assert (annotationArray.length == 1);
                            Term term6 = (Term)annotationArray[0].getValue();
                            this.mTodo.add(")");
                            this.mTodo.add(term6);
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":del!": {
                            this.mTodo.add("))");
                            assert (annotationArray.length == 1);
                            Object[] objectArray = (Object[])annotationArray[0].getValue();
                            assert (objectArray.length == 2);
                            Term term7 = (Term)objectArray[0];
                            Object[] objectArray2 = (Object[])objectArray[1];
                            int n = objectArray2.length - 1;
                            while (n >= 0) {
                                this.mTodo.addLast(objectArray2[n]);
                                this.mTodo.addLast(" ");
                                --n;
                            }
                            this.mTodo.addLast(term7);
                            this.mTodo.add("(del! (! ");
                            return;
                        }
                        case ":divisible-def": {
                            assert (annotationArray.length == 2);
                            Term[] termArray = (Term[])annotationArray[0].getValue();
                            assert (termArray.length == 1);
                            assert (annotationArray[1].getKey() == ProofRules.ANNOT_DIVISOR);
                            this.mTodo.add(")");
                            this.mTodo.add(annotationArray[1].getValue());
                            this.mTodo.add(" ");
                            int n = termArray.length - 1;
                            while (n >= 0) {
                                this.mTodo.add(termArray[n]);
                                this.mTodo.add(" ");
                                --n;
                            }
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1));
                            return;
                        }
                        case ":total-int": {
                            Object[] objectArray = (Object[])annotationArray[0].getValue();
                            BigInteger bigInteger = (BigInteger)objectArray[1];
                            Term term8 = (Term)objectArray[0];
                            assert (annotationArray.length == 1);
                            this.mTodo.add(")");
                            if (bigInteger.signum() < 0) {
                                this.mTodo.add("(- " + bigInteger.abs().toString() + ")");
                            } else {
                                this.mTodo.add(bigInteger);
                            }
                            this.mTodo.add(" ");
                            this.mTodo.add(term8);
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1) + " ");
                            return;
                        }
                        case ":farkas": {
                            Term[] termArray = (Term[])annotationArray[0].getValue();
                            assert (annotationArray.length == 2);
                            assert (annotationArray[1].getKey() == ProofRules.ANNOT_COEFFS);
                            BigInteger[] bigIntegerArray = (BigInteger[])annotationArray[1].getValue();
                            assert (termArray.length == bigIntegerArray.length);
                            this.mTodo.add(")");
                            int n = termArray.length - 1;
                            while (n >= 0) {
                                this.mTodo.add(termArray[n]);
                                this.mTodo.add(" ");
                                this.mTodo.add(bigIntegerArray[n]);
                                this.mTodo.add(" ");
                                --n;
                            }
                            this.mTodo.add("(" + annotationArray[0].getKey().substring(1));
                            return;
                        }
                        case ":dt-test-": {
                            assert (annotationArray.length == 1);
                            Object[] objectArray = (Object[])annotationArray[0].getValue();
                            assert (objectArray.length == 2);
                            this.mTodo.add(")");
                            this.mTodo.add(objectArray[1]);
                            this.mTodo.add(" ");
                            this.mTodo.add(objectArray[0]);
                            this.mTodo.add("(dt-test- ");
                            return;
                        }
                        case ":dt-acyclic": {
                            assert (annotationArray.length == 1);
                            Object[] objectArray = (Object[])annotationArray[0].getValue();
                            assert (objectArray.length == 2);
                            int[] nArray = (int[])objectArray[1];
                            assert (nArray.length > 0);
                            this.mTodo.add("))");
                            int n = nArray.length - 1;
                            while (n >= 1) {
                                this.mTodo.add(" " + nArray[n]);
                                --n;
                            }
                            this.mTodo.add(" (" + nArray[0]);
                            this.mTodo.add(objectArray[0]);
                            this.mTodo.add("(dt-acyclic ");
                            return;
                        }
                    }
                }
                if (!(term instanceof ApplicationTerm)) break block235;
                annotatedTerm = (ApplicationTerm)term;
                annotationArray = annotatedTerm.getParameters();
                switch (annotatedTerm.getFunction().getName()) {
                    case "..res": {
                        assert (annotationArray.length == 3);
                        this.mTodo.add(")");
                        int n = annotationArray.length - 1;
                        while (n >= 0) {
                            this.mTodo.add(annotationArray[n]);
                            this.mTodo.add(" ");
                            --n;
                        }
                        this.mTodo.add("(res");
                        return;
                    }
                    case "..choose": {
                        assert (annotationArray.length == 1);
                        LambdaTerm lambdaTerm = (LambdaTerm)annotationArray[0];
                        assert (lambdaTerm.getVariables().length == 1);
                        this.mTodo.add(")");
                        this.mTodo.add(lambdaTerm.getSubterm());
                        this.mTodo.add(") ");
                        this.mTodo.add(lambdaTerm.getVariables()[0].getSort());
                        this.mTodo.add(" ");
                        this.mTodo.add(lambdaTerm.getVariables()[0]);
                        this.mTodo.add("(choose (");
                        return;
                    }
                    case "..assume": {
                        assert (annotationArray.length == 1);
                        this.mTodo.add(")");
                        this.mTodo.add(annotationArray[0]);
                        this.mTodo.add("(assume ");
                        return;
                    }
                }
            }
            if (term instanceof LetTerm) {
                int n;
                annotatedTerm = (LetTerm)term;
                annotationArray = annotatedTerm.getVariables();
                Object object = annotatedTerm.getValues();
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                while (n3 < annotationArray.length) {
                    if (ProofRules.isProof(object[n3])) {
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                    ++n3;
                }
                if (bl2) {
                    this.mTodo.addLast(")");
                }
                if (bl) {
                    this.mTodo.addLast(")");
                }
                this.mTodo.addLast(annotatedTerm.getSubTerm());
                if (bl) {
                    String string = ")) ";
                    n = ((Object)object).length - 1;
                    while (n >= 0) {
                        if (ProofRules.isProof((Term)object[n])) {
                            this.mTodo.addLast(string);
                            this.mTodo.addLast(object[n]);
                            this.mTodo.addLast("(" + annotationArray[n].toString() + " ");
                            string = ") ";
                        }
                        --n;
                    }
                    this.mTodo.addLast("(let-proof (");
                }
                if (bl2) {
                    String string = ")) ";
                    n = ((Object)object).length - 1;
                    while (n >= 0) {
                        if (!ProofRules.isProof((Term)object[n])) {
                            this.mTodo.addLast(string);
                            this.mTodo.addLast(object[n]);
                            this.mTodo.addLast("(" + annotationArray[n].toString() + " ");
                            string = ") ";
                        }
                        --n;
                    }
                    this.mTodo.addLast("(let (");
                }
                return;
            }
            super.walkTerm(term);
        }
    }
}

