/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.FixProofDAG;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.OccurrenceCounter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.RecyclePivots;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.UnitCollector;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class Transformations {
    private Transformations() {
    }

    public static Clause lowerUnits(Clause clause) {
        ResolutionNode.Antecedent[] antecedentArray;
        Object object;
        assert (clause.getSize() == 0);
        OccurrenceCounter occurrenceCounter = new OccurrenceCounter();
        Map<Clause, Integer> map = occurrenceCounter.count(clause);
        occurrenceCounter = null;
        UnitCollector unitCollector = new UnitCollector();
        Queue<ResolutionNode.Antecedent> queue = unitCollector.collectUnits(clause, map);
        Map<Clause, Set<Literal>> map2 = unitCollector.getDeletedNodes();
        unitCollector = null;
        FixProofDAG fixProofDAG = new FixProofDAG();
        Clause clause2 = fixProofDAG.fix(clause, map2);
        ArrayDeque<ResolutionNode.Antecedent> arrayDeque = new ArrayDeque<ResolutionNode.Antecedent>(queue.size());
        while (!queue.isEmpty()) {
            object = queue.remove();
            arrayDeque.add(new ResolutionNode.Antecedent(((ResolutionNode.Antecedent)object).mPivot, fixProofDAG.fix(((ResolutionNode.Antecedent)object).mAntecedent, map2)));
        }
        map = null;
        queue = null;
        map2 = null;
        fixProofDAG = null;
        object = new HashSet();
        int n = 0;
        while (n < clause2.getSize()) {
            ((HashSet)object).add(clause2.getLiteral(n));
            ++n;
        }
        if (((HashSet)object).isEmpty()) {
            return clause2;
        }
        ResolutionNode.Antecedent[] antecedentArray2 = new ResolutionNode.Antecedent[arrayDeque.size()];
        int n2 = 0;
        while (!arrayDeque.isEmpty()) {
            antecedentArray = (ResolutionNode.Antecedent[])arrayDeque.remove();
            if (!((HashSet)object).contains(antecedentArray.mPivot.negate())) continue;
            antecedentArray2[n2++] = antecedentArray;
            ((HashSet)object).remove(antecedentArray.mPivot.negate());
            int n3 = 0;
            while (n3 < antecedentArray.mAntecedent.getSize()) {
                Literal literal = antecedentArray.mAntecedent.getLiteral(n3);
                if (literal != antecedentArray.mPivot) {
                    ((HashSet)object).add(literal);
                }
                ++n3;
            }
        }
        if (n2 < antecedentArray2.length) {
            antecedentArray = new ResolutionNode.Antecedent[n2];
            System.arraycopy(antecedentArray2, 0, antecedentArray, 0, n2);
            antecedentArray2 = antecedentArray;
        }
        assert (((HashSet)object).isEmpty());
        return new Clause(new Literal[0], new ResolutionNode(clause2, antecedentArray2));
    }

    public static Clause recycleUnits(Clause clause) {
        assert (clause.getSize() == 0);
        OccurrenceCounter occurrenceCounter = new OccurrenceCounter();
        Map<Clause, Integer> map = occurrenceCounter.count(clause);
        occurrenceCounter = null;
        RecyclePivots recyclePivots = new RecyclePivots();
        Map<Clause, Set<Literal>> map2 = recyclePivots.regularize(clause, map);
        recyclePivots = null;
        FixProofDAG fixProofDAG = new FixProofDAG();
        return fixProofDAG.fix(clause, map2);
    }

    public static enum AvailableTransformations {
        NONE{

            @Override
            public Clause transform(Clause clause) {
                return clause;
            }
        }
        ,
        LU{

            @Override
            public Clause transform(Clause clause) {
                return Transformations.lowerUnits(clause);
            }
        }
        ,
        RPI{

            @Override
            public Clause transform(Clause clause) {
                return Transformations.recycleUnits(clause);
            }
        }
        ,
        RPILU{

            @Override
            public Clause transform(Clause clause) {
                return Transformations.lowerUnits(Transformations.recycleUnits(clause));
            }
        }
        ,
        LURPI{

            @Override
            public Clause transform(Clause clause) {
                return Transformations.recycleUnits(Transformations.lowerUnits(clause));
            }
        };


        public abstract Clause transform(Clause var1);
    }
}

