/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker.CheckingScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ParseEnvironment;
import java.util.ArrayDeque;

public final class Main {
    private Main() {
    }

    private static void usage() {
        System.err.println("USAGE: smtinterpol.proof.checker.Main [OPTION]... [SCRIPTFILE] [PROOFFILE]");
        System.err.println("  -o <opt>=<value>     Set option :opt to value. The default value is true.");
        System.err.println("  -q                   Only print error messages.");
        System.err.println("  -w                   Don't print statistics and models.");
        System.err.println("  -v                   Print debugging messages.");
        System.err.println("  -t <num>             Set the timeout per check-sat call to <num> milliseconds.");
        System.err.println("  -l <num>             Set the reproducible resource limit per check-sat call to <num>.");
        System.err.println("  -r <num>             Use a different random seed.");
        System.err.println("  -version             Print version and exit.");
    }

    private static void version() {
        System.err.println("SMTInterpol Proof Checker 2.5-1381-g0e9bd0bf");
    }

    public static void main(String[] stringArray) throws Exception {
        Object object2;
        Object object3;
        String string;
        DefaultLogger defaultLogger = new DefaultLogger();
        ArrayDeque<Option> arrayDeque = new ArrayDeque<Option>();
        int n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            if (stringArray[n].equals("--")) {
                ++n;
                break;
            }
            if (stringArray[n].equals("-no-success")) {
                arrayDeque.add(new Option(":print-success", false));
            } else if (stringArray[n].equals("-v")) {
                arrayDeque.add(new Option(":verbosity", 5));
            } else if (stringArray[n].equals("-w")) {
                arrayDeque.add(new Option(":verbosity", 3));
            } else if (stringArray[n].equals("-q")) {
                arrayDeque.add(new Option(":verbosity", 2));
            } else if (stringArray[n].equals("-t") && ++n < stringArray.length) {
                arrayDeque.add(new Option(":timeout", stringArray[n]));
            } else if (stringArray[n].equals("-l") && ++n < stringArray.length) {
                arrayDeque.add(new Option(":reproducible-resource-limit", stringArray[n]));
            } else if (stringArray[n].equals("-r") && ++n < stringArray.length) {
                arrayDeque.add(new Option(":random-seed", stringArray[n]));
            } else if (stringArray[n].equals("-o") && n + 1 < stringArray.length) {
                int n2;
                if ((n2 = (string = stringArray[++n]).indexOf(61)) == -1) {
                    object3 = string;
                    object2 = Boolean.TRUE;
                } else {
                    object3 = string.substring(0, n2);
                    object2 = string.substring(n2 + 1);
                }
                try {
                    arrayDeque.add(new Option(":" + (String)object3, object2));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    System.err.println("Unknown option :" + (String)object3 + ".");
                    return;
                }
                catch (SMTLIBException sMTLIBException) {
                    System.err.println(sMTLIBException.getMessage());
                    return;
                }
            } else if (stringArray[n].equals("-trace")) {
                arrayDeque.add(new Option(":verbosity", 6));
            } else {
                if (stringArray[n].equals("-version")) {
                    Main.version();
                    return;
                }
                Main.usage();
                return;
            }
            ++n;
        }
        if (n + 2 != stringArray.length) {
            Main.usage();
            return;
        }
        string = stringArray[n++];
        String string2 = stringArray[n++];
        object3 = new OptionMap(defaultLogger, true);
        object2 = new CheckingScript(defaultLogger, string2);
        for (Option object4 : arrayDeque) {
            object2.setOption(object4.getName(), object4.getValue());
        }
        ParseEnvironment parseEnvironment = new ParseEnvironment((Script)object2, (OptionMap)object3){

            @Override
            public void printResponse(Object object) {
            }
        };
        parseEnvironment.parseScript(string);
        parseEnvironment.exit();
    }

    private static class Option {
        String mName;
        Object mValue;

        public Option(String string, Object object) {
            this.mName = string;
            this.mValue = object;
        }

        public String getName() {
            return this.mName;
        }

        public Object getValue() {
            return this.mValue;
        }
    }
}

