/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.Arrays;

public class EMReverseTrigger
extends ReverseTrigger {
    private final EMatching mEMatching;
    private final ICode mRemainingCode;
    private final FunctionSymbol mFunc;
    private final int mArgPos;
    private final CCTerm mArg;
    private final CCTerm[] mRegister;
    private final int mOutRegIndex;
    private final int mDecisionLevel;

    public EMReverseTrigger(EMatching eMatching, ICode iCode, FunctionSymbol functionSymbol, int n, CCTerm cCTerm, CCTerm[] cCTermArray, int n2, int n3) {
        this.mEMatching = eMatching;
        this.mRemainingCode = iCode;
        this.mFunc = functionSymbol;
        this.mArgPos = n;
        this.mArg = cCTerm;
        this.mRegister = cCTermArray;
        this.mOutRegIndex = n2;
        this.mDecisionLevel = n3;
    }

    @Override
    public CCTerm getArgument() {
        return this.mArg;
    }

    @Override
    public int getArgPosition() {
        return this.mArgPos;
    }

    @Override
    public FunctionSymbol getFunctionSymbol() {
        return this.mFunc;
    }

    @Override
    public void activate(CCAppTerm cCAppTerm, boolean bl) {
        CCTerm[] cCTermArray = Arrays.copyOf(this.mRegister, this.mRegister.length);
        cCTermArray[this.mOutRegIndex] = cCAppTerm;
        if (this.mArg != null) {
            assert (cCAppTerm instanceof CCAppTerm);
            CCAppTerm cCAppTerm2 = cCAppTerm;
            int n = 0;
            while (n < this.mFunc.getParameterSorts().length - this.mArgPos - 1) {
                cCAppTerm2 = (CCAppTerm)cCAppTerm2.getFunc();
                ++n;
            }
            CCTerm cCTerm = cCAppTerm2.getArg();
            int n2 = this.mEMatching.getQuantTheory().getCClosure().getDecideLevelForPath(this.mArg, cCTerm);
            this.mEMatching.addCode(this.mRemainingCode, cCTermArray, n2 > this.mDecisionLevel ? n2 : this.mDecisionLevel);
        } else {
            this.mEMatching.addCode(this.mRemainingCode, cCTermArray, this.mDecisionLevel);
        }
    }
}

