/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag;

import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.IDagOverlay;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagNode;
import de.uni_freiburg.informatik.ultimate.util.datastructures.GraphToTgf;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BackwardClosedOverlay<L>
implements IDagOverlay<L> {
    private final HashRelation<RegexDagNode<L>, RegexDagNode<L>> mPredecessorRelation = new HashRelation();
    private final HashRelation<RegexDagNode<L>, RegexDagNode<L>> mSuccessorRelation = new HashRelation();
    private final Set<RegexDagNode<L>> mSinks = new HashSet<RegexDagNode<L>>();

    public void addExclusive(RegexDagNode<L> regexDagNode) {
        regexDagNode.getIncomingNodes().forEach(this::addInclusive);
    }

    public void addInclusive(RegexDagNode<L> regexDagNode) {
        if (this.mSuccessorRelation.hasEmptyImage(regexDagNode)) {
            this.mSinks.add(regexDagNode);
        }
        this.addInclusiveIntern(regexDagNode);
    }

    private void addInclusiveIntern(RegexDagNode<L> regexDagNode) {
        for (RegexDagNode regexDagNode2 : regexDagNode.getIncomingNodes()) {
            if (!this.mSuccessorRelation.addPair((Object)regexDagNode2, regexDagNode)) continue;
            this.mPredecessorRelation.addPair(regexDagNode, (Object)regexDagNode2);
            this.mSinks.remove((Object)regexDagNode2);
            this.addInclusive(regexDagNode2);
        }
    }

    @Override
    public Collection<RegexDagNode<L>> successorsOf(RegexDagNode<L> regexDagNode) {
        return this.mSuccessorRelation.getImage(regexDagNode);
    }

    @Override
    public Collection<RegexDagNode<L>> predecessorsOf(RegexDagNode<L> regexDagNode) {
        return this.mPredecessorRelation.getImage(regexDagNode);
    }

    @Override
    public Collection<RegexDagNode<L>> sources(RegexDag<L> regexDag) {
        return Collections.singleton(regexDag.getSource());
    }

    @Override
    public Collection<RegexDagNode<L>> sinks(RegexDag<L> regexDag) {
        return this.mSinks;
    }

    public String toString() {
        return new GraphToTgf(arg_0 -> this.mSuccessorRelation.getImage(arg_0), arg_0 -> this.mPredecessorRelation.getImage(arg_0), RegexDagNode::toString).includeComponentsOf(this.mSinks).getTgf();
    }
}

