/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PolyPacSimplificationTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SimplificationUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermContextTransformationEngine;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TreeSizeComperator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolyPoNeUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisDepthCodeGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierOverapproximator;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SimplifyDDA2
extends TermContextTransformationEngine.TermWalker<Term> {
    private static final boolean APPLY_CONSTANT_FOLDING = false;
    private static final boolean DEBUG_CHECK_RESULT = false;
    private static final boolean USE_ECHO_COMMANDS = false;
    private static final boolean PREPROCESS_WITH_POLY_PAC_SIMPLIFICATION = true;
    private static final boolean DESCEND_INTO_QUANTIFIED_FORMULAS = true;
    private static final boolean OVERAPROXIMATE_QUANTIFIED_FORMULAS_IN_CONTEXT = true;
    private static final TermContextTransformationEngine.Repetition SIMPLIFY_REPEATEDLY = TermContextTransformationEngine.Repetition.REPEAT_UNTIL_NO_CHANGE;
    private static final CheckedNodes CHECKED_NODES = CheckedNodes.ONLY_LEAVES;
    private static final boolean OVERAPPROXIMATE_DIFFCULT_QUANTIFIERS_IN_NODES = false;
    private static final boolean APPLY_MOD_SIMPLIFICATION = true;
    private static final boolean APPLY_ARRAY_SIMPLIFICATION = true;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private int mAssertionStackHeight = 1;
    private int mNumberOfCheckSatCommands = 0;
    private int mNonConstrainingNodes = 0;
    private int mNonRelaxingNodes = 0;
    private long mCheckSatTime = 0L;
    private final long mStartTime = System.nanoTime();
    private final ArrayDeque<Map<TermVariable, Term>> mRenamingMaps;

    private SimplifyDDA2(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
        this.mRenamingMaps = new ArrayDeque();
    }

    @Override
    protected Term constructContextForApplicationTerm(Term term, FunctionSymbol functionSymbol, List<Term> list, int n) {
        Term term2;
        List list2 = DataStructureUtils.copyAllButOne(list, (int)n);
        this.mMgdScript.getScript().push(1);
        ++this.mAssertionStackHeight;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (functionSymbol.getName().equals("and")) {
            for (Term term3 : list2) {
                term2 = this.replaceUniversalQuantifiersByTrue(this.mMgdScript, term3);
                this.mMgdScript.getScript().assertTerm(term2);
                arrayList.add(term2);
            }
        }
        if (functionSymbol.getName().equals("or")) {
            for (Term term3 : list2) {
                term2 = this.replaceExistentialQuantifiersByFalse(this.mMgdScript, term3);
                this.mMgdScript.getScript().assertTerm(SmtUtils.not(this.mMgdScript.getScript(), term2));
                arrayList.add(SmtUtils.not(this.mMgdScript.getScript(), term2));
            }
        }
        return SmtUtils.and(this.mMgdScript.getScript(), arrayList);
    }

    private Term replaceUniversalQuantifiersByTrue(ManagedScript managedScript, Term term) {
        return QuantifierOverapproximator.apply(managedScript.getScript(), EnumSet.of(QuantifierOverapproximator.Quantifier.FORALL), managedScript.getScript().term("true", new Term[0]), term);
    }

    private Term replaceExistentialQuantifiersByFalse(ManagedScript managedScript, Term term) {
        return QuantifierOverapproximator.apply(managedScript.getScript(), EnumSet.of(QuantifierOverapproximator.Quantifier.EXISTS), managedScript.getScript().term("false", new Term[0]), term);
    }

    @Override
    protected Term constructContextForQuantifiedFormula(Term term, int n, List<TermVariable> list) {
        this.mMgdScript.getScript().push(1);
        ++this.mAssertionStackHeight;
        return Context.buildCriticalContraintForQuantifiedFormula(this.mMgdScript.getScript(), term, list, Context.CcTransformation.TO_NNF);
    }

    private static boolean isLeaf(Term term) {
        if (term instanceof QuantifiedFormula) {
            return false;
        }
        Term term2 = SmtUtils.unzipNot(term);
        if (term2 != null) {
            return SmtUtils.isAtomicFormula(term2);
        }
        return SmtUtils.isAtomicFormula(term);
    }

    private TermContextTransformationEngine.DescendResult checkRedundancy(Term term) {
        ++this.mNumberOfCheckSatCommands;
        long l = System.nanoTime();
        Term term2 = term;
        Script.LBool lBool = Util.checkSat((Script)this.mMgdScript.getScript(), (Term)term2);
        this.mCheckSatTime += System.nanoTime() - l;
        if (lBool == Script.LBool.UNSAT) {
            ++this.mNonRelaxingNodes;
            Term term3 = this.mMgdScript.getScript().term("false", new Term[0]);
            return new TermContextTransformationEngine.FinalResultForAscend(term3);
        }
        l = System.nanoTime();
        ++this.mNumberOfCheckSatCommands;
        term2 = term;
        lBool = Util.checkSat((Script)this.mMgdScript.getScript(), (Term)SmtUtils.not(this.mMgdScript.getScript(), term2));
        this.mCheckSatTime += System.nanoTime() - l;
        if (lBool == Script.LBool.UNSAT) {
            ++this.mNonConstrainingNodes;
            Term term4 = this.mMgdScript.getScript().term("true", new Term[0]);
            return new TermContextTransformationEngine.FinalResultForAscend(term4);
        }
        Term term5 = term;
        term5 = SimplificationUtils.tryModSimplification(this.mMgdScript, termArray -> this.checkValidity(termArray), term5);
        if ((term5 = SimplificationUtils.tryArraySimplification(this.mMgdScript, termArray -> this.checkValidity(termArray), term5)) != term) {
            return new TermContextTransformationEngine.FinalResultForAscend(term5);
        }
        return null;
    }

    private Script.LBool checkValidity(Term ... termArray) {
        Term term = SmtUtils.and(this.mMgdScript.getScript(), termArray);
        Term term2 = SmtUtils.not(this.mMgdScript.getScript(), term);
        return Util.checkSat((Script)this.mMgdScript.getScript(), (Term)term2);
    }

    private QuantifiedFormula preprocessQuantifiedFormula(QuantifiedFormula quantifiedFormula, Term term) {
        this.mMgdScript.lock(this);
        Map<TermVariable, Term> map = SimplifyDDA2.constructFreshConstantSymbols(this.mMgdScript, Arrays.asList(quantifiedFormula.getVariables()), (Term)quantifiedFormula, term);
        this.mRenamingMaps.push(map);
        this.mMgdScript.unlock(this);
        Term term2 = Substitution.apply(this.mMgdScript, map, quantifiedFormula.getSubformula());
        return (QuantifiedFormula)this.mMgdScript.getScript().quantifier(quantifiedFormula.getQuantifier(), quantifiedFormula.getVariables(), term2, (Term[][])new Term[0][]);
    }

    private static Map<TermVariable, Term> constructFreshConstantSymbols(ManagedScript managedScript, Collection<TermVariable> collection, Term term, Term term2) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (TermVariable termVariable : collection) {
            Term term3 = SimplifyDDA2.constructFreshConstantSymbol(managedScript, termVariable, term, term2);
            hashMap.put(termVariable, term3);
        }
        return hashMap;
    }

    private static Term constructFreshConstantSymbol(ManagedScript managedScript, TermVariable termVariable, Term term, Term term2) {
        String string = termVariable.getName() + "_SimplifyDDA_" + termVariable.hashCode() + "_" + term.hashCode() + "_" + term2.hashCode();
        managedScript.getScript().declareFun(string, new Sort[0], termVariable.getSort());
        return managedScript.getScript().term(string, new Term[0]);
    }

    private static boolean checkRedundancyForNode(Term term) {
        return CHECKED_NODES == CheckedNodes.ALL_NODES || CHECKED_NODES == CheckedNodes.ONLY_LEAVES_AND_QUANTIFIED_NODES && (term instanceof QuantifiedFormula || SimplifyDDA2.isLeaf(term)) || CHECKED_NODES == CheckedNodes.ONLY_LEAVES && SimplifyDDA2.isLeaf(term);
    }

    @Override
    protected TermContextTransformationEngine.DescendResult convert(Term term, Term term2) {
        Term term3 = term2;
        term3 = PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, term, term2);
        return this.convertForPreprocessedInputTerms(term, term3);
    }

    private TermContextTransformationEngine.DescendResult convertForPreprocessedInputTerms(Term term, Term term2) {
        TermContextTransformationEngine.DescendResult descendResult;
        boolean bl;
        if (SmtUtils.isFalseLiteral(term)) {
            throw new AssertionError((Object)"critical constraint is false");
        }
        boolean bl2 = bl = term2 instanceof QuantifiedFormula || !SimplifyDDA2.isLeaf(term2) && !(term2 instanceof QuantifiedFormula);
        if (SimplifyDDA2.checkRedundancyForNode(term2) && (descendResult = this.checkRedundancy(term2)) != null) {
            this.mMgdScript.getScript().pop(1);
            --this.mAssertionStackHeight;
            return descendResult;
        }
        if (bl) {
            if (term2 instanceof QuantifiedFormula) {
                return new TermContextTransformationEngine.IntermediateResultForDescend((Term)this.preprocessQuantifiedFormula((QuantifiedFormula)term2, term));
            }
            return new TermContextTransformationEngine.IntermediateResultForDescend(term2);
        }
        this.mMgdScript.getScript().pop(1);
        --this.mAssertionStackHeight;
        return new TermContextTransformationEngine.FinalResultForAscend(term2);
    }

    @Override
    protected Term constructResultForApplicationTerm(Term term, ApplicationTerm applicationTerm, Term[] termArray) {
        this.mMgdScript.getScript().pop(1);
        --this.mAssertionStackHeight;
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            CondisDepthCodeGenerator.CondisDepthCode condisDepthCode = CondisDepthCodeGenerator.CondisDepthCode.of(term);
            throw new ToolchainCanceledException(this.getClass(), String.format("simplifying %s xjuncts wrt. a %s context", termArray.length, condisDepthCode));
        }
        if (applicationTerm.getFunction().getName().equals("and")) {
            return PolyPoNeUtils.and(this.mMgdScript.getScript(), term, Arrays.asList(termArray));
        }
        if (applicationTerm.getFunction().getName().equals("or")) {
            return PolyPoNeUtils.or(this.mMgdScript.getScript(), term, Arrays.asList(termArray));
        }
        throw new AssertionError();
    }

    public static Term simplify(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term) {
        Term term2 = SimplifyDDA2.simplify(iUltimateServiceProvider, managedScript, managedScript.getScript().term("true", new Term[0]), term);
        return term2;
    }

    public static Term simplify(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term, Term term2) {
        Term term3;
        if (SmtUtils.isFalseLiteral(term)) {
            return term;
        }
        SimplifyDDA2 simplifyDDA2 = new SimplifyDDA2(iUltimateServiceProvider, managedScript);
        managedScript.getScript().push(1);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        hashSet.addAll(Arrays.asList(term2.getFreeVars()));
        Map<TermVariable, Term> map = SimplifyDDA2.constructFreshConstantSymbols(managedScript, hashSet, term2, term);
        Term term4 = Substitution.apply(managedScript, map, term);
        Term term5 = Substitution.apply(managedScript, map, term2);
        managedScript.getScript().assertTerm(term4);
        try {
            try {
                int n;
                ILogger iLogger;
                Term term6 = new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.KEEP).transform(term5);
                TreeSizeComperator treeSizeComperator = new TreeSizeComperator(CommuhashUtils.HASH_BASED_COMPERATOR);
                Term term7 = TermContextTransformationEngine.transform(simplifyDDA2, treeSizeComperator, term4, term6);
                if (map.isEmpty()) {
                    term3 = term7;
                } else {
                    iLogger = SimplifyDDA2.reverseMap(map);
                    term3 = Substitution.apply(managedScript, iLogger, term7);
                }
                iLogger = iUltimateServiceProvider.getLoggingService().getLogger(SimplifyDDA2.class);
                if (iLogger.isDebugEnabled()) {
                    iLogger.debug((Object)simplifyDDA2.generateExitMessage());
                }
                if ((n = simplifyDDA2.getAssertionStackHeight()) != 0) {
                    throw new AssertionError((Object)String.format("stackHeight is non-zero", new Object[0]));
                }
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                simplifyDDA2.clearStack();
                CondisDepthCodeGenerator.CondisDepthCode condisDepthCode = CondisDepthCodeGenerator.CondisDepthCode.of(term2);
                String string = String.format("simplifying a %s term", condisDepthCode);
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(SimplifyDDA2.class, string));
                throw toolchainCanceledException;
            }
        }
        finally {
            if (managedScript.isLocked()) {
                throw new AssertionError((Object)"ManagedScript is still locked");
            }
        }
        return term3;
    }

    public int getAssertionStackHeight() {
        return this.mAssertionStackHeight;
    }

    public void clearStack() {
        while (this.mAssertionStackHeight > 0) {
            this.mMgdScript.getScript().pop(1);
            --this.mAssertionStackHeight;
        }
    }

    public String generateExitMessage() {
        return String.format("Run SimplifyDDA2 in %s ms. %s check-sat commands took %s ms. %s non-constraining nodes. %s Non-relaxing nodes.", (System.nanoTime() - this.mStartTime) / 1000000L, this.mNumberOfCheckSatCommands, this.mCheckSatTime / 1000000L, this.mNonConstrainingNodes, this.mNonRelaxingNodes);
    }

    @Override
    protected Term constructResultForQuantifiedFormula(Term term, QuantifiedFormula quantifiedFormula, Term term2) {
        Map<TermVariable, Term> map = this.mRenamingMaps.pop();
        Map<Term, TermVariable> map2 = SimplifyDDA2.reverseMap(map);
        Term term3 = Substitution.apply(this.mMgdScript, map2, term2);
        this.mMgdScript.getScript().pop(1);
        --this.mAssertionStackHeight;
        assert (this.mAssertionStackHeight >= 0);
        return SmtUtils.quantifier(this.mMgdScript.getScript(), quantifiedFormula.getQuantifier(), map.keySet(), term3);
    }

    private static <A, B> Map<B, A> reverseMap(Map<A, B> map) {
        HashMap<B, A> hashMap = new HashMap<B, A>();
        for (Map.Entry<A, B> entry : map.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    @Override
    protected TermContextTransformationEngine.Repetition applyRepeatedly() {
        return SIMPLIFY_REPEATEDLY;
    }

    @Override
    protected void checkIntermediateResult(Term term, Term term2, Term term3) {
        Script.LBool lBool = SmtUtils.checkEquivalenceUnderAssumption(term2, term3, term, this.mMgdScript.getScript());
        switch (lBool) {
            case SAT: {
                throw new AssertionError((Object)String.format("Intermediate result not equivalent. Input: %s Output: %s Assumption: %s", term2, term3, term));
            }
            case UNKNOWN: {
                ILogger iLogger = this.mServices.getLoggingService().getLogger(this.getClass());
                iLogger.info((Object)String.format("Insufficient ressources to check equivalence of intermediate result. Input: %s Output: %s Assumption: %s", term2, term3, term));
                break;
            }
            case UNSAT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + String.valueOf(lBool)));
            }
        }
    }

    private static enum CheckedNodes {
        ONLY_LEAVES,
        ALL_NODES,
        ONLY_LEAVES_AND_QUANTIFIED_NODES;

    }
}

