/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.DivisibleByAssumption;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IAssumption;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.VariableNotZeroAssumption;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SparseMapBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AssumptionMapBuilder {
    private Map<SolvedBinaryRelation.AssumptionForSolvability, IAssumption> mAssumptionMap = Collections.emptyMap();
    private final Script mScript;

    public AssumptionMapBuilder(Script script) {
        this.mScript = script;
    }

    public void putDivisorNotZero(Term term) {
        if (SmtSortUtils.isRealSort(term.getSort())) {
            this.put(SolvedBinaryRelation.AssumptionForSolvability.REAL_DIVISOR_NOT_ZERO, new VariableNotZeroAssumption(this.mScript, term), AssumptionMapBuilder::castAndCreateVarNotZeroAssu);
        } else if (SmtSortUtils.isIntSort(term.getSort())) {
            this.put(SolvedBinaryRelation.AssumptionForSolvability.INTEGER_DIVISOR_NOT_ZERO, new VariableNotZeroAssumption(this.mScript, term), AssumptionMapBuilder::castAndCreateVarNotZeroAssu);
        } else {
            throw new UnsupportedOperationException("There is no such assumption of this sort.");
        }
    }

    public void putDivisibleByConstant(Term term, Term term2) {
        if (!SmtSortUtils.isIntSort(term.getSort())) {
            throw new UnsupportedOperationException("There is no such assumption of this sort.");
        }
        this.put(SolvedBinaryRelation.AssumptionForSolvability.INTEGER_DIVISIBLE_BY_CONSTANT, new DivisibleByAssumption(this.mScript, term, term2), AssumptionMapBuilder::castAndCreateDivByAssu);
    }

    public void putDivisibleByVariable(Term term, Term term2) {
        if (!SmtSortUtils.isIntSort(term.getSort())) {
            throw new UnsupportedOperationException("There is no such assumption of this sort.");
        }
        this.put(SolvedBinaryRelation.AssumptionForSolvability.INTEGER_DIVISIBLE_BY_VARIABLE, new DivisibleByAssumption(this.mScript, term, term2), AssumptionMapBuilder::castAndCreateDivByAssu);
    }

    private void put(SolvedBinaryRelation.AssumptionForSolvability assumptionForSolvability, IAssumption iAssumption, BiAssumptionConstructor<? extends IAssumption> biAssumptionConstructor) {
        if (this.mAssumptionMap.isEmpty()) {
            this.mAssumptionMap = Collections.singletonMap(assumptionForSolvability, iAssumption);
        } else if (this.mAssumptionMap.size() == 1) {
            if (this.mAssumptionMap.containsKey((Object)assumptionForSolvability)) {
                this.mAssumptionMap = Collections.singletonMap(assumptionForSolvability, biAssumptionConstructor.apply(this.mScript, this.mAssumptionMap.get((Object)assumptionForSolvability), iAssumption));
            } else {
                Map.Entry<SolvedBinaryRelation.AssumptionForSolvability, IAssumption> entry = this.mAssumptionMap.entrySet().iterator().next();
                this.mAssumptionMap = new HashMap<SolvedBinaryRelation.AssumptionForSolvability, IAssumption>();
                this.mAssumptionMap.put(entry.getKey(), entry.getValue());
                this.mAssumptionMap.put(assumptionForSolvability, iAssumption);
            }
        } else if (this.mAssumptionMap.containsKey((Object)assumptionForSolvability)) {
            this.mAssumptionMap.put(assumptionForSolvability, biAssumptionConstructor.apply(this.mScript, this.mAssumptionMap.get((Object)assumptionForSolvability), iAssumption));
        } else {
            this.mAssumptionMap.put(assumptionForSolvability, iAssumption);
        }
    }

    private static DivisibleByAssumption castAndCreateDivByAssu(Script script, IAssumption iAssumption, IAssumption iAssumption2) {
        if (iAssumption instanceof DivisibleByAssumption && iAssumption2 instanceof DivisibleByAssumption) {
            DivisibleByAssumption[] divisibleByAssumptionArray = new DivisibleByAssumption[]{(DivisibleByAssumption)iAssumption, (DivisibleByAssumption)iAssumption2};
            return new DivisibleByAssumption(script, iAssumption.getSort(), divisibleByAssumptionArray);
        }
        throw new IllegalArgumentException("Someone has put an assumption at the wrong place");
    }

    private static VariableNotZeroAssumption castAndCreateVarNotZeroAssu(Script script, IAssumption iAssumption, IAssumption iAssumption2) {
        if (iAssumption instanceof VariableNotZeroAssumption && iAssumption2 instanceof VariableNotZeroAssumption) {
            VariableNotZeroAssumption[] variableNotZeroAssumptionArray = new VariableNotZeroAssumption[]{(VariableNotZeroAssumption)iAssumption, (VariableNotZeroAssumption)iAssumption2};
            return new VariableNotZeroAssumption(script, iAssumption.getSort(), variableNotZeroAssumptionArray);
        }
        throw new IllegalArgumentException("Someone has put an assumption at the wrong place");
    }

    public boolean hasContractedForm(SolvedBinaryRelation.AssumptionForSolvability assumptionForSolvability) {
        return this.mAssumptionMap.get((Object)assumptionForSolvability).hasContractedForm();
    }

    public Term getExplicitForm(SolvedBinaryRelation.AssumptionForSolvability assumptionForSolvability) {
        if (this.mAssumptionMap.containsKey((Object)assumptionForSolvability)) {
            return this.mAssumptionMap.get((Object)assumptionForSolvability).toExplicitTerm();
        }
        return this.mScript.term("true", new Term[0]);
    }

    public Term getContractedFormIfPossible(SolvedBinaryRelation.AssumptionForSolvability assumptionForSolvability) {
        if (this.mAssumptionMap.containsKey((Object)assumptionForSolvability)) {
            return this.mAssumptionMap.get((Object)assumptionForSolvability).toContractedTermIfPossible();
        }
        return this.mScript.term("true", new Term[0]);
    }

    public boolean isEmpty() {
        return this.mAssumptionMap.isEmpty();
    }

    public void clear() {
        this.mAssumptionMap = Collections.emptyMap();
    }

    public Map<SolvedBinaryRelation.AssumptionForSolvability, Term> getExplicitAssumptionMap() {
        SparseMapBuilder sparseMapBuilder = new SparseMapBuilder();
        for (SolvedBinaryRelation.AssumptionForSolvability assumptionForSolvability : this.mAssumptionMap.keySet()) {
            sparseMapBuilder.put((Object)assumptionForSolvability, (Object)this.getExplicitForm(assumptionForSolvability));
        }
        return sparseMapBuilder.getBuiltMap();
    }

    public Map<SolvedBinaryRelation.AssumptionForSolvability, Term> getContractedAssumptionMapWherePossible() {
        SparseMapBuilder sparseMapBuilder = new SparseMapBuilder();
        for (SolvedBinaryRelation.AssumptionForSolvability assumptionForSolvability : this.mAssumptionMap.keySet()) {
            if (this.hasContractedForm(assumptionForSolvability)) {
                sparseMapBuilder.put((Object)assumptionForSolvability, (Object)this.getContractedFormIfPossible(assumptionForSolvability));
                continue;
            }
            sparseMapBuilder.put((Object)assumptionForSolvability, (Object)this.getExplicitForm(assumptionForSolvability));
        }
        return sparseMapBuilder.getBuiltMap();
    }

    @FunctionalInterface
    public static interface BiAssumptionConstructor<S> {
        public S apply(Script var1, IAssumption var2, IAssumption var3);
    }
}

