/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ParameterPartition;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushUtilsForLocalEliminatees;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class QuantifierPushUtils {
    public static final boolean OPTION_EVALUATE_SUCCESS_OF_DISTRIBUTIVITY_APPLICATION = false;
    public static final boolean OPTION_ELIMINATEE_SEQUENTIALIZATION = true;
    public static final boolean OPTION_SCOUT_BASED_DISTRIBUTIVITY_RECOMMENDATION = true;
    public static final String NOT_DUAL_FINITE_CONNECTIVE = "not dual finite connective";

    public static boolean isQuantifiedDualFiniteJunction(int n, Term term) {
        QuantifiedFormula quantifiedFormula;
        boolean bl = term instanceof QuantifiedFormula ? ((quantifiedFormula = (QuantifiedFormula)term).getQuantifier() == n ? QuantifierPusher.classify(quantifiedFormula.getSubformula()) == QuantifierPusher.FormulaClassification.DUAL_FINITE_CONNECTIVE : false) : false;
        return bl;
    }

    public static Pair<Boolean, Term> preprocessDualFiniteJunction(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask eliminationTask, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator, boolean bl2, boolean bl3) {
        EliminationTask eliminationTask2;
        block14: {
            ParameterPartition parameterPartition;
            eliminationTask2 = eliminationTask;
            int n = 0;
            while (true) {
                Term term;
                if (++n >= 20) {
                    throw new AssertionError((Object)"Probably an infinite loop!");
                }
                if (eliminationTask2.getEliminatees().isEmpty()) {
                    return new Pair((Object)false, (Object)eliminationTask2.getTerm());
                }
                List<Term> list = Arrays.asList(QuantifierUtils.getDualFiniteJuncts(eliminationTask2.getQuantifier(), eliminationTask2.getTerm()));
                if (list.size() <= 1) {
                    return new Pair((Object)false, (Object)SmtUtils.quantifier(managedScript.getScript(), eliminationTask2.getQuantifier(), eliminationTask2.getEliminatees(), list.get(0)));
                }
                if (!QuantifierPushUtils.isFlattened(eliminationTask.getQuantifier(), list)) {
                    parameterPartition = QuantifierPushUtils.flattenQuantifiedFormulas(managedScript, eliminationTask.getQuantifier(), eliminationTask2.toTerm(managedScript.getScript()));
                    if (parameterPartition instanceof QuantifiedFormula) {
                        term = (QuantifiedFormula)parameterPartition;
                        if (term.getQuantifier() != eliminationTask2.getQuantifier()) {
                            return new Pair((Object)false, (Object)parameterPartition);
                        }
                        eliminationTask2 = new EliminationTask((QuantifiedFormula)term, eliminationTask2.getContext());
                        continue;
                    }
                    return new Pair((Object)false, (Object)parameterPartition);
                }
                parameterPartition = new ParameterPartition(managedScript.getScript(), eliminationTask2);
                if (!parameterPartition.isIsPartitionTrivial()) {
                    term = parameterPartition.getTermWithPushedQuantifier();
                    if (term instanceof QuantifiedFormula) {
                        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                        if (quantifiedFormula.getQuantifier() != eliminationTask2.getQuantifier()) {
                            return new Pair((Object)false, (Object)term);
                        }
                        eliminationTask2 = new EliminationTask(quantifiedFormula, eliminationTask2.getContext());
                        continue;
                    }
                    return new Pair((Object)false, (Object)term);
                }
                if (bl2 && (parameterPartition = QuantifierPushUtilsForLocalEliminatees.pushLocalEliminateesOverCorrespondingFiniteJunction(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, eliminationTask2, iQuantifierEliminator)) != null) {
                    if (parameterPartition instanceof QuantifiedFormula) {
                        term = (QuantifiedFormula)parameterPartition;
                        if (term.getQuantifier() != eliminationTask2.getQuantifier()) {
                            return new Pair((Object)false, (Object)parameterPartition);
                        }
                        eliminationTask2 = new EliminationTask((QuantifiedFormula)term, eliminationTask2.getContext());
                        continue;
                    }
                    return new Pair((Object)false, (Object)parameterPartition);
                }
                if (!bl3 || (parameterPartition = QuantifierPushUtils.pushDualQuantifiersInParams(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, eliminationTask2, iQuantifierEliminator)) == null) break block14;
                if (!(parameterPartition instanceof QuantifiedFormula)) break;
                term = (QuantifiedFormula)parameterPartition;
                if (term.getQuantifier() != eliminationTask2.getQuantifier()) {
                    return new Pair((Object)false, (Object)parameterPartition);
                }
                eliminationTask2 = new EliminationTask((QuantifiedFormula)term, eliminationTask2.getContext());
            }
            return new Pair((Object)false, (Object)parameterPartition);
        }
        return new Pair((Object)true, (Object)eliminationTask2.toTerm(managedScript.getScript()));
    }

    static boolean isFlattened(int n, List<Term> list) {
        Predicate<Term> predicate = term -> QuantifierPusher.classify(n, term) != QuantifierPusher.FormulaClassification.SAME_QUANTIFIER;
        return list.stream().allMatch(predicate);
    }

    public static Term flattenQuantifiedFormulas(ManagedScript managedScript, int n, Term term) {
        Term term2;
        Term term3;
        Term[] termArray;
        Set set = Arrays.stream(term.getFreeVars()).map(termVariable -> termVariable.getName()).collect(Collectors.toSet());
        LinkedHashMap<String, TermVariable> linkedHashMap = new LinkedHashMap<String, TermVariable>();
        if (term instanceof QuantifiedFormula) {
            termArray = (Term[])term;
            if (termArray.getQuantifier() != n) {
                return null;
            }
            term3 = termArray.getSubformula();
            Arrays.stream(termArray.getVariables()).forEach(termVariable -> {
                TermVariable termVariable2 = linkedHashMap.put(termVariable.getName(), (TermVariable)termVariable);
            });
        } else {
            term3 = term;
        }
        termArray = QuantifierUtils.getDualFiniteJuncts(n, term3);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term[] termArray2 = termArray;
        int n2 = termArray.length;
        int n3 = 0;
        while (n3 < n2) {
            term2 = termArray2[n3];
            if (term2 instanceof QuantifiedFormula) {
                QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term2;
                if (quantifiedFormula.getQuantifier() != n) {
                    arrayList.add(term2);
                } else {
                    TermVariable termVariable2;
                    HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
                    TermVariable[] termVariableArray = quantifiedFormula.getVariables();
                    int n4 = termVariableArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        TermVariable termVariable3;
                        termVariable2 = termVariableArray[n5];
                        if (linkedHashMap.containsKey(termVariable2.getName()) || set.contains(termVariable2.getName())) {
                            termVariable3 = managedScript.constructFreshCopy(termVariable2);
                            hashMap.put(termVariable2, termVariable3);
                        } else {
                            termVariable3 = termVariable2;
                        }
                        linkedHashMap.put(termVariable3.getName(), termVariable3);
                        ++n5;
                    }
                    termVariable2 = hashMap.isEmpty() ? quantifiedFormula.getSubformula() : Substitution.apply(managedScript, hashMap, quantifiedFormula.getSubformula());
                    arrayList.add((Term)termVariable2);
                }
            } else {
                arrayList.add(term2);
            }
            ++n3;
        }
        term2 = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), n, arrayList);
        Term term4 = SmtUtils.quantifier(managedScript.getScript(), n, linkedHashMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet()), term2);
        return term4;
    }

    public static Term pushDualQuantifiersInParams(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask eliminationTask, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator) {
        Term term;
        Object object;
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        assert (termArray.length > 1) : "not dual finite connective";
        ArrayList<Term> arrayList = new ArrayList<Term>();
        boolean bl2 = false;
        int n = 0;
        while (n < termArray.length) {
            if (termArray[n] instanceof QuantifiedFormula) {
                object = eliminationTask.getContext().constructChildContextForQuantifiedFormula(managedScript.getScript(), eliminationTask.getEliminatees());
                Context context = ((Context)object).constructChildContextForConDis(iUltimateServiceProvider, managedScript, ((ApplicationTerm)eliminationTask.getTerm()).getFunction(), Arrays.asList(termArray), n);
                Term term2 = iQuantifierEliminator.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, context, termArray[n]);
                if (term2 != termArray[n]) {
                    bl2 = true;
                }
                arrayList.add(term2);
            } else {
                arrayList.add(termArray[n]);
            }
            ++n;
        }
        if (bl2) {
            object = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), eliminationTask.getQuantifier(), arrayList);
            term = SmtUtils.quantifier(managedScript.getScript(), eliminationTask.getQuantifier(), eliminationTask.getEliminatees(), (Term)object);
        } else {
            term = null;
        }
        return term;
    }
}

