/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractor;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Collectors;

public class SMTFeatureExtractorScript
extends WrapperScript {
    private final SMTFeatureExtractor mFeatureExtractor;
    private final Deque<Term> mCurrentAssertionStack;
    private final ILogger mLogger;

    public SMTFeatureExtractorScript(Script script, ILogger iLogger, String string) {
        super(script);
        this.mLogger = iLogger;
        this.mFeatureExtractor = new SMTFeatureExtractor(iLogger, string, true);
        this.mCurrentAssertionStack = new ArrayDeque<Term>();
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mCurrentAssertionStack.add(term);
        return super.assertTerm(term);
    }

    public void push(int n) throws SMTLIBException {
        super.push(n);
        int n2 = n;
        while (n2 >= 0) {
            this.mCurrentAssertionStack.add(StackMarker.INSTANCE);
            --n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void pop(int var1_1) throws SMTLIBException {
        super.pop(var1_1);
        var2_2 = this.mCurrentAssertionStack.descendingIterator();
        var3_3 = null;
        var4_4 = var1_1;
        ** GOTO lbl11
        {
            var3_3 = var2_2.next();
            var2_2.remove();
            do {
                if (var3_3 != StackMarker.INSTANCE) continue block0;
                --var4_4;
lbl11:
                // 2 sources

            } while (var4_4 >= 0);
        }
    }

    public Script.LBool checkSat() throws SMTLIBException {
        double d = System.nanoTime();
        Script.LBool lBool = this.mScript.checkSat();
        double d2 = ((double)System.nanoTime() - d) / 1000.0;
        try {
            this.mFeatureExtractor.extractFeature(this.mCurrentAssertionStack.stream().filter(term -> term != StackMarker.INSTANCE).collect(Collectors.toList()), d2, lBool.toString(), this.mScript.getInfo(":name").toString());
        }
        catch (IOException | IllegalAccessException exception) {
            this.mLogger.error((Object)exception);
        }
        return lBool;
    }

    private static final class StackMarker
    extends Term {
        private static final StackMarker INSTANCE = new StackMarker();

        protected StackMarker() {
            super(-1);
        }

        public Sort getSort() {
            throw new UnsupportedOperationException();
        }

        protected void toStringHelper(ArrayDeque<Object> arrayDeque) {
            throw new UnsupportedOperationException();
        }
    }
}

