/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.symboltable;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieOnceVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.PreprocessorAnnotation;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;

public class BoogieSymbolTableConstructor
extends BoogieOnceVisitor
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private BoogieSymbolTable mSymbolTable;
    private Unit mRootNode;
    private DeclarationInformation.StorageClass mCurrentScope;
    private Declaration mCurrentDeclaration;
    private String mCurrentScopeName;

    public BoogieSymbolTableConstructor(ILogger iLogger) {
        this.mLogger = iLogger;
        this.mSymbolTable = new BoogieSymbolTable();
    }

    public void init(ModelType modelType, int n, int n2) throws Throwable {
        this.mCurrentScope = DeclarationInformation.StorageClass.GLOBAL;
        this.mCurrentDeclaration = null;
        this.mCurrentScopeName = null;
        this.mRootNode = null;
    }

    public void finish() throws Throwable {
        PreprocessorAnnotation preprocessorAnnotation = new PreprocessorAnnotation();
        preprocessorAnnotation.setSymbolTable(this.mSymbolTable);
        preprocessorAnnotation.annotate((IElement)this.mRootNode);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("SymbolTable\r" + this.mSymbolTable.prettyPrintSymbolTable()));
        }
        this.mSymbolTable = null;
    }

    public boolean performedChanges() {
        return false;
    }

    public BoogieSymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (iElement instanceof Unit) {
            return this.process((Unit)iElement);
        }
        return true;
    }

    public Boolean process(Unit unit) throws Throwable {
        this.mRootNode = unit;
        Declaration[] declarationArray = this.mRootNode.getDeclarations();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration declaration = declarationArray[n2];
            if (declaration instanceof VariableDeclaration || declaration instanceof ConstDeclaration) {
                this.mCurrentScope = DeclarationInformation.StorageClass.GLOBAL;
                this.mCurrentDeclaration = declaration;
            }
            this.processDeclaration(declaration);
            ++n2;
        }
        return false;
    }

    protected void visit(FunctionDeclaration functionDeclaration) {
        VarList varList;
        int n;
        int n2;
        Object[] objectArray;
        this.mCurrentDeclaration = functionDeclaration;
        this.mCurrentScope = DeclarationInformation.StorageClass.PROC_FUNC;
        this.mCurrentScopeName = functionDeclaration.getIdentifier();
        this.mSymbolTable.addProcedureOrFunction(functionDeclaration.getIdentifier(), functionDeclaration);
        if (functionDeclaration.getInParams() != null) {
            objectArray = functionDeclaration.getInParams();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                varList = objectArray[n];
                String[] stringArray = varList.getIdentifiers();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string = stringArray[n4];
                    this.mSymbolTable.addInParams(functionDeclaration.getIdentifier(), string, functionDeclaration);
                    ++n4;
                }
                ++n;
            }
        }
        if (functionDeclaration.getOutParam() != null) {
            objectArray = functionDeclaration.getOutParam().getIdentifiers();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                varList = objectArray[n];
                this.mSymbolTable.addOutParams(functionDeclaration.getIdentifier(), (String)varList, functionDeclaration);
                ++n;
            }
        }
        super.visit(functionDeclaration);
    }

    protected void visit(Procedure procedure) {
        String string;
        int n;
        int n2;
        String[] stringArray;
        VarList varList;
        int n3;
        int n4;
        VarList[] varListArray;
        this.mCurrentDeclaration = procedure;
        this.mCurrentScope = DeclarationInformation.StorageClass.PROC_FUNC;
        this.mCurrentScopeName = procedure.getIdentifier();
        this.mSymbolTable.addProcedureOrFunction(procedure.getIdentifier(), procedure);
        if (procedure.getInParams() != null) {
            varListArray = procedure.getInParams();
            n4 = varListArray.length;
            n3 = 0;
            while (n3 < n4) {
                varList = varListArray[n3];
                stringArray = varList.getIdentifiers();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    string = stringArray[n];
                    this.mSymbolTable.addInParams(procedure.getIdentifier(), string, procedure);
                    ++n;
                }
                ++n3;
            }
        }
        if (procedure.getOutParams() != null) {
            varListArray = procedure.getOutParams();
            n4 = varListArray.length;
            n3 = 0;
            while (n3 < n4) {
                varList = varListArray[n3];
                stringArray = varList.getIdentifiers();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    string = stringArray[n];
                    this.mSymbolTable.addOutParams(procedure.getIdentifier(), string, procedure);
                    ++n;
                }
                ++n3;
            }
        }
        super.visit(procedure);
    }

    protected VariableDeclaration processLocalVariableDeclaration(VariableDeclaration variableDeclaration) {
        this.mCurrentDeclaration = variableDeclaration;
        this.mCurrentScope = DeclarationInformation.StorageClass.LOCAL;
        return super.processLocalVariableDeclaration(variableDeclaration);
    }

    protected VarList processVarList(VarList varList) {
        switch (this.mCurrentScope) {
            case LOCAL: {
                String[] stringArray = varList.getIdentifiers();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    this.mSymbolTable.addLocalVariable(this.mCurrentScopeName, string, this.mCurrentDeclaration);
                    ++n2;
                }
                break;
            }
            case GLOBAL: {
                String[] stringArray = varList.getIdentifiers();
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String string = stringArray[n3];
                    this.mSymbolTable.addGlobalVariable(string, this.mCurrentDeclaration);
                    ++n3;
                }
                break;
            }
            case QUANTIFIED: 
            case PROC_FUNC: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Extend this method for the new scope %s", this.mCurrentScope));
            }
        }
        return super.processVarList(varList);
    }

    protected Expression processExpression(Expression expression) {
        if (expression instanceof QuantifierExpression) {
            this.mCurrentScope = DeclarationInformation.StorageClass.QUANTIFIED;
        }
        return super.processExpression(expression);
    }
}

