/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.Objects;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class Log4JWrapper
implements ILogger {
    private static final Level[] sILoggerLevelToLog4jLevel = new Level[]{Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL, Level.OFF};
    private static final String FQCN = ILogger.class.getName();
    private final Logger mLogger;

    public Log4JWrapper(Logger logger) {
        this.mLogger = logger;
    }

    Logger getBacking() {
        return this.mLogger;
    }

    public void fatal(Object object, Throwable throwable) {
        this.mLogger.log(FQCN, (Priority)Level.FATAL, object, throwable);
    }

    public void error(Object object, Throwable throwable) {
        this.mLogger.log(FQCN, (Priority)Level.ERROR, object, throwable);
    }

    public void log(ILogger.LogLevel logLevel, String string) {
        this.mLogger.log(FQCN, (Priority)Log4JWrapper.translateLevel(logLevel), (Object)string, null);
    }

    public int hashCode() {
        return Objects.hash(this.mLogger);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Log4JWrapper log4JWrapper = (Log4JWrapper)object;
        return Objects.equals(this.mLogger, log4JWrapper.mLogger);
    }

    public String toString() {
        return "[" + this.hashCode() + "][" + String.valueOf(this.getBacking().getLevel()) + "] " + this.getBacking().getName();
    }

    public void setLevel(ILogger.LogLevel logLevel) {
        this.mLogger.setLevel(Log4JWrapper.translateLevel(logLevel));
    }

    public boolean isLogLevelEnabled(ILogger.LogLevel logLevel) {
        return this.mLogger.isEnabledFor((Priority)Log4JWrapper.translateLevel(logLevel));
    }

    private static Level translateLevel(ILogger.LogLevel logLevel) {
        if (logLevel.ordinal() >= sILoggerLevelToLog4jLevel.length) {
            throw new UnsupportedOperationException("Unknown LogLevel " + String.valueOf(logLevel));
        }
        return sILoggerLevelToLog4jLevel[logLevel.ordinal()];
    }
}

