/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.RcpProgressMonitorWrapper;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.BasicToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ExceptionOrErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExternalParserToolchainJob
extends BasicToolchainJob {
    private final IElement mAST;
    private final ModelType mOutputDefinition;

    public ExternalParserToolchainJob(String string, ICore<RunDefinition> iCore, IController<RunDefinition> iController, IElement iElement, ModelType modelType, ILogger iLogger) {
        super(string, iCore, iController, iLogger);
        this.mAST = iElement;
        this.mOutputDefinition = modelType;
    }

    @Override
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        IToolchainData iToolchainData;
        IToolchain iToolchain;
        IStatus iStatus;
        IToolchainProgressMonitor iToolchainProgressMonitor;
        block5: {
            iToolchainProgressMonitor = RcpProgressMonitorWrapper.create(iProgressMonitor);
            iStatus = Status.OK_STATUS;
            iToolchainProgressMonitor.beginTask(this.getName(), -1);
            iToolchain = null;
            iToolchainProgressMonitor.worked(1);
            iToolchain = this.mCore.requestToolchain(new File[0]);
            iToolchain.init(iToolchainProgressMonitor);
            iToolchainProgressMonitor.worked(1);
            iToolchainData = iToolchain.makeToolSelection(iToolchainProgressMonitor);
            if (iToolchainData != null) break block5;
            this.mLogger.warn((Object)"Toolchain selection failed, aborting...");
            Status status = new Status(8, "de.uni_freiburg.informatik.ultimate.core", "Toolchain selection canceled");
            iToolchainProgressMonitor.worked(1);
            this.releaseToolchain((IToolchain<RunDefinition>)iToolchain);
            iToolchainProgressMonitor.done();
            return status;
        }
        try {
            try {
                this.setServices(iToolchainData.getServices());
                iToolchainProgressMonitor.worked(1);
                iToolchain.addAST(this.mAST, this.mOutputDefinition);
                iToolchainProgressMonitor.worked(1);
                iStatus = this.convert(iToolchain.processToolchain(iToolchainProgressMonitor));
            }
            catch (Throwable throwable) {
                this.mLogger.fatal((Object)String.format("The toolchain threw an exception: %s", throwable.getMessage()));
                this.mLogger.fatal((Object)throwable);
                this.mController.displayException(iToolchain, "The toolchain threw an exception", throwable);
                iStatus = Status.CANCEL_STATUS;
                this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new ExceptionOrErrorResult("de.uni_freiburg.informatik.ultimate.core", throwable));
                iToolchainProgressMonitor.worked(1);
                this.releaseToolchain((IToolchain<RunDefinition>)iToolchain);
                iToolchainProgressMonitor.done();
            }
        }
        catch (Throwable throwable) {
            iToolchainProgressMonitor.worked(1);
            this.releaseToolchain(iToolchain);
            iToolchainProgressMonitor.done();
            throw throwable;
        }
        iToolchainProgressMonitor.worked(1);
        this.releaseToolchain((IToolchain<RunDefinition>)iToolchain);
        iToolchainProgressMonitor.done();
        return iStatus;
    }

    protected void releaseToolchain(IToolchain<RunDefinition> iToolchain) {
        this.mCore.releaseToolchain(iToolchain);
    }
}

