/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2;

import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.AbstractInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;

public class AbstractInterpretationRcfgObserver
extends BaseObserver {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;

    public AbstractInterpretationRcfgObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public boolean process(IElement iElement) throws Throwable {
        if (!(iElement instanceof BoogieIcfgContainer)) {
            throw new IllegalArgumentException("You cannot use this observer for " + iElement.getClass().getSimpleName());
        }
        BoogieIcfgContainer boogieIcfgContainer = (BoogieIcfgContainer)iElement;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        Object object = iPreferenceProvider.getBoolean("Run as pre-analysis") ? this.mServices.getProgressMonitorService().getChildTimer(0.2) : this.mServices.getProgressMonitorService();
        if (iPreferenceProvider.getBoolean("Use the RCFG-of-the-future interface")) {
            AbstractInterpreter.runFuture(boogieIcfgContainer, (IProgressAwareTimer)object, this.mServices, false, this.mLogger);
        } else {
            AbstractInterpreter.run((IIcfg<? extends IcfgLocation>)boogieIcfgContainer, (IProgressAwareTimer)object, this.mServices);
        }
        return false;
    }
}

