/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IVariableProvider;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.FixpointEngineParameters;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IAbstractStateStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IDebugHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IFixpointEngine;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ILoopDetector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.LoggingHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.SummaryMap;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.WorklistItem;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FixpointEngine<STATE extends IAbstractState<STATE>, ACTION, VARDECL, LOC>
implements IFixpointEngine<STATE, ACTION, VARDECL, LOC> {
    private final int mMaxUnwindings;
    private final int mMaxParallelStates;
    private final ITransitionProvider<ACTION, LOC> mTransitionProvider;
    private final IAbstractStateStorage<STATE, ACTION, LOC> mStateStorage;
    private final IAbstractDomain<STATE, ACTION> mDomain;
    private final IVariableProvider<STATE, ACTION> mVarProvider;
    private final ILoopDetector<ACTION> mLoopDetector;
    private final IDebugHelper<STATE, ACTION, VARDECL, LOC> mDebugHelper;
    private final IProgressAwareTimer mTimer;
    private final ILogger mLogger;
    private AbsIntResult<STATE, ACTION, LOC> mResult;
    private final SummaryMap<STATE, ACTION, LOC> mSummaryMap;
    private final boolean mUseHierachicalPre;

    public FixpointEngine(FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> fixpointEngineParameters) {
        if (fixpointEngineParameters == null || !fixpointEngineParameters.isValid()) {
            throw new IllegalArgumentException("invalid params");
        }
        this.mTimer = fixpointEngineParameters.getTimer();
        this.mLogger = fixpointEngineParameters.getLogger();
        this.mTransitionProvider = fixpointEngineParameters.getTransitionProvider();
        this.mStateStorage = fixpointEngineParameters.getStorage();
        this.mDomain = fixpointEngineParameters.getAbstractDomain();
        this.mVarProvider = fixpointEngineParameters.getVariableProvider();
        this.mLoopDetector = fixpointEngineParameters.getLoopDetector();
        this.mDebugHelper = fixpointEngineParameters.getDebugHelper();
        this.mMaxUnwindings = fixpointEngineParameters.getMaxUnwindings();
        this.mMaxParallelStates = fixpointEngineParameters.getMaxParallelStates();
        this.mSummaryMap = new SummaryMap(this.mTransitionProvider, this.mLogger);
        this.mUseHierachicalPre = this.mDomain.useHierachicalPre();
    }

    @Override
    public AbsIntResult<STATE, ACTION, LOC> run(Collection<? extends LOC> collection, Script script) {
        this.mLogger.info((Object)("Starting fixpoint engine with domain " + this.mDomain.getClass().getSimpleName() + " (maxUnwinding=" + this.mMaxUnwindings + ", maxParallelStates=" + this.mMaxParallelStates + ")"));
        this.mResult = new AbsIntResult<STATE, ACTION, LOC>(script, this.mDomain, this.mTransitionProvider, this.mVarProvider);
        this.mDomain.beforeFixpointComputation(new Object[]{this.mResult.getBenchmark()});
        this.calculateFixpoint(collection);
        this.mResult.saveRootStorage(this.mStateStorage);
        this.mResult.saveSummaryStorage(this.mSummaryMap);
        this.mLogger.debug((Object)"Fixpoint computation completed");
        this.mDomain.afterFixpointComputation(this.mResult);
        return this.mResult;
    }

    private void calculateFixpoint(Collection<? extends LOC> collection) {
        ArrayDeque<WorklistItem<STATE, ACTION, VARDECL, LOC>> arrayDeque = new ArrayDeque<WorklistItem<STATE, ACTION, VARDECL, LOC>>();
        IAbstractPostOperator iAbstractPostOperator = this.mDomain.getPostOperator();
        IAbstractStateBinaryOperator iAbstractStateBinaryOperator = this.mDomain.getWideningOperator();
        HashSet hashSet = new HashSet();
        collection.stream().flatMap(object -> this.mTransitionProvider.getSuccessorActions(object).stream()).filter(object -> !this.mTransitionProvider.isSummaryWithImplementation(object)).map(this::createInitialWorklistItem).forEach(arrayDeque::add);
        while (!arrayDeque.isEmpty()) {
            DisjunctiveAbstractState<STATE> disjunctiveAbstractState;
            this.checkTimeout();
            WorklistItem worklistItem = (WorklistItem)arrayDeque.removeFirst();
            this.mResult.getBenchmark().addIteration(worklistItem.getAction());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageCurrentTransition(worklistItem));
            }
            if (this.isUnnecessaryPostState(worklistItem, disjunctiveAbstractState = this.calculateAbstractPost(worklistItem, iAbstractPostOperator))) continue;
            this.checkLoopState(worklistItem);
            this.checkReachedError(worklistItem, disjunctiveAbstractState, hashSet);
            DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = this.widenIfNecessary(worklistItem, disjunctiveAbstractState, iAbstractStateBinaryOperator);
            if (disjunctiveAbstractState2 == null) {
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)"    Skipping successors because post state is already contained");
                continue;
            }
            this.logDebugPostChanged(disjunctiveAbstractState, disjunctiveAbstractState2, "Widening");
            DisjunctiveAbstractState<STATE> disjunctiveAbstractState3 = this.savePostState(worklistItem, disjunctiveAbstractState2);
            assert (disjunctiveAbstractState3 != null) : "Saving a state is not allowed to return null";
            this.logDebugPostChanged(disjunctiveAbstractState2, disjunctiveAbstractState3, "Merge");
            List<WorklistItem<STATE, ACTION, VARDECL, LOC>> list = this.createSuccessorItems(worklistItem, disjunctiveAbstractState3);
            arrayDeque.addAll(list);
        }
    }

    private boolean useSummaryInstead(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, Deque<WorklistItem<STATE, ACTION, VARDECL, LOC>> deque) {
        ACTION ACTION = worklistItem.getAction();
        if (!this.mTransitionProvider.isEnteringScope(ACTION)) {
            return false;
        }
        ACTION ACTION2 = this.mTransitionProvider.getSummaryForCall(ACTION);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = worklistItem.getSummaryPostState(ACTION2, disjunctiveAbstractState);
        if (disjunctiveAbstractState2 == null) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("    No summary available for " + String.valueOf(LoggingHelper.getTransitionString(ACTION, this.mTransitionProvider))));
            }
            return false;
        }
        if (disjunctiveAbstractState2.isBottom()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("    The summary for " + String.valueOf(LoggingHelper.getTransitionString(ACTION, this.mTransitionProvider)) + " is bottom"));
            }
            return true;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("    Using summary for " + String.valueOf(LoggingHelper.getTransitionString(ACTION, this.mTransitionProvider))));
            this.mLogger.debug((Object)("       Using " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState2))));
            this.mLogger.debug((Object)("       Instead of " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState))));
        }
        WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem2 = worklistItem.createSummarySubstitution(disjunctiveAbstractState2, ACTION2);
        deque.add(worklistItem2);
        return true;
    }

    private DisjunctiveAbstractState<STATE> calculateAbstractPost(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem, IAbstractPostOperator<STATE, ACTION> iAbstractPostOperator) {
        DisjunctiveAbstractState disjunctiveAbstractState;
        DisjunctiveAbstractState disjunctiveAbstractState2;
        DisjunctiveAbstractState disjunctiveAbstractState3 = worklistItem.getState();
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState4 = worklistItem.getHierachicalState();
        ACTION ACTION = worklistItem.getAction();
        if (this.mTransitionProvider.isEnteringScope(ACTION) || this.mTransitionProvider.isLeavingScope(ACTION)) {
            disjunctiveAbstractState2 = disjunctiveAbstractState3.defineVariablesAfter(this.mVarProvider, ACTION, disjunctiveAbstractState4);
            this.mResult.getBenchmark().addMaxVariables(disjunctiveAbstractState2.getVariables().size());
            disjunctiveAbstractState = this.mUseHierachicalPre && this.mTransitionProvider.isLeavingScope(ACTION) ? disjunctiveAbstractState4.apply(iAbstractPostOperator, disjunctiveAbstractState3, ACTION) : disjunctiveAbstractState2.apply(iAbstractPostOperator, disjunctiveAbstractState3, ACTION);
            this.isHierachicalPostResultBottom(disjunctiveAbstractState, worklistItem);
        } else {
            disjunctiveAbstractState2 = disjunctiveAbstractState3;
            disjunctiveAbstractState = disjunctiveAbstractState3.apply(iAbstractPostOperator, ACTION);
        }
        this.mResult.getBenchmark().countPostApplication();
        assert (disjunctiveAbstractState != null);
        assert (this.assertIsPostSound(disjunctiveAbstractState3, ACTION, disjunctiveAbstractState2, disjunctiveAbstractState4, disjunctiveAbstractState)) : "Post is unsound";
        disjunctiveAbstractState = this.prepareScope(worklistItem, disjunctiveAbstractState);
        assert (disjunctiveAbstractState != null);
        return disjunctiveAbstractState;
    }

    private boolean assertIsPostSound(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, DisjunctiveAbstractState<STATE> disjunctiveAbstractState3, DisjunctiveAbstractState<STATE> disjunctiveAbstractState4) {
        boolean bl;
        boolean bl2 = bl = this.mTransitionProvider.isSummaryWithImplementation(ACTION) || this.mDebugHelper.isPostSound(disjunctiveAbstractState, disjunctiveAbstractState3, disjunctiveAbstractState4, ACTION);
        if (bl) {
            return true;
        }
        this.mLogger.fatal((Object)"Post is unsound because the term-transformation of the following triple is not valid: ");
        this.mLogger.fatal((Object)("PreBL : " + disjunctiveAbstractState.toLogString()));
        this.mLogger.fatal((Object)("PreH  : " + disjunctiveAbstractState3.toLogString()));
        if (disjunctiveAbstractState != disjunctiveAbstractState2) {
            this.mLogger.fatal((Object)("PreAL : " + disjunctiveAbstractState2.toLogString()));
        }
        this.mLogger.fatal((Object)("Action: " + this.mTransitionProvider.toLogString(ACTION) + " (to " + this.mTransitionProvider.getProcedureName(ACTION) + ")"));
        if (disjunctiveAbstractState4 != null) {
            this.mLogger.fatal((Object)("Post  :  " + disjunctiveAbstractState4.toLogString()));
        }
        return false;
    }

    private boolean isUnnecessaryPostState(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        if (disjunctiveAbstractState.isBottom()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessagePostIsBottom(disjunctiveAbstractState));
            }
            return true;
        }
        IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage = worklistItem.getCurrentStorage();
        if (this.checkSubset(iAbstractStateStorage, worklistItem.getAction(), disjunctiveAbstractState)) {
            this.mResult.getBenchmark().addFixpoint();
            return true;
        }
        return false;
    }

    private boolean isHierachicalPostResultBottom(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, WorklistItem<?, ?, ?, ?> worklistItem) {
        if (disjunctiveAbstractState.isBottom()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Predecessor sequence of current worklist item: " + CoreUtil.getPlatformLineSeparator() + LoggingHelper.getPrecedessorSequence(worklistItem)));
            }
            return false;
        }
        return true;
    }

    private void checkLoopState(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem) {
        ACTION ACTION = worklistItem.getAction();
        if (this.mLoopDetector.isEnteringLoop(ACTION)) {
            LOC LOC = this.mTransitionProvider.getSource(ACTION);
            int n = worklistItem.enterLoop(LOC);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageEnterLoop(n, LOC, worklistItem.getState()));
            }
        }
    }

    private DisjunctiveAbstractState<STATE> savePostState(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2;
        IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage = worklistItem.getCurrentStorage();
        ACTION ACTION = worklistItem.getAction();
        LOC LOC = this.mTransitionProvider.getTarget(ACTION);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.getLogMessageNewPostState(disjunctiveAbstractState));
        }
        if ((disjunctiveAbstractState2 = iAbstractStateStorage.addAbstractState(LOC, disjunctiveAbstractState)) != disjunctiveAbstractState) {
            this.mResult.getBenchmark().addMerge();
        }
        return disjunctiveAbstractState2;
    }

    private void checkReachedError(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, Set<ACTION> set) {
        ACTION ACTION = worklistItem.getAction();
        LOC LOC = this.mTransitionProvider.getTarget(ACTION);
        if (!this.mTransitionProvider.isErrorLocation(LOC) || disjunctiveAbstractState.isBottom() || !set.add(ACTION)) {
            return;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)new StringBuilder().append("   ").append(" Error state reached"));
        }
        this.mResult.reachedError(this.mTransitionProvider, worklistItem, disjunctiveAbstractState);
    }

    private WorklistItem<STATE, ACTION, VARDECL, LOC> createInitialWorklistItem(ACTION ACTION) {
        IAbstractState iAbstractState = this.mVarProvider.defineInitialVariables(ACTION, this.mDomain.createTopState());
        assert (iAbstractState != null);
        DisjunctiveAbstractState disjunctiveAbstractState = new DisjunctiveAbstractState(this.mMaxParallelStates, iAbstractState);
        return new WorklistItem(disjunctiveAbstractState, ACTION, this.mStateStorage, this.mSummaryMap);
    }

    private List<WorklistItem<STATE, ACTION, VARDECL, LOC>> createSuccessorItems(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        ACTION ACTION = worklistItem.getAction();
        Collection<ACTION> collection = this.mTransitionProvider.getSuccessors(ACTION, worklistItem.getCurrentScope());
        if (collection.isEmpty()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)new StringBuilder().append("   ").append(" No successors"));
            }
            return Collections.emptyList();
        }
        List<WorklistItem<STATE, ACTION, VARDECL, LOC>> list = collection.stream().filter(object -> !this.mTransitionProvider.isSummaryWithImplementation(object)).map(object -> new WorklistItem(disjunctiveAbstractState, object, worklistItem)).collect(Collectors.toList());
        if (this.mLogger.isDebugEnabled()) {
            for (WorklistItem worklistItem2 : list) {
                this.mLogger.debug((Object)this.getLogMessageAddTransition(worklistItem2));
            }
        }
        return list;
    }

    private DisjunctiveAbstractState<STATE> widenIfNecessary(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, IAbstractStateBinaryOperator<STATE> iAbstractStateBinaryOperator) {
        DisjunctiveAbstractState disjunctiveAbstractState2;
        DisjunctiveAbstractState disjunctiveAbstractState3;
        ACTION ACTION = worklistItem.getAction();
        LOC LOC = this.mTransitionProvider.getTarget(ACTION);
        Pair<Integer, DisjunctiveAbstractState<STATE>> pair = worklistItem.getLoopPair(LOC);
        boolean bl = false;
        if (pair != null && (Integer)pair.getFirst() > this.mMaxUnwindings) {
            disjunctiveAbstractState3 = (DisjunctiveAbstractState)pair.getSecond();
        } else if (this.mTransitionProvider.isEnteringScope(ACTION)) {
            disjunctiveAbstractState3 = this.getWidenStateAtScopeEntry(worklistItem);
            bl = true;
        } else {
            disjunctiveAbstractState3 = null;
        }
        if (disjunctiveAbstractState3 == null) {
            return disjunctiveAbstractState;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"      Applying widening op:");
            this.mLogger.debug((Object)("      Op1: " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState3))));
            this.mLogger.debug((Object)("      Op2: " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState))));
        }
        if (this.isFixpoint(disjunctiveAbstractState3, disjunctiveAbstractState2 = disjunctiveAbstractState3.widen(iAbstractStateBinaryOperator, disjunctiveAbstractState))) {
            if (bl) {
                worklistItem.getCurrentStorage().scopeFixpointReached();
            }
            return null;
        }
        this.mResult.getBenchmark().addWiden();
        return disjunctiveAbstractState2;
    }

    private DisjunctiveAbstractState<STATE> prepareScope(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        ACTION ACTION = worklistItem.getAction();
        if (this.mTransitionProvider.isEnteringScope(ACTION)) {
            worklistItem.addScope(ACTION, disjunctiveAbstractState);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageEnterScope(worklistItem));
            }
            return disjunctiveAbstractState;
        }
        if (this.isLeavingScope(worklistItem)) {
            ACTION ACTION2 = worklistItem.removeCurrentScope(worklistItem.getState());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageLeaveScope(ACTION2, worklistItem));
            }
            return disjunctiveAbstractState;
        }
        return disjunctiveAbstractState;
    }

    private boolean isLeavingScope(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem) {
        return this.mTransitionProvider.isLeavingScope(worklistItem.getAction(), worklistItem.getCurrentScope());
    }

    private DisjunctiveAbstractState<STATE> getWidenStateAtScopeEntry(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem) {
        List list;
        Object ACTION = worklistItem.getAction();
        Deque<Pair<ACTION, DisjunctiveAbstractState<STATE>>> deque = worklistItem.getScopeWideningStack();
        Optional<Long> optional = deque.stream().map(pair -> pair.getFirst()).filter(object -> object != null).collect(Collectors.groupingBy(object -> object, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L || entry.getKey() == ACTION).map(entry -> (Long)entry.getValue()).reduce((l, l2) -> l + l2);
        if (!optional.isPresent() || optional.get() <= (long)this.mMaxUnwindings) {
            return null;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("       Scope widening sequence for " + String.valueOf(LoggingHelper.getTransitionString(ACTION, this.mTransitionProvider)) + " (MaxUnwindings=" + this.mMaxUnwindings + ")"));
            this.mLogger.debug((Object)"       Stack");
            ((Stream)deque.stream().sequential()).map(pair -> pair.getFirst()).map(object -> object == null ? "[G]" : LoggingHelper.getTransitionString(object, this.mTransitionProvider)).map(serializable -> "         " + String.valueOf(serializable)).forEach(arg_0 -> ((ILogger)this.mLogger).debug(arg_0));
        }
        if ((list = ((Stream)deque.stream().sequential()).filter(pair -> pair.getFirst() == ACTION).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"      Relevant stack states");
            ((Stream)list.stream().sequential()).map(pair -> "         " + String.valueOf(pair.getFirst() == null ? "[G]" : LoggingHelper.getHashCodeString(pair.getFirst())) + " " + String.valueOf(LoggingHelper.getHashCodeString(pair.getSecond())) + " " + ((DisjunctiveAbstractState)pair.getSecond()).toString()).forEach(arg_0 -> ((ILogger)this.mLogger).debug(arg_0));
        }
        int n = list.size();
        int n2 = n - 2;
        if (n - this.mMaxUnwindings < 0 || n2 < 0) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"      not enough states to widen");
            }
            return null;
        }
        DisjunctiveAbstractState disjunctiveAbstractState = (DisjunctiveAbstractState)((Pair)list.get(n2)).getSecond();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("      Selected " + String.valueOf(LoggingHelper.getHashCodeString(disjunctiveAbstractState))));
        }
        return disjunctiveAbstractState;
    }

    private boolean isFixpoint(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        if (disjunctiveAbstractState.isEqualTo(disjunctiveAbstractState2)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageFixpointFound(disjunctiveAbstractState, disjunctiveAbstractState2));
            }
            this.mResult.getBenchmark().addFixpoint();
            return true;
        }
        return false;
    }

    private boolean checkSubset(IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage, ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        LOC LOC = this.mTransitionProvider.getTarget(ACTION);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = iAbstractStateStorage.getAbstractState(LOC);
        assert (disjunctiveAbstractState2 == null || Objects.equals(disjunctiveAbstractState.getVariables(), disjunctiveAbstractState2.getVariables())) : "States in the same scope have different variables";
        if (disjunctiveAbstractState == disjunctiveAbstractState2 || disjunctiveAbstractState.isSubsetOf(disjunctiveAbstractState2) != IAbstractState.SubsetResult.NONE) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessagePostIsSubsumed(disjunctiveAbstractState, disjunctiveAbstractState2));
            }
            return true;
        }
        return false;
    }

    private void checkTimeout() {
        if (!this.mTimer.continueProcessing()) {
            this.mLogger.warn((Object)"Received timeout, aborting fixpoint engine");
            throw new ToolchainCanceledException(this.getClass(), "executing abstract interpretation");
        }
    }

    private void logDebugPostChanged(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, String string) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        if (disjunctiveAbstractState == disjunctiveAbstractState2) {
            return;
        }
        this.mLogger.debug((Object)("      " + string));
        this.mLogger.debug((Object)("      Before: " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState))));
        this.mLogger.debug((Object)("      After: " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState2))));
    }

    private StringBuilder getLogMessagePostIsBottom(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return new StringBuilder().append("   ").append(" Skipping all successors because post state [").append(disjunctiveAbstractState.hashCode()).append("] is bottom");
    }

    private StringBuilder getLogMessagePostIsSubsumed(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        return new StringBuilder().append("   ").append(" Skipping all successors because post state ").append((CharSequence)LoggingHelper.getStateString(disjunctiveAbstractState)).append(" is subsumed by pre-existing state ").append((CharSequence)LoggingHelper.getStateString(disjunctiveAbstractState2));
    }

    private StringBuilder getLogMessageLeaveScope(ACTION ACTION, WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem) {
        return new StringBuilder().append("   ").append(" Transition [").append(worklistItem.getAction().hashCode()).append("] leaves scope ").append((CharSequence)LoggingHelper.getHashCodeString(ACTION)).append(" (new depth=").append(worklistItem.getScopeStackDepth()).append("): ").append(LoggingHelper.getScopeStackString(worklistItem.getScopeStack()));
    }

    private StringBuilder getLogMessageEnterScope(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem) {
        return new StringBuilder().append("   ").append(" Transition [").append(worklistItem.getAction().hashCode()).append("] enters scope (new depth=").append(worklistItem.getScopeStackDepth()).append("): ").append(LoggingHelper.getScopeStackString(worklistItem.getScopeStack()));
    }

    private StringBuilder getLogMessageFixpointFound(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        return new StringBuilder().append("   ").append(" State [").append(disjunctiveAbstractState.hashCode()).append("] ").append(disjunctiveAbstractState.toLogString()).append(" is equal to [").append(disjunctiveAbstractState2.hashCode()).append("]");
    }

    private StringBuilder getLogMessageNewPostState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return new StringBuilder().append("   ").append(" Adding post state [").append(disjunctiveAbstractState.hashCode()).append("] ").append(disjunctiveAbstractState.toLogString());
    }

    private StringBuilder getLogMessageEnterLoop(int n, LOC LOC, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return new StringBuilder().append("   ").append(" Entering loop ").append(LOC).append(" (").append(n).append("), saving ").append((CharSequence)LoggingHelper.getStateString(disjunctiveAbstractState));
    }

    private StringBuilder getLogMessageCurrentTransition(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState = worklistItem.getState();
        ACTION ACTION = worklistItem.getAction();
        int n = worklistItem.getScopeStackDepth();
        String string = disjunctiveAbstractState == null ? "NULL" : LoggingHelper.getStateString(disjunctiveAbstractState).toString();
        return LoggingHelper.getTransitionString(ACTION, this.mTransitionProvider).append(" processing for pre state ").append(string).append(" (depth=").append(n).append(")");
    }

    private StringBuilder getLogMessageAddTransition(WorklistItem<STATE, ACTION, VARDECL, LOC> worklistItem) {
        return new StringBuilder().append("   ").append(" Adding [").append(worklistItem.getState().hashCode()).append("]").append(" --[").append(worklistItem.getAction().hashCode()).append("]->");
    }
}

