/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IVariableProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IAbstractStateStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IDebugHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ILoopDetector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;

public class FixpointEngineParameters<STATE extends IAbstractState<STATE>, ACTION, VARDECL, LOC> {
    private final ITransitionProvider<ACTION, LOC> mTransitionProvider;
    private final IAbstractStateStorage<STATE, ACTION, LOC> mStorage;
    private final IVariableProvider<STATE, ACTION> mVarProvider;
    private final ILoopDetector<ACTION> mLoopDetector;
    private final IAbstractDomain<STATE, ACTION> mDomain;
    private final IDebugHelper<STATE, ACTION, VARDECL, LOC> mDebugHelper;
    private final IProgressAwareTimer mTimer;
    private final int mMaxUnwindings;
    private final int mMaxParallelStates;
    private final ILogger mLogger;

    private FixpointEngineParameters(ITransitionProvider<ACTION, LOC> iTransitionProvider, IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage, IVariableProvider<STATE, ACTION> iVariableProvider, ILoopDetector<ACTION> iLoopDetector, IAbstractDomain<STATE, ACTION> iAbstractDomain, IDebugHelper<STATE, ACTION, VARDECL, LOC> iDebugHelper, IUltimateServiceProvider iUltimateServiceProvider) {
        if (iUltimateServiceProvider == null) {
            throw new IllegalArgumentException("services may not be null");
        }
        this.mTransitionProvider = iTransitionProvider;
        this.mStorage = iAbstractStateStorage;
        this.mVarProvider = iVariableProvider;
        this.mLoopDetector = iLoopDetector;
        this.mDomain = iAbstractDomain;
        this.mDebugHelper = iDebugHelper;
        this.mTimer = iUltimateServiceProvider.getProgressMonitorService();
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mMaxUnwindings = iPreferenceProvider.getInt("Minimum iterations before widening");
        this.mMaxParallelStates = iPreferenceProvider.getInt("Parallel states before merging");
    }

    private FixpointEngineParameters(ITransitionProvider<ACTION, LOC> iTransitionProvider, IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage, IVariableProvider<STATE, ACTION> iVariableProvider, ILoopDetector<ACTION> iLoopDetector, IAbstractDomain<STATE, ACTION> iAbstractDomain, IDebugHelper<STATE, ACTION, VARDECL, LOC> iDebugHelper, IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, int n, int n2) {
        this.mTransitionProvider = iTransitionProvider;
        this.mStorage = iAbstractStateStorage;
        this.mVarProvider = iVariableProvider;
        this.mLoopDetector = iLoopDetector;
        this.mDomain = iAbstractDomain;
        this.mDebugHelper = iDebugHelper;
        this.mTimer = iProgressAwareTimer;
        this.mLogger = iLogger;
        this.mMaxUnwindings = n;
        this.mMaxParallelStates = n2;
    }

    public FixpointEngineParameters(IUltimateServiceProvider iUltimateServiceProvider, Class<VARDECL> clazz) {
        this(null, null, null, null, null, null, iUltimateServiceProvider);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setTransitionProvider(ITransitionProvider<ACTION, LOC> iTransitionProvider) {
        if (iTransitionProvider == null) {
            throw new IllegalArgumentException("transitionProvider may not be null");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(iTransitionProvider, this.mStorage, this.mVarProvider, this.mLoopDetector, this.mDomain, this.mDebugHelper, this.mTimer, this.mLogger, this.mMaxUnwindings, this.mMaxParallelStates);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setStorage(IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage) {
        if (iAbstractStateStorage == null) {
            throw new IllegalArgumentException("storage may not be null");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(this.mTransitionProvider, iAbstractStateStorage, this.mVarProvider, this.mLoopDetector, this.mDomain, this.mDebugHelper, this.mTimer, this.mLogger, this.mMaxUnwindings, this.mMaxParallelStates);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setVariableProvider(IVariableProvider<STATE, ACTION> iVariableProvider) {
        if (iVariableProvider == null) {
            throw new IllegalArgumentException("varProvider may not be null");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(this.mTransitionProvider, this.mStorage, iVariableProvider, this.mLoopDetector, this.mDomain, this.mDebugHelper, this.mTimer, this.mLogger, this.mMaxUnwindings, this.mMaxParallelStates);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setLoopDetector(ILoopDetector<ACTION> iLoopDetector) {
        if (iLoopDetector == null) {
            throw new IllegalArgumentException("loopDetector may not be null");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(this.mTransitionProvider, this.mStorage, this.mVarProvider, iLoopDetector, this.mDomain, this.mDebugHelper, this.mTimer, this.mLogger, this.mMaxUnwindings, this.mMaxParallelStates);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setDomain(IAbstractDomain<STATE, ACTION> iAbstractDomain) {
        if (iAbstractDomain == null) {
            throw new IllegalArgumentException("domain may not be null");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(this.mTransitionProvider, this.mStorage, this.mVarProvider, this.mLoopDetector, iAbstractDomain, this.mDebugHelper, this.mTimer, this.mLogger, this.mMaxUnwindings, this.mMaxParallelStates);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setDebugHelper(IDebugHelper<STATE, ACTION, VARDECL, LOC> iDebugHelper) {
        if (iDebugHelper == null) {
            throw new IllegalArgumentException("debugHelper may not be null");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(this.mTransitionProvider, this.mStorage, this.mVarProvider, this.mLoopDetector, this.mDomain, iDebugHelper, this.mTimer, this.mLogger, this.mMaxUnwindings, this.mMaxParallelStates);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setTimer(IProgressAwareTimer iProgressAwareTimer) {
        if (iProgressAwareTimer == null) {
            throw new IllegalArgumentException("timer may not be null");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(this.mTransitionProvider, this.mStorage, this.mVarProvider, this.mLoopDetector, this.mDomain, this.mDebugHelper, iProgressAwareTimer, this.mLogger, this.mMaxUnwindings, this.mMaxParallelStates);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setMaxUnwindings(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxUnwindings must be larger than zero");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(this.mTransitionProvider, this.mStorage, this.mVarProvider, this.mLoopDetector, this.mDomain, this.mDebugHelper, this.mTimer, this.mLogger, n, this.mMaxParallelStates);
    }

    public FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> setMaxParallelStates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxParallelStates must be larger than zero");
        }
        return new FixpointEngineParameters<STATE, ACTION, VARDECL, LOC>(this.mTransitionProvider, this.mStorage, this.mVarProvider, this.mLoopDetector, this.mDomain, this.mDebugHelper, this.mTimer, this.mLogger, this.mMaxUnwindings, n);
    }

    public boolean isValid() {
        if (this.getTransitionProvider() == null) {
            throw new IllegalArgumentException("Missing transition provider");
        }
        if (this.getStorage() == null) {
            throw new IllegalArgumentException("Missing storage");
        }
        if (this.getVariableProvider() == null) {
            throw new IllegalArgumentException("Missing variable provider");
        }
        if (this.getLoopDetector() == null) {
            throw new IllegalArgumentException("Missing loop detector");
        }
        if (this.getAbstractDomain() == null) {
            throw new IllegalArgumentException("Missing domain");
        }
        if (this.getDebugHelper() == null) {
            throw new IllegalArgumentException("Missing debug helper");
        }
        if (this.getTimer() == null) {
            throw new IllegalArgumentException("Missing timer");
        }
        if (this.getLogger() == null) {
            throw new IllegalArgumentException("Missing logger");
        }
        if (this.getMaxUnwindings() <= 0) {
            throw new IllegalArgumentException("Wrong value for max unwindings");
        }
        if (this.getMaxParallelStates() <= 0) {
            throw new IllegalArgumentException("Wrong value for max parallel states");
        }
        return true;
    }

    public ITransitionProvider<ACTION, LOC> getTransitionProvider() {
        return this.mTransitionProvider;
    }

    public IAbstractStateStorage<STATE, ACTION, LOC> getStorage() {
        return this.mStorage;
    }

    public IVariableProvider<STATE, ACTION> getVariableProvider() {
        return this.mVarProvider;
    }

    public ILoopDetector<ACTION> getLoopDetector() {
        return this.mLoopDetector;
    }

    public IAbstractDomain<STATE, ACTION> getAbstractDomain() {
        return this.mDomain;
    }

    public IDebugHelper<STATE, ACTION, VARDECL, LOC> getDebugHelper() {
        return this.mDebugHelper;
    }

    public IProgressAwareTimer getTimer() {
        return this.mTimer;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public int getMaxUnwindings() {
        return this.mMaxUnwindings;
    }

    public int getMaxParallelStates() {
        return this.mMaxParallelStates;
    }
}

