/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.BinaryExpressionEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.ConditionalEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.Evaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.FunctionEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluatorFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.NAryEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.SingletonBooleanExpressionEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.SingletonValueExpressionEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.SingletonVariableExpressionEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.UnaryExpressionEvaluator;
import java.math.BigDecimal;
import java.math.BigInteger;

public class EvaluatorFactory<VALUE extends INonrelationalValue<VALUE>, STATE extends NonrelationalState<STATE, VALUE>>
implements IEvaluatorFactory<VALUE, STATE> {
    private static final int ARITY_MIN = 1;
    private static final int ARITY_MAX = 2;
    private static final int BUFFER_MAX = 100;
    private final int mMaxParallelStates;
    private final int mMaxRecursionDepth;
    private final EvaluatorLogger mEvalLogger;
    private final INonrelationalValueFactory<VALUE> mNonrelationalValueFactory;
    private final Function<String, VALUE> mSingletonValueExpressionEvaluatorCreator;

    public EvaluatorFactory(ILogger iLogger, int n, int n2, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory, Function<String, VALUE> function) {
        this.mMaxParallelStates = n;
        this.mMaxRecursionDepth = n2;
        this.mNonrelationalValueFactory = iNonrelationalValueFactory;
        this.mSingletonValueExpressionEvaluatorCreator = function;
        this.mEvalLogger = new EvaluatorLogger(iLogger);
    }

    @Override
    public NAryEvaluator<VALUE, STATE> createNAryExpressionEvaluator(int n, EvaluatorUtils.EvaluatorType evaluatorType) {
        assert (n >= 1 && n <= 2);
        switch (n) {
            case 1: {
                return new UnaryExpressionEvaluator(this.mEvalLogger, this.mMaxRecursionDepth, this.mNonrelationalValueFactory);
            }
            case 2: {
                return new BinaryExpressionEvaluator(this.mEvalLogger, evaluatorType, this.mMaxParallelStates, this.mMaxRecursionDepth, this.mNonrelationalValueFactory);
            }
        }
        throw new UnsupportedOperationException(new StringBuilder(100).append("Arity of ").append(n).append(" is not implemented.").toString());
    }

    @Override
    public Evaluator<VALUE, STATE> createFunctionEvaluator(String string, int n, EvaluatorUtils.EvaluatorType evaluatorType) {
        return new FunctionEvaluator(string, n, this.mMaxRecursionDepth, this.mNonrelationalValueFactory, evaluatorType, this.mEvalLogger);
    }

    @Override
    public Evaluator<VALUE, STATE> createConditionalEvaluator() {
        return new ConditionalEvaluator(this.mMaxRecursionDepth, this.mNonrelationalValueFactory, this.mEvalLogger);
    }

    @Override
    public Evaluator<VALUE, STATE> createSingletonValueTopEvaluator(EvaluatorUtils.EvaluatorType evaluatorType) {
        return new SingletonValueExpressionEvaluator(this.mNonrelationalValueFactory.createTopValue(), evaluatorType, this.mMaxParallelStates, this.mNonrelationalValueFactory, this.mEvalLogger);
    }

    @Override
    public Evaluator<VALUE, STATE> createSingletonValueExpressionEvaluator(String string, Class<?> clazz) {
        EvaluatorUtils.EvaluatorType evaluatorType;
        assert (string != null);
        if (clazz == BigInteger.class) {
            evaluatorType = EvaluatorUtils.EvaluatorType.INTEGER;
        } else if (clazz == BigDecimal.class) {
            evaluatorType = EvaluatorUtils.EvaluatorType.REAL;
        } else if (clazz == Boolean.class) {
            evaluatorType = EvaluatorUtils.EvaluatorType.BOOL;
        } else {
            throw new IllegalArgumentException("Unknown type " + String.valueOf(clazz));
        }
        return new SingletonValueExpressionEvaluator((INonrelationalValue)this.mSingletonValueExpressionEvaluatorCreator.apply(string, clazz), evaluatorType, this.mMaxRecursionDepth, this.mNonrelationalValueFactory, this.mEvalLogger);
    }

    @Override
    public Evaluator<VALUE, STATE> createSingletonVariableExpressionEvaluator(IProgramVarOrConst iProgramVarOrConst) {
        assert (iProgramVarOrConst != null);
        return new SingletonVariableExpressionEvaluator(iProgramVarOrConst, this.mMaxRecursionDepth, this.mNonrelationalValueFactory, this.mEvalLogger);
    }

    @Override
    public Evaluator<VALUE, STATE> createSingletonLogicalValueExpressionEvaluator(BooleanValue booleanValue) {
        return new SingletonBooleanExpressionEvaluator(booleanValue, this.mMaxRecursionDepth, this.mNonrelationalValueFactory, this.mEvalLogger);
    }

    @FunctionalInterface
    public static interface Function<NAMETYPE, VALUETYPE> {
        public VALUETYPE apply(NAMETYPE var1, Class<?> var2);
    }
}

