/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class NestedWord<LETTER>
extends Word<LETTER> {
    public static final int INTERNAL_POSITION = -2;
    public static final int PLUS_INFINITY = Integer.MAX_VALUE;
    public static final int MINUS_INFINITY = Integer.MIN_VALUE;
    private static final String QUOTE_SPACE = "\" ";
    private static final char QUOTE = '\"';
    private static final String ACCESS_TO_POSITION = "Access to position ";
    private final int[] mNestingRelation;
    private Set<Integer> mCallPositions;
    private TreeMap<Integer, LETTER> mPendingReturns;

    public NestedWord(LETTER[] LETTERArray, int[] nArray) {
        super(LETTERArray);
        assert (NestedWord.assertValidNestedWord(LETTERArray, nArray));
        this.mNestingRelation = nArray;
    }

    public NestedWord() {
        super(new Object[0]);
        this.mNestingRelation = new int[0];
    }

    public NestedWord(LETTER LETTER, int n) {
        super(LETTER);
        if (!NestedWord.isSpecialNestingRelationIndex(n)) {
            throw new IllegalArgumentException("The only position has to be either internal, pending call, or pending return.");
        }
        this.mNestingRelation = new int[]{n};
    }

    private NestedWord(Word<LETTER> word) {
        super(new Object[word.length()]);
        int n = word.length();
        this.mNestingRelation = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.mWord[n2] = word.getSymbol(n2);
            this.mNestingRelation[n2] = -2;
            ++n2;
        }
    }

    public static <LETTER> NestedWord<LETTER> nestedWord(Word<LETTER> word) {
        if (word instanceof NestedWord) {
            return (NestedWord)word;
        }
        return new NestedWord<LETTER>(word);
    }

    public Set<Integer> getCallPositions() {
        if (this.mCallPositions == null) {
            this.mCallPositions = this.computeCallPositions();
        }
        return this.mCallPositions;
    }

    private Set<Integer> computeCallPositions() {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        int n = 0;
        while (n < this.mNestingRelation.length) {
            if (this.isCallPosition(n)) {
                linkedHashSet.add(n);
            }
            ++n;
        }
        return linkedHashSet;
    }

    public SortedMap<Integer, LETTER> getPendingReturns() {
        if (this.mPendingReturns == null) {
            this.mPendingReturns = this.computePendingReturnPositions();
        }
        return this.mPendingReturns;
    }

    private TreeMap<Integer, LETTER> computePendingReturnPositions() {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        int n = 0;
        while (n < this.mNestingRelation.length) {
            if (this.isPendingReturn(n)) {
                treeMap.put(n, this.mWord[n]);
            }
            ++n;
        }
        return treeMap;
    }

    private static boolean nestingRelationValuesInRange(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (!(n3 >= 0 && n3 < nArray.length || NestedWord.isSpecialNestingRelationIndex(n3))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean nestingRelationSymmetricNestingEdges(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0 && nArray[n] < nArray.length && nArray[nArray[n]] != n) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean nestingEdgesDoNotCross(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 >= 0 && n2 < nArray.length) {
                if (n2 == n) {
                    return false;
                }
                int n3 = n + 1;
                while (n3 < n2) {
                    if (nArray[n3] >= n2 || nArray[n3] == Integer.MIN_VALUE) {
                        return false;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return true;
    }

    public boolean isCallPosition(int n) {
        assert (this.assertBounds(n));
        return this.mNestingRelation[n] >= n;
    }

    public boolean isInternalPosition(int n) {
        assert (this.assertBounds(n));
        return this.mNestingRelation[n] == -2;
    }

    public boolean isReturnPosition(int n) {
        assert (this.assertBounds(n));
        return this.mNestingRelation[n] <= n && this.mNestingRelation[n] != -2;
    }

    public int getReturnPosition(int n) {
        if (this.isCallPosition(n)) {
            return this.mNestingRelation[n];
        }
        throw new IllegalArgumentException("Argument must be a call position.");
    }

    public int getCallPosition(int n) {
        if (this.isReturnPosition(n)) {
            return this.mNestingRelation[n];
        }
        throw new IllegalArgumentException("Argument must be a return position.");
    }

    public boolean isPendingCall(int n) {
        return this.mNestingRelation[n] == Integer.MAX_VALUE;
    }

    public boolean isPendingReturn(int n) {
        return this.mNestingRelation[n] == Integer.MIN_VALUE;
    }

    public boolean containsPendingReturns() {
        int n = 0;
        while (n < this.mWord.length) {
            if (this.isPendingReturn(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public NestedWord<LETTER> getSubWord(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The first index must be greater or equal to 0.");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("The last index must not be smaller than the first.");
        }
        if (n2 > this.length()) {
            throw new IllegalArgumentException("The last index must be strictly smaller than the word length.");
        }
        int[] nArray = new int[n2 - n];
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = this.mNestingRelation[n3];
            if (NestedWord.isSpecialNestingRelationIndex(n5)) {
                nArray[n4] = n5;
            } else if (n5 < n) {
                assert (n5 >= 0);
                nArray[n4] = Integer.MIN_VALUE;
            } else if (n5 >= n2) {
                assert (n5 < this.length());
                nArray[n4] = Integer.MAX_VALUE;
            } else {
                assert (n5 >= n && n5 < n2);
                nArray[n4] = n5 - n;
            }
            ++n3;
            ++n4;
        }
        Object[] objectArray = Arrays.copyOfRange(this.mWord, n, n2);
        return new NestedWord<Object>(objectArray, nArray);
    }

    @Override
    public NestedWord<LETTER> concatenate(NestedWord<LETTER> nestedWord) {
        Object[] objectArray = nestedWord.mWord;
        int[] nArray = nestedWord.mNestingRelation;
        int[] nArray2 = new int[this.mWord.length + objectArray.length];
        int n = this.mWord.length - 1;
        int n2 = 0;
        while (n >= 0) {
            if (this.mNestingRelation[n] == Integer.MAX_VALUE) {
                if (n2 != objectArray.length) {
                    n2 = this.findNextPendingReturn(nArray, nArray2, n2);
                }
                if (n2 == objectArray.length) {
                    nArray2[n] = this.mNestingRelation[n];
                } else {
                    nArray2[n] = this.mWord.length + n2;
                    nArray2[this.mWord.length + n2] = n;
                    ++n2;
                }
            } else {
                nArray2[n] = this.mNestingRelation[n];
            }
            --n;
        }
        while (n2 < nArray.length) {
            nArray2[this.mWord.length + n2] = NestedWord.isSpecialNestingRelationIndex(nArray[n2]) ? nArray[n2] : this.mWord.length + nArray[n2];
            ++n2;
        }
        Object[] objectArray2 = new Object[this.mWord.length + objectArray.length];
        System.arraycopy(this.mWord, 0, objectArray2, 0, this.mWord.length);
        System.arraycopy(objectArray, 0, objectArray2, this.mWord.length, objectArray.length);
        return new NestedWord<Object>(objectArray2, nArray2);
    }

    private int findNextPendingReturn(int[] nArray, int[] nArray2, int n) {
        int n2 = n;
        while (n2 < nArray.length && nArray[n2] != Integer.MIN_VALUE) {
            nArray2[this.mWord.length + n2] = nArray[n2] == -2 ? -2 : (nArray[n2] == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.mWord.length + nArray[n2]);
            ++n2;
        }
        return n2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.mWord.length) {
            if (this.isInternalPosition(n)) {
                stringBuilder.append('\"').append(this.getSymbol(n)).append(QUOTE_SPACE);
            } else if (this.isCallPosition(n)) {
                stringBuilder.append('\"').append(this.getSymbol(n)).append("\"< ");
            } else {
                assert (this.isReturnPosition(n));
                stringBuilder.append(">\"").append(this.getSymbol(n)).append(QUOTE_SPACE);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private static boolean assertValidNestedWord(Object[] objectArray, int[] nArray) {
        assert (objectArray.length == nArray.length) : "The nesting relation must contain one entry for each letter in the word.";
        assert (NestedWord.nestingRelationValuesInRange(nArray)) : "The nesting relation may only contain -2, plus infinity, minus infinity, or natural numbers.";
        assert (NestedWord.nestingRelationSymmetricNestingEdges(nArray)) : "If nestingRelation[i]=k, then nestingRelation[k]=i or nestingRelation[i] is either -2, plus infinity, or minus infinity.";
        assert (NestedWord.nestingEdgesDoNotCross(nArray)) : "Nesting edges must not cross.";
        return true;
    }

    private boolean assertBounds(int n) {
        assert (n >= 0) : "Access to position " + n + " not possible. The first position of a nested word is 0.";
        assert (n < this.mWord.length) : "Access to position " + n + " not possible. The last position of this word is " + (this.mWord.length - 1) + ".";
        return true;
    }

    private static boolean isSpecialNestingRelationIndex(int n) {
        return n == -2 || n == Integer.MAX_VALUE || n == Integer.MIN_VALUE;
    }

    public boolean hasEmptyNestingRelation() {
        int n = 0;
        while (n < this.mWord.length) {
            if (!this.isInternalPosition(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + Arrays.hashCode(this.mNestingRelation);
        n = 31 * n + Objects.hash(this.mCallPositions, this.mPendingReturns);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NestedWord nestedWord = (NestedWord)object;
        return Objects.equals(this.mCallPositions, nestedWord.mCallPositions) && Arrays.equals(this.mNestingRelation, nestedWord.mNestingRelation) && Objects.equals(this.mPendingReturns, nestedWord.mPendingReturns);
    }
}

