/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.SetOfStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.IsContained;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap4;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Quad;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NestedWordAutomatonCache<LETTER, STATE>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    private static final String STATE = "State ";
    private static final String NOT_IN_AUTOMATON = " not in automaton";
    private static final String UNKNOWN = " unknown";
    protected final IEmptyStackStateFactory<STATE> mStateFactory;
    protected final AutomataLibraryServices mServices;
    protected final ILogger mLogger;
    private final VpAlphabet<LETTER> mVpAlphabet;
    protected final NestedMap3<STATE, LETTER, STATE, IsContained> mInternalOut = new NestedMap3();
    protected final NestedMap3<STATE, LETTER, STATE, IsContained> mCallOut = new NestedMap3();
    protected final NestedMap4<STATE, STATE, LETTER, STATE, IsContained> mReturnOut = new NestedMap4();
    protected final SetOfStates<STATE> mSetOfStates;
    private static final boolean VERBOSE = false;

    public NestedWordAutomatonCache(AutomataLibraryServices automataLibraryServices, VpAlphabet<LETTER> vpAlphabet, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mVpAlphabet = vpAlphabet;
        if (iEmptyStackStateFactory == null) {
            throw new IllegalArgumentException("nwa must have stateFactory");
        }
        this.mStateFactory = iEmptyStackStateFactory;
        this.mSetOfStates = new SetOfStates<STATE>(this.mStateFactory.createEmptyStackState());
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mVpAlphabet;
    }

    public final Set<STATE> getStates() {
        return this.mSetOfStates.getStates();
    }

    public final Set<STATE> getFinalStates() {
        return this.mSetOfStates.getAcceptingStates();
    }

    @Override
    public final STATE getEmptyStackState() {
        return this.mSetOfStates.getEmptyStackState();
    }

    @Override
    public final IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    public final boolean contains(STATE STATE) {
        return this.mSetOfStates.getStates().contains(STATE);
    }

    @Override
    public final int size() {
        return this.mSetOfStates.getStates().size();
    }

    @Override
    public final Set<STATE> getInitialStates() {
        return this.mSetOfStates.getInitialStates();
    }

    @Override
    public final boolean isInitial(STATE STATE) {
        return this.mSetOfStates.isInitial(STATE);
    }

    @Override
    public final boolean isFinal(STATE STATE) {
        return this.mSetOfStates.isAccepting(STATE);
    }

    public void addState(boolean bl, boolean bl2, STATE STATE) {
        this.mSetOfStates.addState(bl, bl2, STATE);
    }

    @Override
    public final Set<LETTER> lettersInternal(STATE STATE) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE + String.valueOf(STATE) + UNKNOWN);
        }
        NestedMap2 nestedMap2 = this.mInternalOut.get(STATE);
        return nestedMap2 == null ? Collections.emptySet() : nestedMap2.keySet();
    }

    @Override
    public final Set<LETTER> lettersCall(STATE STATE) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE + String.valueOf(STATE) + UNKNOWN);
        }
        NestedMap2 nestedMap2 = this.mCallOut.get(STATE);
        return nestedMap2 == null ? Collections.emptySet() : nestedMap2.keySet();
    }

    public final Set<LETTER> lettersReturn(STATE STATE) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE + String.valueOf(STATE) + UNKNOWN);
        }
        NestedMap3 nestedMap3 = this.mReturnOut.get(STATE);
        if (nestedMap3 == null) {
            return Collections.emptySet();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Quad quad : nestedMap3.entrySet()) {
            hashSet.add(quad.getSecond());
        }
        return hashSet;
    }

    @Override
    public final Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE + String.valueOf(STATE) + UNKNOWN);
        }
        NestedMap2 nestedMap2 = this.mReturnOut.get(STATE, STATE2);
        if (nestedMap2 == null) {
            return Collections.emptySet();
        }
        return nestedMap2.keySet();
    }

    public final Collection<STATE> hierPred(STATE STATE) {
        assert (this.contains(STATE));
        NestedMap3 nestedMap3 = this.mReturnOut.get(STATE);
        if (nestedMap3 == null) {
            return Collections.emptySet();
        }
        return nestedMap3.keySet();
    }

    public final Set<STATE> succInternal(STATE STATE, LETTER LETTER) {
        assert (this.contains(STATE));
        Map map = this.mInternalOut.get(STATE, LETTER);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    public final Set<STATE> succCall(STATE STATE, LETTER LETTER) {
        assert (this.contains(STATE));
        Map map = this.mCallOut.get(STATE, LETTER);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    public final Set<STATE> succReturn(STATE STATE, STATE STATE2, LETTER LETTER) {
        assert (this.contains(STATE));
        assert (this.contains(STATE2));
        Map map = this.mReturnOut.get(STATE, STATE2, LETTER);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    @Override
    public final Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        return NestedWordAutomataUtils.constructInternalTransitionIteratorFromNestedMap(STATE, LETTER, this.mInternalOut);
    }

    @Override
    public final Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        return () -> new TransformIterator(this.mInternalOut.entries(STATE).iterator(), quad -> new OutgoingInternalTransition<Object, Object>(quad.getSecond(), quad.getThird()));
    }

    @Override
    public final Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        return NestedWordAutomataUtils.constructCallTransitionIteratorFromNestedMap(STATE, LETTER, this.mCallOut);
    }

    @Override
    public final Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        return () -> new TransformIterator(this.mCallOut.entries(STATE).iterator(), quad -> new OutgoingCallTransition<Object, Object>(quad.getSecond(), quad.getThird()));
    }

    @Override
    public final Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        return NestedWordAutomataUtils.constructReturnTransitionIteratorFromNestedMap(STATE, STATE2, LETTER, this.mReturnOut);
    }

    @Override
    public final Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        return () -> new TransformIterator(this.mReturnOut.entries(STATE, STATE2).iterator(), quin -> new OutgoingReturnTransition<Object, Object>(quin.getSecond(), quin.getThird(), quin.getFourth()));
    }

    public final boolean containsInternalTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        assert (this.contains(STATE));
        return this.mInternalOut.get(STATE, LETTER, STATE2) != null;
    }

    public final boolean containsCallTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        assert (this.contains(STATE));
        return this.mCallOut.get(STATE, LETTER, STATE2) != null;
    }

    public final boolean containsReturnTransition(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        assert (this.contains(STATE));
        assert (this.contains(STATE2));
        return this.mReturnOut.get(STATE, STATE2, LETTER, STATE3) != null;
    }

    @Override
    public String sizeInformation() {
        int n = this.getStates().size();
        return n + " states.";
    }

    private boolean assertThatAllStatesAreInAutomaton(Collection<STATE> collection) {
        boolean bl = true;
        for (STATE STATE : collection) {
            assert (bl &= this.contains(STATE)) : "State " + String.valueOf(STATE) + " not in automaton";
        }
        return bl;
    }

    public void addInternalTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE + String.valueOf(STATE) + NOT_IN_AUTOMATON);
        }
        assert (this.contains(STATE)) : "State " + String.valueOf(STATE) + " not in automaton";
        assert (this.contains(STATE2)) : "State " + String.valueOf(STATE2) + " not in automaton";
        assert (this.getVpAlphabet().getInternalAlphabet().contains(LETTER));
        this.mInternalOut.put(STATE, LETTER, STATE2, (Object)IsContained.IsContained);
    }

    public void addInternalTransitions(STATE STATE, LETTER LETTER, Collection<STATE> collection) {
        if (!this.getVpAlphabet().getInternalAlphabet().contains(LETTER)) {
            throw new IllegalArgumentException("letter" + String.valueOf(LETTER) + " not in internal alphabet");
        }
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE + String.valueOf(STATE) + NOT_IN_AUTOMATON);
        }
        assert (this.contains(STATE)) : "State " + String.valueOf(STATE) + " not in automaton";
        assert (this.assertThatAllStatesAreInAutomaton(collection));
        assert (this.getVpAlphabet().getInternalAlphabet().contains(LETTER));
        for (STATE STATE2 : collection) {
            this.addInternalTransition(STATE, LETTER, STATE2);
        }
    }

    public void addCallTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        if (!this.getVpAlphabet().getCallAlphabet().contains(LETTER)) {
            throw new IllegalArgumentException("letter" + String.valueOf(LETTER) + " not in call alphabet");
        }
        assert (this.contains(STATE)) : "State " + String.valueOf(STATE) + " not in automaton";
        assert (this.contains(STATE2)) : "State " + String.valueOf(STATE2) + " not in automaton";
        assert (this.getVpAlphabet().getCallAlphabet().contains(LETTER));
        this.mCallOut.put(STATE, LETTER, STATE2, (Object)IsContained.IsContained);
    }

    public void addCallTransitions(STATE STATE, LETTER LETTER, Collection<STATE> collection) {
        assert (this.contains(STATE)) : "State " + String.valueOf(STATE) + " not in automaton";
        assert (this.assertThatAllStatesAreInAutomaton(collection));
        assert (this.getVpAlphabet().getCallAlphabet().contains(LETTER));
        for (STATE STATE2 : collection) {
            this.addCallTransition(STATE, LETTER, STATE2);
        }
    }

    public void addReturnTransition(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        if (!this.getVpAlphabet().getReturnAlphabet().contains(LETTER)) {
            throw new IllegalArgumentException("letter" + String.valueOf(LETTER) + " not in return alphabet");
        }
        assert (this.contains(STATE)) : "State " + String.valueOf(STATE) + " not in automaton";
        assert (this.contains(STATE3)) : "State " + String.valueOf(STATE3) + " not in automaton";
        assert (this.contains(STATE2)) : "State " + String.valueOf(STATE2) + " not in automaton";
        assert (this.getVpAlphabet().getReturnAlphabet().contains(LETTER));
        this.mReturnOut.put(STATE, STATE2, LETTER, STATE3, (Object)IsContained.IsContained);
    }

    public void addReturnTransitions(STATE STATE, STATE STATE2, LETTER LETTER, Collection<STATE> collection) {
        assert (this.contains(STATE)) : "State " + String.valueOf(STATE) + " not in automaton";
        assert (this.assertThatAllStatesAreInAutomaton(collection));
        assert (this.contains(STATE2)) : "State " + String.valueOf(STATE2) + " not in automaton";
        assert (this.getVpAlphabet().getReturnAlphabet().contains(LETTER));
        for (STATE STATE3 : collection) {
            this.addReturnTransition(STATE, STATE2, LETTER, STATE3);
        }
    }

    protected final void removeInternalOut(STATE STATE, LETTER LETTER, STATE STATE2) {
        this.mInternalOut.remove(STATE, LETTER, STATE2);
    }

    protected final void removeAllInternalOut(STATE STATE) {
        this.mInternalOut.remove(STATE);
    }

    protected final void removeCallOut(STATE STATE, LETTER LETTER, STATE STATE2) {
        this.mCallOut.remove(STATE, LETTER, STATE2);
    }

    protected final void removeAllCallOut(STATE STATE) {
        this.mCallOut.remove(STATE);
    }

    protected final void removeReturnOut(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        this.mReturnOut.remove(STATE, STATE2, LETTER, STATE3);
    }

    protected final void removeAllReturnOut(STATE STATE) {
        this.mReturnOut.remove(STATE);
    }

    public final boolean isDeterministic() {
        if (this.getInitialStates().size() > 1) {
            return false;
        }
        for (STATE STATE : this.getStates()) {
            if (this.isDeterministic(STATE)) continue;
            return false;
        }
        return true;
    }

    private boolean isDeterministic(STATE STATE) {
        for (Object object : this.lettersInternal(STATE)) {
            if (this.succInternal(STATE, object).size() <= 1) continue;
            return false;
        }
        for (Object object : this.lettersCall(STATE)) {
            if (this.succCall(STATE, object).size() <= 1) continue;
            return false;
        }
        for (Object object : this.hierPred(STATE)) {
            for (LETTER LETTER : this.lettersReturn(STATE, object)) {
                if (this.succReturn(STATE, object, LETTER).size() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isTotal() {
        if (this.getInitialStates().isEmpty()) {
            return false;
        }
        for (STATE STATE : this.getStates()) {
            if (this.isTotal(STATE)) continue;
            return false;
        }
        return true;
    }

    private boolean isTotal(STATE STATE) {
        for (LETTER LETTER : this.getVpAlphabet().getInternalAlphabet()) {
            if (!this.succInternal(STATE, LETTER).isEmpty()) continue;
            return false;
        }
        for (LETTER LETTER : this.getVpAlphabet().getCallAlphabet()) {
            if (!this.succCall(STATE, LETTER).isEmpty()) continue;
            return false;
        }
        for (LETTER LETTER : this.getVpAlphabet().getReturnAlphabet()) {
            for (STATE STATE2 : this.getStates()) {
                if (!this.succReturn(STATE, STATE2, LETTER).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public final int numberOfOutgoingInternalTransitions(STATE STATE) {
        int n = 0;
        for (LETTER LETTER : this.lettersInternal(STATE)) {
            n += this.succInternal(STATE, LETTER).size();
        }
        return n;
    }

    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "nwa", this);
    }

    public int computeNumberOfInternalTransitions() {
        return this.mInternalOut.size();
    }
}

